/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.ejb.provider.BeanClassProviderHelper;
import org.eclipse.jst.j2ee.internal.ejb.provider.J2EEJavaClassProviderHelper;
import org.eclipse.jst.j2ee.internal.provider.MethodsProviderDelegate;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDJob;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDNode;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class J2EEContentProvider
implements ITreeContentProvider,
EMFRootObjectProvider.IRefreshHandlerListener {
    private final EMFRootObjectProvider rootObjectProvider = new EMFRootObjectProvider();
    private AdapterFactoryContentProvider delegateContentProvider;
    private MethodsProviderDelegate delegateMethodsProvider;
    private String viewerId = null;
    private AbstractTreeViewer viewer;

    public J2EEContentProvider() {
        this.rootObjectProvider.addRefreshHandlerListener(this);
    }

    public J2EEContentProvider(String aViewerId) {
        this.updateContentProviders(aViewerId);
        this.rootObjectProvider.addRefreshHandlerListener(this);
    }

    public Object[] getElements(Object anInputElement) {
        return this.getChildren(anInputElement);
    }

    public Object[] getChildren(Object aParentElement) {
        IProject project = null;
        ArrayList<Object> children = new ArrayList<Object>();
        if (aParentElement instanceof IAdaptable && !(aParentElement instanceof EObject) && !(aParentElement instanceof ItemProvider) && !(aParentElement instanceof J2EEJavaClassProviderHelper)) {
            project = ProjectUtilities.getProject((Object)aParentElement);
            if (project != null) {
                if (LoadingDDNode.isBeingLoaded(project)) {
                    children.add(LoadingDDNode.createPlaceHolder(project));
                } else if (this.rootObjectProvider.hasLoadedModels(project)) {
                    children.addAll(Arrays.asList(this.rootObjectProvider.getModels(project)));
                } else {
                    LoadingDDNode placeHolder = LoadingDDNode.createPlaceHolder(project);
                    if (LoadingDDNode.canBeginLoading(project)) {
                        new LoadingDDJob(this.viewer, placeHolder, (IAdaptable)aParentElement, this.rootObjectProvider).schedule();
                    }
                    children.add(placeHolder);
                }
            }
        } else {
            if (MethodsProviderDelegate.providesContentFor((Object)aParentElement)) {
                return this.delegateMethodsProvider.getChildren(aParentElement);
            }
            Object[] siblings = null;
            try {
                siblings = this.delegateContentProvider.getChildren(aParentElement);
            }
            catch (Exception e) {
                J2EENavigatorPlugin.logError(0, e.getMessage(), e);
            }
            if (siblings != null) {
                children.addAll(Arrays.asList(siblings));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object object) {
        if (MethodsProviderDelegate.providesContentFor((Object)object)) {
            return this.delegateMethodsProvider.getParent(object);
        }
        Object parent = this.delegateContentProvider.getParent(object);
        if (parent instanceof Resource) {
            parent = ProjectUtilities.getProject((EObject)((EObject)object));
        } else if (parent == null) {
            if (object instanceof BeanClassProviderHelper) {
                parent = ((BeanClassProviderHelper)object).getEjb();
            } else if (object instanceof EObject) {
                parent = ProjectUtilities.getProject((EObject)((EObject)object));
            }
        }
        return parent;
    }

    public void dispose() {
        this.rootObjectProvider.removeRefreshHandlerListener(this);
        this.delegateContentProvider.dispose();
        this.rootObjectProvider.dispose();
        this.delegateMethodsProvider.dispose();
    }

    public boolean hasChildren(Object element) {
        if (MethodsProviderDelegate.providesContentFor((Object)element)) {
            return this.delegateMethodsProvider.hasChildren(element);
        }
        if (element instanceof ItemProvider) {
            return true;
        }
        return this.delegateContentProvider.hasChildren(element);
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        String newViewerId = null;
        this.viewer = (AbstractTreeViewer)aViewer;
        if (aViewer instanceof CommonViewer) {
            newViewerId = ((CommonViewer)aViewer).getNavigatorContentService().getViewerId();
        }
        if (!(newViewerId == null || this.viewerId != null && this.viewerId.equals(newViewerId))) {
            this.updateContentProviders(newViewerId);
        }
        this.delegateContentProvider.inputChanged(aViewer, anOldInput, aNewInput);
        this.delegateMethodsProvider.inputChanged(aViewer, anOldInput, aNewInput);
    }

    private void updateContentProviders(String aViewerId) {
        if (this.delegateContentProvider != null) {
            this.delegateContentProvider.dispose();
        }
        if (this.delegateMethodsProvider != null) {
            this.delegateMethodsProvider.dispose();
        }
        DynamicAdapterFactory adapterFactory = new DynamicAdapterFactory(aViewerId);
        this.delegateContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        this.delegateMethodsProvider = new MethodsProviderDelegate((AdapterFactory)adapterFactory);
        this.viewerId = aViewerId;
    }

    public void onRefresh(final Object element) {
        if (Display.getCurrent() != null) {
            this.viewer.refresh(element, true);
        } else {
            UIJob job = new UIJob("Update the Navigator Content Viewer Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    J2EEContentProvider.this.viewer.refresh(element, true);
                    return Status.OK_STATUS;
                }
            };
            ISchedulingRule rule = new ISchedulingRule(){

                public boolean contains(ISchedulingRule rule) {
                    return rule == this;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    return rule == this;
                }
            };
            job.setRule(rule);
            job.schedule();
        }
    }
}

