/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.table.StringBasedCellEditor;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MultiStringCellEditor
extends StringBasedCellEditor {
    private EStructuralFeature eStructuralFeature;

    protected List<String> convertStringToList(String value) {
        boolean emptyStringAtEnd = value.endsWith(this.getSeparator());
        String[] split = value.split(this.getSeparator());
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < split.length) {
            list.add(split[i]);
            ++i;
        }
        if (emptyStringAtEnd) {
            list.add("");
        }
        return list;
    }

    protected String getSeparator() {
        return ";";
    }

    public MultiStringCellEditor(Composite parent) {
        super(parent, 0);
    }

    public MultiStringCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public IValueProperty getValueProperty() {
        return CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)16));
    }

    @Override
    public void instantiate(EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) {
        super.instantiate(eStructuralFeature, viewModelContext);
        this.eStructuralFeature = eStructuralFeature;
    }

    @Override
    public String getFormatedString(Object value) {
        if (value == null) {
            return "";
        }
        if (!(value instanceof List)) {
            return "";
        }
        List list = (List)value;
        String string = "";
        int i = 0;
        for (String subString : list) {
            if (i != 0) {
                string = String.valueOf(string) + this.getSeparator();
            }
            string = String.valueOf(string) + subString;
            ++i;
        }
        return string;
    }

    @Override
    public int getColumnWidthWeight() {
        return 50;
    }

    @Override
    public UpdateValueStrategy getTargetToModelStrategy(DataBindingContext databindingContext) {
        return this.withPreSetValidation(this.eStructuralFeature, (UpdateValueStrategy)new TargetToModelStrategy());
    }

    @Override
    public UpdateValueStrategy getModelToTargetStrategy(DataBindingContext databindingContext) {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                return MultiStringCellEditor.this.getFormatedString(value);
            }
        };
    }

    protected Text getText() {
        return this.text;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.getText() != null) {
            this.getText().setEditable(editable);
        }
    }

    @Override
    public Image getImage(Object value) {
        return null;
    }

    @Override
    public int getMinWidth() {
        return 0;
    }

    protected final class TargetToModelStrategy
    extends EMFUpdateValueStrategy {
        protected TargetToModelStrategy() {
        }

        public Object convert(Object value) {
            return MultiStringCellEditor.this.convertStringToList((String)value);
        }
    }
}

