/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.IInterpreterComboBlockContext;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.TclInterpreterMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class TclInterpreterComboBlock
extends AbstractInterpreterComboBlock {
    private Set<String> packages = new HashSet<String>();
    private Set<String> autoPackages = new HashSet<String>();
    private TreeViewer fElements;
    private IScriptProject scriptProject;
    private Button addButton;
    private Button addAllButton;
    private Button remove;

    protected TclInterpreterComboBlock(IInterpreterComboBlockContext context) {
        super(context);
    }

    public void createControl(Composite ancestor) {
        super.createControl(ancestor);
        Composite mainComposite = (Composite)this.getControl();
        Composite composite = new Composite(mainComposite, 0);
        GridData compositeData = new GridData(4, 4, true, true);
        compositeData.horizontalSpan = ((GridLayout)mainComposite.getLayout()).numColumns;
        composite.setLayoutData((Object)compositeData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.fElements = new TreeViewer(composite);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = new PixelConverter((Control)ancestor).convertHeightInCharsToPixels(8);
        this.fElements.getTree().setLayoutData((Object)data);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout buttonsLayout = new GridLayout(1, true);
        buttonsLayout.marginLeft = buttonsLayout.marginWidth;
        buttonsLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonsLayout);
        boolean editablePackages = this.getContext().getMode() == 0;
        this.addButton = new Button(buttons, 8);
        this.addButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addButton.setText(TclInterpreterMessages.TclInterpreterComboBlock_buttonAdd);
        if (editablePackages) {
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TclInterpreterComboBlock.this.addPackage();
                }
            });
        } else {
            this.addButton.setEnabled(false);
        }
        this.addAllButton = new Button(buttons, 8);
        this.addAllButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addAllButton.setText(TclInterpreterMessages.TclInterpreterComboBlock_buttonAddAll);
        if (editablePackages) {
            this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TclInterpreterComboBlock.this.addAllPackages();
                }
            });
        } else {
            this.addAllButton.setEnabled(false);
        }
        this.remove = new Button(buttons, 8);
        this.remove.setText(TclInterpreterMessages.TclInterpreterComboBlock_buttonRemove);
        this.remove.setLayoutData((Object)new GridData(4, 4, false, false));
        if (editablePackages) {
            this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TclInterpreterComboBlock.this.removePackage();
                }
            });
            this.remove.setEnabled(false);
        } else {
            this.remove.setEnabled(false);
        }
        this.fElements.setContentProvider((IContentProvider)new PackagesContentProvider());
        this.fElements.setLabelProvider((IBaseLabelProvider)new PackagesLabelProvider());
        if (editablePackages) {
            this.fElements.addSelectionChangedListener(event -> this.remove.setEnabled(this.canRemove(event.getSelection())));
        }
        this.fElements.setComparator((ViewerComparator)new PackageComparator());
        this.showPackages();
        this.addPropertyChangeListener(event -> {
            if (event.getProperty().equals("PROPERTY_INTERPRETER")) {
                this.refreshView();
            }
        });
    }

    private void showPackages() {
        if (this.fElements != null) {
            PackageInput input = new PackageInput();
            input.addCategory(TclInterpreterMessages.TclInterpreterComboBlock_CategoryManual, this.packages, false);
            input.addCategory(TclInterpreterMessages.TclInterpreterComboBlock_CategoryAutomatic, this.autoPackages, true);
            this.fElements.setInput((Object)input);
            this.fElements.expandToLevel(2);
        }
    }

    protected boolean canRemove(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object pkg : ss) {
                if (pkg instanceof Package) {
                    if (((Package)pkg).parent.readOnly) {
                        return false;
                    }
                    if (this.packages.contains(((Package)pkg).name)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected void removePackage() {
        ISelection selection = this.fElements.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            int updates = 0;
            for (Object pkg : ss) {
                if (!(pkg instanceof Package) || ((Package)pkg).parent.readOnly || !this.packages.remove(((Package)pkg).name)) continue;
                ++updates;
            }
            if (updates != 0) {
                this.refreshView();
            }
        }
    }

    private void refreshView() {
        this.refreshView(null);
    }

    private void refreshView(String selection) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.fElements.getControl().isDisposed()) {
                return;
            }
            this.fElements.refresh();
            if (selection != null) {
                PackageCategory category = ((PackageInput)this.fElements.getInput()).get(TclInterpreterMessages.TclInterpreterComboBlock_CategoryManual);
                this.fElements.setSelection((ISelection)new StructuredSelection((Object)new Package(category, selection)));
            }
        });
    }

    protected void addPackage() {
        IInterpreterInstall install = this.getInterpreter();
        if (install == null) {
            install = ScriptRuntime.getDefaultInterpreterInstall((String)"org.eclipse.dltk.tcl.core.nature", (IEnvironment)LocalEnvironment.getInstance());
        }
        if (install != null) {
            Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
            final ArrayList names = new ArrayList();
            names.addAll(packages);
            Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
            ListDialog dialog = new ListDialog(this.fElements.getControl().getShell());
            dialog.setTitle(TclInterpreterMessages.TclInterpreterComboBlock_title);
            dialog.setContentProvider(new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return names.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            dialog.setLabelProvider((ILabelProvider)new PackagesLabelProvider());
            dialog.setInput(names);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                int i = 0;
                while (i < result.length) {
                    String pkg = (String)result[i];
                    this.packages.add(pkg);
                    ++i;
                }
                this.refreshView((String)(result.length != 0 ? result[0] : null));
            }
        } else {
            MessageBox box = new MessageBox(this.fElements.getControl().getShell(), 65576);
            box.setText(TclInterpreterMessages.TclInterpreterComboBlock_errorTitle);
            box.setMessage(TclInterpreterMessages.TclInterpreterComboBlock_errorMessage);
            box.open();
        }
    }

    protected void addAllPackages() {
        IInterpreterInstall install;
        block4: {
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.scriptProject);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (install != null) {
            Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
            this.packages.addAll(packages);
            this.refreshView();
        } else {
            MessageBox box = new MessageBox(this.fElements.getControl().getShell(), 65570);
            box.setText(TclInterpreterMessages.TclInterpreterComboBlock_errorTitle);
            box.setText(TclInterpreterMessages.TclInterpreterComboBlock_errorMessage);
            box.open();
        }
    }

    public void initialize(IScriptProject project) {
        this.scriptProject = project;
        HashSet set = new HashSet();
        HashSet autoSet = new HashSet();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, set, autoSet);
        this.packages.clear();
        this.packages.addAll(set);
        this.autoPackages.clear();
        this.autoPackages.addAll(autoSet);
        this.showPackages();
    }

    public IBuildpathEntry getEntry() {
        IBuildpathEntry createPackagesContainer = InterpreterContainerHelper.createPackagesContainer(this.packages, this.autoPackages, (IPath)this.getInterpreterPath());
        return createPackagesContainer;
    }

    private static class Package {
        final PackageCategory parent;
        final String name;

        public Package(PackageCategory parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Package) {
                Package other = (Package)obj;
                return this.name.equals(other.name) && this.parent.equals(other.parent);
            }
            return false;
        }
    }

    private static class PackageCategory {
        final String category;
        final Set<String> packages;
        final boolean readOnly;

        public PackageCategory(String category, Set<String> packagesSet, boolean readOnly) {
            this.category = category;
            this.readOnly = readOnly;
            this.packages = packagesSet;
        }

        public Package[] getPackages() {
            Package[] result = new Package[this.packages.size()];
            int index = 0;
            for (String packageName : this.packages) {
                result[index++] = new Package(this, packageName);
            }
            return result;
        }

        public int hashCode() {
            return this.category.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PackageCategory) {
                PackageCategory other = (PackageCategory)obj;
                return this.category.equals(other.category);
            }
            return false;
        }
    }

    private static class PackageComparator
    extends ViewerComparator {
        private PackageComparator() {
        }

        public int category(Object element) {
            if (element instanceof PackageCategory) {
                PackageCategory category = (PackageCategory)element;
                return category.readOnly ? 2 : 1;
            }
            return super.category(element);
        }
    }

    private static class PackageInput {
        private final List<PackageCategory> categories = new ArrayList<PackageCategory>();

        private PackageInput() {
        }

        public void addCategory(String category, Set<String> packagesSet, boolean readOnly) {
            this.categories.add(new PackageCategory(category, packagesSet, readOnly));
        }

        public PackageCategory[] getCategories() {
            return this.categories.toArray(new PackageCategory[this.categories.size()]);
        }

        public PackageCategory get(String categoryName) {
            for (PackageCategory category : this.categories) {
                if (!categoryName.equals(category.category)) continue;
                return category;
            }
            throw new IllegalArgumentException(categoryName);
        }
    }

    private static class PackagesContentProvider
    implements ITreeContentProvider {
        private PackagesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PackageCategory) {
                return ((PackageCategory)parentElement).getPackages();
            }
            return Util.EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            if (element instanceof Package) {
                return ((Package)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PackageCategory) {
                return !((PackageCategory)element).packages.isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PackageInput) {
                return ((PackageInput)inputElement).getCategories();
            }
            return Util.EMPTY_ARRAY;
        }
    }

    public class PackagesLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof Package) {
                Set names;
                String packageName = ((Package)element).name;
                IInterpreterInstall install = TclInterpreterComboBlock.this.getInterpreter();
                if (install == null) {
                    install = ScriptRuntime.getDefaultInterpreterInstall((String)"org.eclipse.dltk.tcl.core.nature", (IEnvironment)LocalEnvironment.getInstance());
                }
                if (install != null && !(names = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install)).contains(packageName)) {
                    return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.error_obj.png");
                }
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.package_obj.png");
            }
            if (element instanceof PackageCategory) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_obj.png");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Package) {
                return ((Package)element).name;
            }
            if (element instanceof PackageCategory) {
                return ((PackageCategory)element).category;
            }
            return super.getText(element);
        }
    }
}

