/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ChangeBuildpathOperation;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;

public class SetVariablesOperation
extends ChangeBuildpathOperation {
    String[] variableNames;
    IPath[] variablePaths;
    boolean updatePreferences;

    public SetVariablesOperation(String[] variableNames, IPath[] variablePaths, boolean updatePreferences) {
        super(new IModelElement[]{ModelManager.getModelManager().getModel()}, !ResourcesPlugin.getWorkspace().isTreeLocked());
        this.variableNames = variableNames;
        this.variablePaths = variablePaths;
        this.updatePreferences = updatePreferences;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeOperation() throws ModelException {
        this.checkCanceled();
        try {
            this.beginTask("", 1);
            ModelManager manager = ModelManager.getModelManager();
            if (manager.variablePutIfInitializingWithSameValue(this.variableNames, this.variablePaths)) {
                return;
            }
            int varLength = this.variableNames.length;
            HashMap<ScriptProject, IBuildpathEntry[]> affectedProjectBuildpaths = new HashMap<ScriptProject, IBuildpathEntry[]>(5);
            IScriptModel model = this.getModel();
            int discardCount = 0;
            int i = 0;
            while (i < varLength) {
                String variableName = this.variableNames[i];
                IPath oldPath = manager.variableGet(variableName);
                if (oldPath == ModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                    oldPath = null;
                }
                if (oldPath != null && oldPath.equals((Object)this.variablePaths[i])) {
                    this.variableNames[i] = null;
                    ++discardCount;
                }
                ++i;
            }
            if (discardCount > 0) {
                if (discardCount == varLength) {
                    return;
                }
                int changedLength = varLength - discardCount;
                String[] changedVariableNames = new String[changedLength];
                IPath[] changedVariablePaths = new IPath[changedLength];
                int i2 = 0;
                int index = 0;
                while (i2 < varLength) {
                    if (this.variableNames[i2] != null) {
                        changedVariableNames[index] = this.variableNames[i2];
                        changedVariablePaths[index] = this.variablePaths[i2];
                        ++index;
                    }
                    ++i2;
                }
                this.variableNames = changedVariableNames;
                this.variablePaths = changedVariablePaths;
                varLength = changedLength;
            }
            if (this.isCanceled()) {
                return;
            }
            IScriptProject[] projects = model.getScriptProjects();
            int i3 = 0;
            int projectLength = projects.length;
            while (i3 < projectLength) {
                ScriptProject project = (ScriptProject)projects[i3];
                IBuildpathEntry[] Buildpath = project.getRawBuildpath();
                int j = 0;
                int cpLength = Buildpath.length;
                block13: while (j < cpLength) {
                    IBuildpathEntry entry = Buildpath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = this.variableNames[k];
                        if (entry.getEntryKind() == 4) {
                            IPath sourceRootPath;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjectBuildpaths.put(project, project.getResolvedBuildpath());
                                break block13;
                            }
                            IPath sourcePath = entry.getPath();
                            if (sourcePath != null && variableName.equals(sourcePath.segment(0)) || (sourceRootPath = entry.getPath()) != null && variableName.equals(sourceRootPath.segment(0))) {
                                affectedProjectBuildpaths.put(project, project.getResolvedBuildpath());
                                break block13;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < varLength) {
                manager.variablePut(this.variableNames[i3], this.variablePaths[i3]);
                if (this.updatePreferences) {
                    manager.variablePreferencesPut(this.variableNames[i3], this.variablePaths[i3]);
                }
                ++i3;
            }
            if (affectedProjectBuildpaths.isEmpty()) return;
            try {
                Iterator projectsToUpdate = affectedProjectBuildpaths.keySet().iterator();
                while (projectsToUpdate.hasNext()) {
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                        return;
                    }
                    ScriptProject affectedProject = (ScriptProject)projectsToUpdate.next();
                    if (!this.canChangeResources) continue;
                    affectedProject.getProject().touch(this.progressMonitor);
                }
                return;
            }
            catch (CoreException e) {
                if (ModelManager.BP_RESOLVE_VERBOSE) {
                    e.printStackTrace();
                }
                if (!(e instanceof ModelException)) throw new ModelException(e);
                throw (ModelException)e;
            }
        }
        finally {
            this.done();
        }
    }
}

