/**
 * **IMPORTANT** this module should not depend on `vscode-languageserver` only protocol and types
 */
import lsp from 'vscode-languageserver-protocol';
import type tsp from 'typescript/lib/protocol.d.js';
import type { TraceValue } from './tsServer/tracer.js';
export declare namespace TypeScriptRenameRequest {
    const type: lsp.RequestType<lsp.TextDocumentPositionParams, void, void>;
}
export declare class DisplayPartKind {
    static readonly functionName = "functionName";
    static readonly methodName = "methodName";
    static readonly parameterName = "parameterName";
    static readonly propertyName = "propertyName";
    static readonly punctuation = "punctuation";
    static readonly text = "text";
}
export declare enum SemicolonPreference {
    Ignore = "ignore",
    Insert = "insert",
    Remove = "remove"
}
export interface SupportedFeatures {
    codeActionDisabledSupport?: boolean;
    completionInsertReplaceSupport?: boolean;
    completionLabelDetails?: boolean;
    completionSnippets?: boolean;
    definitionLinkSupport?: boolean;
    diagnosticsTagSupport?: boolean;
}
export interface TypeScriptPlugin {
    name: string;
    location: string;
}
export interface TypeScriptInitializationOptions {
    disableAutomaticTypingAcquisition?: boolean;
    hostInfo?: string;
    locale?: string;
    maxTsServerMemory?: number;
    npmLocation?: string;
    plugins: TypeScriptPlugin[];
    preferences?: tsp.UserPreferences;
    tsserver?: TsserverOptions;
}
interface TsserverOptions {
    /**
     * The path to the directory where the `tsserver` log files will be created.
     * If not provided, the log files will be created within the workspace, inside the `.log` directory.
     * If no workspace root is provided when initializating the server and no custom path is specified then
     * the logs will not be created.
     * @default undefined
     */
    logDirectory?: string;
    /**
     * Verbosity of the information logged into the `tsserver` log files.
     *
     * Log levels from least to most amount of details: `'terse'`, `'normal'`, `'requestTime`', `'verbose'`.
     * Enabling particular level also enables all lower levels.
     *
     * @default 'off'
     */
    logVerbosity?: 'off' | 'terse' | 'normal' | 'requestTime' | 'verbose';
    /**
     * The path to the `tsserver.js` file or the typescript lib directory. For example: `/Users/me/typescript/lib/tsserver.js`.
     */
    path?: string;
    /**
     * The verbosity of logging the tsserver communication through the LSP messages.
     * This doesn't affect the file logging.
     * @default 'off'
     */
    trace?: TraceValue;
}
export declare type TypeScriptInitializeParams = lsp.InitializeParams & {
    initializationOptions?: Partial<TypeScriptInitializationOptions>;
};
export {};
//# sourceMappingURL=ts-protocol.d.ts.map