/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.condition;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.hamcrest.Matcher;

public class NamedThreadHasStatus
extends AbstractWaitCondition {
    private Matcher<String> nameMatcher;
    private Thread.State state;
    private Thread.State resultStatus;
    private boolean returnTrueIfDoesNotExist;
    private Set<Thread> currentThreads = Thread.getAllStackTraces().keySet();

    public NamedThreadHasStatus(Matcher<String> nameMatcher, Thread.State state, boolean returnTrueIfDoesNotExist) {
        this.nameMatcher = nameMatcher;
        this.state = state;
        this.returnTrueIfDoesNotExist = returnTrueIfDoesNotExist;
    }

    public boolean test() {
        this.currentThreads = Thread.getAllStackTraces().keySet();
        Iterator<Thread> itThread = this.currentThreads.iterator();
        boolean threadNotFound = true;
        boolean hasState = false;
        while (threadNotFound && itThread.hasNext()) {
            Thread thread = itThread.next();
            if (!this.nameMatcher.matches((Object)thread.getName())) continue;
            threadNotFound = false;
            hasState = thread.getState().equals((Object)this.state);
            if (!hasState) continue;
            this.resultStatus = thread.getState();
        }
        return hasState || threadNotFound && this.returnTrueIfDoesNotExist;
    }

    public String description() {
        return "thread with name matching" + this.nameMatcher + " has state " + (Object)((Object)this.state);
    }

    public String errorMessageWhile() {
        return this.createErrorMessageWithThreadList("The following threads are still available:\n");
    }

    public String errorMessageUntil() {
        return this.createErrorMessageWithThreadList("The threads have not been found.The following threads are available:\n");
    }

    private String createErrorMessageWithThreadList(String messageStart) {
        StringBuilder message = new StringBuilder(messageStart);
        for (Thread thread : this.currentThreads) {
            if (thread == null) continue;
            message.append(thread.getName());
            message.append(":");
            message.append((Object)thread.getState());
            message.append("\n");
        }
        return message.toString();
    }

    public Thread.State getResult() {
        return this.resultStatus;
    }
}

