/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.common.TypedModelConfiguration;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfigurations;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class TypedModelsConfiguration {
    private final @NonNull Map<@Nullable String, @NonNull TypedModelConfiguration> name2typedModelConfigurations = new HashMap<String, TypedModelConfiguration>();
    private final @NonNull List<@NonNull TypedModel> inputTypedModels = new ArrayList<TypedModel>();
    private final @NonNull List<@NonNull TypedModel> intermediateTypedModels = new ArrayList<TypedModel>();
    private final @NonNull List<@NonNull TypedModel> outputOnlyTypedModels = new ArrayList<TypedModel>();
    private final @NonNull List<@NonNull TypedModel> outputTypedModels = new ArrayList<TypedModel>();
    private final @NonNull List<@NonNull TypedModel> unusedTypedModels = new ArrayList<TypedModel>();

    public static @NonNull TypedModelsConfigurations createTypedModelsConfigurations(@NonNull String outputName) {
        return TypedModelsConfiguration.createTypedModelsConfigurations(Collections.singletonList(Collections.singletonList(outputName)));
    }

    public static @NonNull TypedModelsConfigurations createTypedModelsConfigurations(@NonNull Iterable<@NonNull Iterable<@NonNull String>> outputNamesList) {
        TypedModelsConfigurations typedModelsConfigurations = new TypedModelsConfigurations();
        for (Iterable<String> outputNames : outputNamesList) {
            TypedModelsConfiguration typedModelsConfiguration = new TypedModelsConfiguration(new String[0]);
            for (String outputName : outputNames) {
                typedModelsConfiguration.addTypedModelConfiguration(new TypedModelConfiguration(outputName, TypedModelConfiguration.Mode.OUTPUT));
            }
            typedModelsConfigurations.add(typedModelsConfiguration);
        }
        return typedModelsConfigurations;
    }

    public TypedModelsConfiguration(String ... enforcedOutputNames) {
        if (enforcedOutputNames != null) {
            String[] stringArray = enforcedOutputNames;
            int n = enforcedOutputNames.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String enforcedOutputName = stringArray[n2];
                this.addTypedModelConfiguration(new TypedModelConfiguration(enforcedOutputName, TypedModelConfiguration.Mode.OUTPUT));
                ++n2;
            }
        }
    }

    public void addTypedModelConfiguration(@NonNull TypedModelConfiguration typedModelConfiguration) {
        String name = typedModelConfiguration.getName();
        TypedModelConfiguration oldTypedModel = this.name2typedModelConfigurations.put(name, typedModelConfiguration);
        assert (oldTypedModel == null);
    }

    public @Nullable TypedModelConfiguration basicGetTypedModelConfiguration(@NonNull TypedModel typedModel) {
        return this.name2typedModelConfigurations.get(typedModel.getName());
    }

    public @NonNull Iterable<@NonNull TypedModel> getInputTypedModels() {
        return this.inputTypedModels;
    }

    public @NonNull Iterable<@NonNull TypedModel> getIntermediateTypedModels() {
        return this.intermediateTypedModels;
    }

    public @NonNull Iterable<@NonNull TypedModel> getOutputOnlyTypedModels() {
        return this.outputOnlyTypedModels;
    }

    public @NonNull Iterable<@NonNull TypedModel> getOutputTypedModels() {
        return this.outputTypedModels;
    }

    public @Nullable String getTargetName() {
        return null;
    }

    public @NonNull TypedModel getTargetTypedModel() {
        return this.outputTypedModels.get(0);
    }

    public @NonNull TypedModelConfiguration getTypedModelConfiguration(@NonNull TypedModel typedModel) {
        return (TypedModelConfiguration)ClassUtil.nonNullState((Object)this.name2typedModelConfigurations.get(typedModel.getName()));
    }

    public @NonNull Iterable<@NonNull TypedModel> getUnusedTypedModels() {
        return this.unusedTypedModels;
    }

    public boolean hasTargetTypedModel() {
        return this.outputTypedModels.size() > 0;
    }

    public boolean isInput(@NonNull TypedModel typedModel) {
        return this.inputTypedModels.contains(typedModel);
    }

    public boolean isIntermediate(@NonNull TypedModel typedModel) {
        return this.intermediateTypedModels.contains(typedModel);
    }

    public boolean isOutput(@NonNull TypedModel typedModel) {
        return this.outputTypedModels.contains(typedModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable String reconcile(@NonNull Transformation transformation) {
        this.inputTypedModels.clear();
        this.intermediateTypedModels.clear();
        this.outputOnlyTypedModels.clear();
        this.outputTypedModels.clear();
        this.unusedTypedModels.clear();
        @NonNull Iterable typedModels = QVTbaseUtil.getModelParameters((Transformation)transformation);
        for (TypedModel typedModel : typedModels) {
            String name = typedModel.getName();
            if (this.name2typedModelConfigurations.containsKey(name)) continue;
            TypedModelConfiguration.Mode mode = typedModel.isIsPrimitive() || typedModel.isIsThis() || typedModel.isIsTrace() ? TypedModelConfiguration.Mode.INTERMEDIATE : TypedModelConfiguration.Mode.INPUT;
            TypedModelConfiguration typedModelConfiguration = new TypedModelConfiguration(name, mode);
            this.addTypedModelConfiguration(typedModelConfiguration);
        }
        StringBuilder s = null;
        for (TypedModelConfiguration typedModelConfiguration : this.name2typedModelConfigurations.values()) {
            String s2 = typedModelConfiguration.reconcile(typedModels);
            if (s2 != null) {
                if (s == null) {
                    s = new StringBuilder();
                } else {
                    s.append("\n");
                }
                s.append(s2);
                continue;
            }
            TypedModel typedModel = typedModelConfiguration.basicGetTypedModel();
            if (typedModel == null) continue;
            if (typedModelConfiguration.isInput()) {
                this.inputTypedModels.add(typedModel);
            }
            if (typedModelConfiguration.isIntermediate()) {
                this.intermediateTypedModels.add(typedModel);
            }
            if (typedModelConfiguration.isOutput()) {
                this.outputTypedModels.add(typedModel);
                if (!typedModelConfiguration.isInput()) {
                    this.outputOnlyTypedModels.add(typedModel);
                }
            }
            if (!typedModelConfiguration.isUnused()) continue;
            this.unusedTypedModels.add(typedModel);
        }
        return s != null ? s.toString() : null;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        s.append("{");
        for (TypedModel typedModel : this.inputTypedModels) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(typedModel.getName());
            isFirst = false;
        }
        s.append("}->{");
        isFirst = true;
        for (TypedModel typedModel : this.intermediateTypedModels) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(typedModel.getName());
            isFirst = false;
        }
        s.append("}->{");
        isFirst = true;
        for (TypedModel typedModel : this.outputTypedModels) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(typedModel.getName());
            isFirst = false;
        }
        s.append("}");
        return s.toString();
    }
}

