/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.handlers.IMissingConnectionHandler;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;

public class RemoteLocation {
    private String fConnectionTypeId;
    private String fConnectionName;
    private String fDirectory;
    private IRemoteConnectionType fConnectionType;
    private IRemoteConnection fConnection;

    public static String resolveString(IProject project, String path) {
        if (!path.startsWith("${") || !path.endsWith("}")) {
            return path;
        }
        String newPath = path.substring(2, path.length() - 1);
        String variable = newPath.split(":")[0];
        IPathVariableManager pvm = project.getPathVariableManager();
        String value = pvm.getURIValue(variable.toUpperCase()).toString();
        if (value == null) {
            return path;
        }
        if ((value = value.replaceFirst("file:", "")).endsWith("/") || value.endsWith("\\")) {
            value = value.substring(0, path.length() - 1);
        }
        return newPath.replaceFirst(String.valueOf(variable) + ":*", value);
    }

    public RemoteLocation() {
    }

    public RemoteLocation(RemoteLocation rl) {
        this.fConnectionTypeId = rl.fConnectionTypeId;
        this.fConnectionName = rl.fConnectionName;
        this.fDirectory = rl.fDirectory;
        this.fConnectionType = rl.fConnectionType;
        this.fConnection = rl.fConnection;
    }

    public String getConnectionName() {
        return this.fConnectionName;
    }

    public String getDirectory() {
        return this.fDirectory;
    }

    public String getDirectory(IProject project) {
        return RemoteLocation.resolveString(project, this.fDirectory);
    }

    public IRemoteConnection getConnection() throws MissingConnectionException {
        if (this.fConnectionType == null) {
            this.fConnectionType = RDTSyncCorePlugin.getService(IRemoteServicesManager.class).getConnectionType(this.fConnectionTypeId);
            this.fConnection = null;
        }
        if (this.fConnection == null) {
            IMissingConnectionHandler mcHandler;
            this.fConnection = this.fConnectionType.getConnection(this.fConnectionName);
            if (this.fConnection == null && (mcHandler = SyncManager.getDefaultMissingConnectionHandler()) != null) {
                mcHandler.handle(this.fConnectionType, this.fConnectionName);
                this.fConnection = this.fConnectionType.getConnection(this.fConnectionName);
            }
        }
        if (this.fConnection == null) {
            throw new MissingConnectionException(this.fConnectionName);
        }
        return this.fConnection;
    }

    public String getConnectionTypeId() {
        return this.fConnectionTypeId;
    }

    public void setConnection(IRemoteConnection connection) {
        this.fConnectionType = connection.getConnectionType();
        this.fConnectionTypeId = connection.getConnectionType().getId();
        this.fConnectionName = connection.getName();
        this.fConnection = connection;
    }

    public void setConnectionName(String connectionName) {
        this.fConnectionName = connectionName;
        this.fConnection = null;
    }

    public void setLocation(String location) {
        this.fDirectory = location;
    }

    public void setConnectionTypeId(String connectionTypeId) {
        this.fConnectionTypeId = connectionTypeId;
        this.fConnectionType = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fConnectionName == null ? 0 : this.fConnectionName.hashCode());
        result = 31 * result + (this.fDirectory == null ? 0 : this.fDirectory.hashCode());
        result = 31 * result + (this.fConnectionTypeId == null ? 0 : this.fConnectionTypeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteLocation other = (RemoteLocation)obj;
        if (this.fConnectionName == null ? other.fConnectionName != null : !this.fConnectionName.equals(other.fConnectionName)) {
            return false;
        }
        if (this.fDirectory == null ? other.fDirectory != null : !this.fDirectory.equals(other.fDirectory)) {
            return false;
        }
        return !(this.fConnectionTypeId == null ? other.fConnectionTypeId != null : !this.fConnectionTypeId.equals(other.fConnectionTypeId));
    }
}

