/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.preferences;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.buildpath.BuildPathManager;
import org.eclipse.php.composer.core.resources.IComposerProject;
import org.eclipse.php.composer.internal.core.resources.ComposerProject;
import org.eclipse.php.composer.ui.preferences.BuildPathExclusionWizard;
import org.eclipse.ui.preferences.WizardPropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class BuildPathManagementPage
extends WizardPropertyPage {
    private IScriptProject scriptProject;
    private BuildPathExclusionWizard wizard;

    protected IWizard createWizard() {
        BPListElement elem = new BPListElement(this.scriptProject, 3, false);
        ComposerProject composerProject = new ComposerProject(this.scriptProject.getProject());
        IPath path = this.scriptProject.getPath().append(composerProject.getVendorDir());
        elem.setPath(path);
        IEclipsePreferences projectPreferences = ComposerPlugin.getDefault().getProjectPreferences(this.scriptProject.getProject());
        String stored = projectPreferences.get("org.eclipse.php.composer.corebuildpath.includes.excludes", null);
        if (stored != null) {
            IBuildpathEntry buildpathEntry = this.scriptProject.decodeBuildpathEntry(stored);
            IPath[] iPathArray = buildpathEntry.getInclusionPatterns();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath includePath = iPathArray[n2];
                elem.addToInclusion(path.append(includePath));
                ++n2;
            }
            iPathArray = buildpathEntry.getExclusionPatterns();
            n = iPathArray.length;
            n2 = 0;
            while (n2 < n) {
                IPath excludePath = iPathArray[n2];
                elem.addToExclusions(path.append(excludePath));
                ++n2;
            }
        }
        this.wizard = new BuildPathExclusionWizard(new BPListElement[0], elem);
        return this.wizard;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        if (element instanceof IProject) {
            this.scriptProject = DLTKCore.create((IProject)((IProject)element));
            return;
        }
        this.scriptProject = (IScriptProject)element;
    }

    protected void applyChanges() {
        List elements = this.wizard.getModifiedElements();
        BPListElement element = (BPListElement)elements.get(0);
        IBuildpathEntry buildpathEntry = element.getBuildpathEntry();
        if (buildpathEntry instanceof BuildpathEntry) {
            BuildpathEntry entry = (BuildpathEntry)buildpathEntry;
            String encodeBuildpathEntry = this.scriptProject.encodeBuildpathEntry((IBuildpathEntry)entry);
            IEclipsePreferences projectPreferences = ComposerPlugin.getDefault().getProjectPreferences(this.scriptProject.getProject());
            projectPreferences.put("org.eclipse.php.composer.corebuildpath.includes.excludes", encodeBuildpathEntry);
            try {
                projectPreferences.flush();
                ComposerProject composerProject = new ComposerProject(this.scriptProject.getProject());
                BuildPathManager bpm = new BuildPathManager((IComposerProject)composerProject);
                bpm.update();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }
}

