/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.core.mappings.transformers.CoreFieldTransformer;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.TransformationMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;

public class FieldTransformerNodeValue
extends NodeValue {
    private CoreFieldTransformer fieldTransformer;
    private TransformationMapping transformationMapping;
    private Field xmlField;

    public FieldTransformerNodeValue(TransformationMapping transformationMapping) {
        this.transformationMapping = transformationMapping;
    }

    public CoreFieldTransformer getFieldTransformer() {
        return this.fieldTransformer;
    }

    public void setFieldTransformer(CoreFieldTransformer fieldTransformer) {
        this.fieldTransformer = fieldTransformer;
    }

    public Field getXMLField() {
        return this.xmlField;
    }

    public void setXMLField(Field xmlField) {
        this.xmlField = xmlField;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object value = this.fieldTransformer.buildFieldValue(object, this.getXMLField().getXPath(), session);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (value == null) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        if (this.getXMLField().getLastXPathFragment().isAttribute()) {
            marshalRecord.add(this.getXMLField(), value);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            marshalRecord.closeStartGroupingElements(groupingFragment);
            marshalRecord.add(this.getXMLField(), value);
        }
        return true;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        ConversionManager conversionManager = (ConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager();
        Object objectValue = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(this.xmlField, value, conversionManager, unmarshalRecord);
        this.transformationMapping.writeFromAttributeIntoRow(unmarshalRecord, this.xmlField, objectValue, false);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object value = unmarshalRecord.getCharacters().toString();
        unmarshalRecord.resetStringBuffer();
        ConversionManager conversionManager = unmarshalRecord.getConversionManager();
        if (unmarshalRecord.getTypeQName() != null) {
            Class typeClass = this.xmlField.getJavaClass(unmarshalRecord.getTypeQName(), conversionManager);
            value = conversionManager.convertObject(value, typeClass, unmarshalRecord.getTypeQName());
        } else {
            value = unmarshalRecord.getXMLReader().convertValueBasedOnSchemaType(this.xmlField, value, conversionManager, unmarshalRecord);
        }
        this.transformationMapping.writeFromAttributeIntoRow(unmarshalRecord, this.xmlField, value, true);
    }
}

