/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.collaborationuse.xtext.ui.contributions;

import com.google.inject.Injector;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.textedit.collaborationuse.xtext.ui.contributions.UMLCollaborationUseEditorUtil;
import org.eclipse.papyrus.uml.textedit.collaborationuse.xtext.ui.internal.UmlCollaborationUseActivator;
import org.eclipse.papyrus.uml.textedit.collaborationuse.xtext.umlCollaborationUse.CollaborationUseRule;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtext.EcoreUtil2;

public class CollaborationUseEditor
extends DefaultXtextDirectEditorConfiguration {
    private final IUndoableOperation getUpdateCommand(CollaborationUse collaborationUse, VisibilityKind newVisibility, Collaboration newType, String newName) {
        CompositeCommand cc = new CompositeCommand("Set values for CollaborationUse");
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)collaborationUse);
        if (provider != null) {
            ICommand setNameCommand = null;
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)collaborationUse) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)collaborationUse) != null) {
                ModelSet modelSet = (ModelSet)collaborationUse.eResource().getResourceSet();
                setNameCommand = new EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand((EditingDomain)modelSet.getTransactionalEditingDomain(), (NamedElement)collaborationUse, newName, null));
            } else {
                SetRequest setNameRequest = new SetRequest((EObject)collaborationUse, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName);
                setNameCommand = provider.getEditCommand((IEditCommandRequest)setNameRequest);
            }
            cc.add((IUndoableOperation)setNameCommand);
            if (!collaborationUse.getVisibility().equals((Object)newVisibility)) {
                cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)new SetRequest((EObject)collaborationUse, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Visibility(), (Object)newVisibility)));
            }
            cc.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)new SetRequest((EObject)collaborationUse, (EStructuralFeature)UMLPackage.eINSTANCE.getCollaborationUse_Type(), (Object)newType)));
        }
        return cc;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof CollaborationUse) {
            return UMLCollaborationUseEditorUtil.getLabel((CollaborationUse)editedObject).trim();
        }
        return "not a CollaborationUse";
    }

    public Injector getInjector() {
        return UmlCollaborationUseActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.collaborationuse.xtext.UmlCollaborationUse");
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        if (!(umlObject instanceof CollaborationUse) || xtextObject == null) {
            return null;
        }
        CollaborationUse collaborationUse = (CollaborationUse)umlObject;
        if ((xtextObject = EcoreUtil2.getContainerOfType((EObject)xtextObject, CollaborationUseRule.class)) == null) {
            return null;
        }
        CollaborationUseRule propertyRuleObject = (CollaborationUseRule)xtextObject;
        String newName = propertyRuleObject.getName();
        Collaboration newType = propertyRuleObject.getType() != null ? (Collaboration)propertyRuleObject.getType().getType() : null;
        VisibilityKind newVisibility = VisibilityKind.PUBLIC_LITERAL;
        if (propertyRuleObject.getVisibility() != null) {
            switch (propertyRuleObject.getVisibility()) {
                case PUBLIC: {
                    newVisibility = VisibilityKind.PUBLIC_LITERAL;
                    break;
                }
                case PACKAGE: {
                    newVisibility = VisibilityKind.PACKAGE_LITERAL;
                    break;
                }
                case PRIVATE: {
                    newVisibility = VisibilityKind.PRIVATE_LITERAL;
                    break;
                }
                case PROTECTED: {
                    newVisibility = VisibilityKind.PROTECTED_LITERAL;
                    break;
                }
                default: {
                    newVisibility = VisibilityKind.PUBLIC_LITERAL;
                }
            }
        }
        IUndoableOperation updateCommand = this.getUpdateCommand(collaborationUse, newVisibility, newType, newName);
        return (ICommand)updateCommand;
    }
}

