/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.strategy;

import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public class StrategyBasedContentProvider
extends EncapsulatedContentProvider {
    protected TreeBrowseStrategy browseStrategy;
    protected TreeBrowseStrategy revealStrategy;
    protected StructuredViewer viewer;

    public StrategyBasedContentProvider(TreeBrowseStrategy browseStrategy, TreeBrowseStrategy revealStrategy) {
        this.setRevealStrategy(revealStrategy);
        this.setBrowseStrategy(browseStrategy);
    }

    public void setBrowseStrategy(TreeBrowseStrategy strategy) {
        if (strategy != null) {
            this.browseStrategy = strategy;
            this.encapsulated = this.browseStrategy;
        }
    }

    public void setRevealStrategy(TreeBrowseStrategy strategy) {
        if (strategy != null) {
            this.revealStrategy = strategy;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.browseStrategy != null) {
            this.browseStrategy.dispose();
        }
        if (this.revealStrategy != null) {
            this.revealStrategy.dispose();
        }
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer instanceof StructuredViewer ? (StructuredViewer)viewer : null;
        this.revealStrategy.inputChanged(viewer, oldInput, newInput);
        this.browseStrategy.inputChanged(viewer, oldInput, newInput);
    }

    @Override
    public void revealSemanticElement(List<?> semanticElementsList) {
        this.revealStrategy.revealSemanticElement(semanticElementsList);
    }

    @Override
    public TreeBrowseStrategy getBrowseStrategy() {
        return this.browseStrategy;
    }

    @Override
    public TreeBrowseStrategy getRevealStrategy() {
        return this.revealStrategy;
    }
}

