/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.MapLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class EnumRadio
extends AbstractValueEditor {
    protected IStaticContentProvider contentProvider;
    protected Composite buttonsArea;
    protected ILabelProvider labelProvider = new LabelProvider();
    protected final Map<Button, Object> values = new HashMap<Button, Object>();
    protected int numColumns = -1;
    private ControlDecoration controlDecoration;

    public EnumRadio(Composite parent, int style) {
        this(parent, 0, null);
    }

    public EnumRadio(Composite parent, int style, String label) {
        super(parent, style, label);
        this.buttonsArea = factory.createComposite((Composite)this);
        GridData gridData = this.getDefaultLayoutData();
        this.buttonsArea.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.buttonsArea.setLayout((Layout)layout);
        factory.createCLabel(this.buttonsArea, Messages.EnumRadio_NoValue);
        this.controlDecoration = new ControlDecoration((Control)this.buttonsArea, 16512);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
    }

    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        this.contentProvider = contentProvider;
        if (labelProvider != null) {
            this.labelProvider = labelProvider;
        }
        this.disposeButtons();
        if (this.widgetObservable != null) {
            this.widgetObservable.dispose();
        }
        SelectObservableValue observable = new SelectObservableValue();
        Object[] objectArray = contentProvider.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            Button button = factory.createButton(this.buttonsArea, labelProvider.getText(value), 16);
            button.setBackground(this.buttonsArea.getBackground());
            button.setData(value);
            button.setToolTipText(this.toolTipText);
            ISWTObservableValue buttonObservable = WidgetProperties.widgetSelection().observe((Widget)button);
            observable.addOption(value, (IObservableValue)buttonObservable);
            this.values.put(button, value);
            ++n2;
        }
        this.setWidgetObservable((IObservableValue)observable, true);
        this.updateLayout();
        this.doBinding();
    }

    protected void disposeButtons() {
        Control[] controlArray = this.buttonsArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.binding != null) {
            this.binding.dispose();
        }
        this.values.clear();
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        this.updateLayout();
    }

    private void updateLayout() {
        GridLayout gridLayout = (GridLayout)this.buttonsArea.getLayout();
        gridLayout.numColumns = this.numColumns > 0 ? this.numColumns : this.values.size();
        gridLayout.makeColumnsEqualWidth = this.numColumns > 0;
        this.updateLabelLayout();
    }

    private void updateLabelLayout() {
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        ((GridData)this.label.getLayoutData()).verticalAlignment = this.numColumns == -1 ? 0x1000000 : 1;
    }

    @Override
    protected void createLabel(String label) {
        super.createLabel(label);
        this.updateLabelLayout();
    }

    @Override
    public Object getValue() {
        for (Button button : this.values.keySet()) {
            if (!button.getSelection()) continue;
            return this.values.get(button);
        }
        return null;
    }

    @Override
    public Object getEditableType() {
        return Object.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        for (Button button : this.values.keySet()) {
            button.setEnabled(!readOnly);
        }
        this.buttonsArea.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.buttonsArea.isEnabled();
    }

    public void setToolTipText(String text) {
        for (Button button : this.values.keySet()) {
            button.setToolTipText(text);
        }
        super.setLabelToolTipText(text);
    }

    public void setValue(Object value) {
        if (this.modelProperty != null) {
            this.modelProperty.setValue(value);
        }
        if (this.widgetObservable != null) {
            this.widgetObservable.setValue(value);
        } else {
            for (Button button : this.values.keySet()) {
                if (this.values.get(button) != value) continue;
                button.setSelection(true);
                return;
            }
        }
    }

    public void setEnumValues(Map<Object, String> objectsAndLabels) {
        StaticContentProvider provider = new StaticContentProvider(objectsAndLabels.keySet().toArray());
        MapLabelProvider labelProvider = new MapLabelProvider(objectsAndLabels);
        this.setProviders(provider, (ILabelProvider)labelProvider);
    }

    @Override
    public void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.controlDecoration.hide();
                break;
            }
            case 2: {
                FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.controlDecoration.setImage(warning.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            case 4: {
                FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.controlDecoration.setImage(error.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            default: {
                this.controlDecoration.hide();
            }
        }
    }
}

