/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.export.messages.Messages;

public class DiagramNameProvider {
    private Collection<Diagram> exportedDiagrams;
    private boolean useQualifiedName;
    private Set<Diagram> duplicateDiagramNames = new HashSet<Diagram>();
    private List<Diagnostic> diagnostic = new ArrayList<Diagnostic>();
    private Map<Diagram, String> diagramNames = null;

    public DiagramNameProvider(Collection<Diagram> diagrams, boolean useQualifiedName) {
        this.exportedDiagrams = diagrams;
        this.useQualifiedName = useQualifiedName;
    }

    public Map<Diagram, String> getDiagramNames() {
        if (this.diagramNames == null) {
            Collection<Diagram> allDiagrams = this.getAllDiagrams();
            this.diagramNames = this.getFileNames(allDiagrams);
        }
        return this.diagramNames;
    }

    public List<Diagnostic> getDiagnostic() {
        return this.diagnostic;
    }

    public boolean hasDuplicates(Diagram diagram) {
        return this.duplicateDiagramNames.contains(diagram);
    }

    private Collection<Diagram> getAllDiagrams() {
        ArrayList<Diagram> result = new ArrayList<Diagram>();
        result.addAll(this.exportedDiagrams);
        return result;
    }

    private Map<Diagram, String> getFileNames(Collection<Diagram> diagrams) {
        HashMap<Diagram, String> result = new HashMap<Diagram, String>();
        HashSet<String> usedNames = new HashSet<String>();
        for (Diagram diagram : diagrams) {
            String name = this.handleFileName(diagram, usedNames);
            usedNames.add(name);
            result.put(diagram, name);
        }
        return result;
    }

    private String handleFileName(Diagram diagram, Collection<String> diagramNames) {
        String uniqueFileName;
        boolean nameCut = false;
        String label = "";
        if (this.useQualifiedName) {
            ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            try {
                IItemLabelProvider itemLabelFactory = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)diagram.getElement(), IItemLabelProvider.class);
                label = String.valueOf(itemLabelFactory.getText((Object)diagram.getElement()).replace(Messages.ExportAllDiagrams_16, "")) + "_";
            }
            finally {
                composedAdapterFactory.dispose();
            }
        }
        if ((uniqueFileName = this.encodeFileName(String.valueOf(label) + diagram.getName())).length() > 150) {
            nameCut = true;
            uniqueFileName = uniqueFileName.substring(0, 150);
        }
        if (diagramNames.contains(uniqueFileName)) {
            this.duplicateDiagramNames.add(diagram);
            uniqueFileName = this.getFirstAvailableName(uniqueFileName, diagramNames, 1);
        }
        if (nameCut) {
            BasicDiagnostic newDiagnostic = new BasicDiagnostic(2, "", 0, String.valueOf(Messages.ExportAllDiagrams_10) + uniqueFileName, null);
            this.diagnostic.add((Diagnostic)newDiagnostic);
        }
        return uniqueFileName;
    }

    private String getFirstAvailableName(String commonBasis, Collection<String> existingNames, int cpt) {
        if (existingNames.contains(String.valueOf(commonBasis) + cpt)) {
            return this.getFirstAvailableName(commonBasis, existingNames, cpt + 1);
        }
        return String.valueOf(commonBasis) + cpt;
    }

    private String encodeFileName(String pathName) {
        pathName = pathName.trim();
        pathName = pathName.replaceAll(Messages.ExportAllDiagrams_14, Messages.ExportAllDiagrams_15);
        pathName = pathName.replaceAll("_-_", "-");
        while (pathName.contains("__")) {
            pathName = pathName.replaceAll("__", "_");
        }
        if (pathName.startsWith("_")) {
            pathName = pathName.replaceFirst("_", "");
        }
        if (pathName.endsWith("_")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        return pathName;
    }
}

