/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ProjectDependencyHelper {
    public static final ProjectDependencyHelper INSTANCE = new ProjectDependencyHelper();

    private ProjectDependencyHelper() {
    }

    public Collection<String> getAllAvailableDependencies(String bundleName) {
        TreeSet<String> allDependencies = new TreeSet<String>();
        Collection<String> declaredDependencies = this.getDeclaredPluginDependencies(bundleName);
        for (String current : declaredDependencies) {
            allDependencies.add(current);
            allDependencies.addAll(this.getInheritedBundle(current));
        }
        return allDependencies;
    }

    public Collection<String> getDeclaredPluginDependencies(String bundleName) {
        HashSet<String> currentDeclaredDependencies = new HashSet<String>();
        IPluginModelBase pluginModelBase = PluginRegistry.findModel((String)bundleName);
        BundleSpecification[] bundleSpecificationArray = pluginModelBase.getBundleDescription().getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            currentDeclaredDependencies.add(requiredBundle.getName());
            ++n2;
        }
        return currentDeclaredDependencies;
    }

    public Collection<String> getInheritedBundle(String bundleName) {
        HashSet<String> currentDeclaredDependencies = new HashSet<String>();
        IPluginModelBase pluginModelBase = PluginRegistry.findModel((String)bundleName);
        if (pluginModelBase != null) {
            BundleSpecification[] bundleSpecificationArray = pluginModelBase.getBundleDescription().getRequiredBundles();
            int n = bundleSpecificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification spec = bundleSpecificationArray[n2];
                if (spec.isExported()) {
                    String bundleSymbolicName = spec.getName();
                    currentDeclaredDependencies.add(bundleSymbolicName);
                    currentDeclaredDependencies.addAll(this.getInheritedBundle(bundleSymbolicName));
                }
                ++n2;
            }
        }
        return currentDeclaredDependencies;
    }

    public boolean hasDependency(String projectName, String wantedDependency) {
        return this.getAllAvailableDependencies(projectName).contains(wantedDependency);
    }
}

