/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorSelector;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.AbstractRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.helpers.LocationProperties;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.p2.internal.core.DownloadArtifactEvent;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OfflineMode;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;

public class CachingRepositoryManager<T> {
    public static final String BOGUS_SCHEME = "bogus";
    private static final Method METHOD_checkValidLocation = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"checkValidLocation", (Class[])new Class[]{URI.class});
    private static final Method METHOD_enterLoad = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"enterLoad", (Class[])new Class[]{URI.class, IProgressMonitor.class});
    private static final Method METHOD_basicGetRepository = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"basicGetRepository", (Class[])new Class[]{URI.class});
    private static final Method METHOD_fail = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"fail", (Class[])new Class[]{URI.class, Integer.TYPE});
    private static final Method METHOD_addRepository1 = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"addRepository", (Class[])new Class[]{URI.class, Boolean.TYPE, Boolean.TYPE});
    private static final Method METHOD_loadIndexFile = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"loadIndexFile", (Class[])new Class[]{URI.class, IProgressMonitor.class});
    private static final Method METHOD_getPreferredRepositorySearchOrder = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"getPreferredRepositorySearchOrder", (Class[])new Class[]{LocationProperties.class});
    private static final Method METHOD_getAllSuffixes = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"getAllSuffixes", (Class[])new Class[0]);
    private static final Method METHOD_loadRepository = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"loadRepository", (Class[])new Class[]{URI.class, String.class, String.class, Integer.TYPE, SubMonitor.class});
    private static final Method METHOD_addRepository2 = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"addRepository", (Class[])new Class[]{IRepository.class, Boolean.TYPE, String.class});
    private static final Method METHOD_removeRepository = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"removeRepository", (Class[])new Class[]{URI.class, Boolean.TYPE});
    private static final Method METHOD_exitLoad = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"exitLoad", (Class[])new Class[]{URI.class});
    private static final Method METHOD_broadcastChangeEvent = ReflectUtil.getMethod(AbstractRepositoryManager.class, (String)"broadcastChangeEvent", (Class[])new Class[]{URI.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
    private static final String PROPERTY_VERSION = "version";
    private static final String PROP_BETTER_MIRROR_SELECTION = "oomph.p2.mirror";
    private static final String PROP_REPOSITORY_RETRY = "oomph.p2.repository.retry";
    private static final String PROP_REPOSITORY_FAIL_PERMANENTLY = "oomph.p2.repository.fail.permanently";
    private static final int MAX_RETRY = PropertiesUtil.getProperty((String)"oomph.p2.repository.retry", (int)0);
    private static boolean betterMirrorSelection;
    private final AbstractRepositoryManager<T> delegate;
    private final int repositoryType;
    private final CachingTransport transport;
    private final Map<URI, ProvisionException> failedRepositories = PropertiesUtil.isProperty((String)"oomph.p2.repository.fail.permanently") ? new ConcurrentHashMap() : null;

    public CachingRepositoryManager(AbstractRepositoryManager<T> delegate, int repositoryType, CachingTransport transport) {
        Object t;
        URI rootLocation;
        this.delegate = delegate;
        IAgentLocation agentLocation = (IAgentLocation)ReflectUtil.getValue((String)"agentLocation", delegate);
        if (agentLocation != null && (rootLocation = agentLocation.getRootLocation()) != null && !IOUtil.canWriteFolder((File)new File(rootLocation.getPath()))) {
            ReflectUtil.setValue((String)"agentLocation", delegate, null);
        }
        this.repositoryType = repositoryType;
        if (transport == null && (t = delegate.getAgent().getService(Transport.SERVICE_NAME)) instanceof CachingTransport) {
            transport = (CachingTransport)((Object)t);
        }
        this.transport = transport;
    }

    public CachingTransport getTransport() {
        return this.transport;
    }

    public IRepository<T> loadRepository(URI location, IProgressMonitor monitor, String type, int flags) throws ProvisionException {
        ProvisionException exception;
        if (this.failedRepositories != null && (exception = this.failedRepositories.get(location)) != null) {
            throw exception;
        }
        this.checkValidLocation(location);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean added = false;
        IRepository<T> result = null;
        CachingTransport.startLoadingRepository(location);
        try {
            this.enterLoad(location, (IProgressMonitor)sub.newChild(5));
            try {
                ProvisionException failure;
                block27: {
                    result = this.basicGetRepository(location);
                    if (result != null) {
                        IRepository<T> iRepository = result;
                        return iRepository;
                    }
                    added = this.addRepository(location, true, false);
                    LocationProperties indexFile = this.loadIndexFile(location, (IProgressMonitor)sub.newChild(15));
                    String[] preferredOrder = this.getPreferredRepositorySearchOrder(indexFile);
                    String[] allSuffixes = this.getAllSuffixes();
                    String[] suffixes = this.sortSuffixes(allSuffixes, preferredOrder);
                    sub = SubMonitor.convert((IProgressMonitor)sub, (String)NLS.bind((String)Messages.CachingRepositoryManager_AddingRepository_task, (Object)location), (int)(suffixes.length * 100));
                    failure = null;
                    try {
                        int retry = 0;
                        while (retry <= MAX_RETRY) {
                            if (retry > 0) {
                                CachingRepositoryManager.log(2, NLS.bind((String)Messages.CachingRepositoryManager_LoadingFailed_message, (Object)location, (Object)retry), failure);
                            }
                            failure = null;
                            int i = 0;
                            while (i < suffixes.length) {
                                block26: {
                                    if (sub.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    try {
                                        result = this.loadRepository(location, suffixes[i], type, flags, sub.newChild(100));
                                    }
                                    catch (ProvisionException e) {
                                        if (e.getStatus().getException() instanceof FileNotFoundException) break block26;
                                        failure = e;
                                        break;
                                    }
                                }
                                if (result != null) {
                                    this.addRepository(result, false, suffixes[i]);
                                    this.cacheIndexFile(location, suffixes[i]);
                                    break block27;
                                }
                                ++i;
                            }
                            ++retry;
                        }
                    }
                    finally {
                        sub.done();
                    }
                }
                if (result == null) {
                    if (added) {
                        this.removeRepository(location, false);
                    }
                    if (Boolean.parseBoolean(this.delegate.getRepositoryProperty(location, "p2.system"))) {
                        this.delegate.removeRepository(location);
                    }
                    if (failure != null) {
                        if (this.failedRepositories != null && !"file".equals(location.getScheme())) {
                            this.failedRepositories.put(location, failure);
                        }
                        throw failure;
                    }
                    this.fail(location, 1000);
                }
            }
            finally {
                this.exitLoad(location);
            }
        }
        finally {
            CachingTransport.stopLoadingRepository();
        }
        if (added) {
            this.broadcastChangeEvent(location, this.repositoryType, 0, true);
        }
        return result;
    }

    private File getCachedIndexFile(URI location) {
        try {
            String path = location.toString();
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            return this.transport.getCacheFile(new URI(String.valueOf(path) + "p2.index"));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void cacheIndexFile(URI location, String suffix) {
        if ("file".equals(location.getScheme())) {
            return;
        }
        File cachedIndexFile = this.getCachedIndexFile(location);
        Map properties = PropertiesUtil.getProperties((File)cachedIndexFile);
        if (!properties.containsKey(PROPERTY_VERSION)) {
            properties.put(PROPERTY_VERSION, "1");
        }
        if (this.repositoryType == 0) {
            properties.put("metadata.repository.factory.order", suffix);
        } else {
            properties.put("artifact.repository.factory.order", suffix);
        }
        properties.remove("generated");
        try {
            PropertiesUtil.saveProperties((File)cachedIndexFile, (Map)properties, (boolean)false);
        }
        catch (IORuntimeException iORuntimeException) {
            // empty catch block
        }
    }

    private URI checkValidLocation(URI location) {
        return (URI)ReflectUtil.invokeMethod((Method)METHOD_checkValidLocation, this.delegate, (Object[])new Object[]{location});
    }

    private void enterLoad(URI location, IProgressMonitor monitor) {
        ReflectUtil.invokeMethod((Method)METHOD_enterLoad, this.delegate, (Object[])new Object[]{location, monitor});
    }

    protected IRepository<T> basicGetRepository(URI location) {
        return (IRepository)ReflectUtil.invokeMethod((Method)METHOD_basicGetRepository, this.delegate, (Object[])new Object[]{location});
    }

    private void fail(URI location, int code) throws ProvisionException {
        try {
            ReflectUtil.invokeMethod((Method)METHOD_fail, this.delegate, (Object[])new Object[]{location, code});
        }
        catch (ReflectUtil.ReflectionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProvisionException) {
                if (this.failedRepositories != null && !"file".equals(location.getScheme())) {
                    this.failedRepositories.put(location, (ProvisionException)cause);
                }
                throw (ProvisionException)cause;
            }
            throw ex;
        }
    }

    private boolean addRepository(URI location, boolean isEnabled, boolean signalAdd) {
        return (Boolean)ReflectUtil.invokeMethod((Method)METHOD_addRepository1, this.delegate, (Object[])new Object[]{location, isEnabled, signalAdd});
    }

    private LocationProperties loadIndexFile(URI location, IProgressMonitor monitor) {
        return (LocationProperties)ReflectUtil.invokeMethod((Method)METHOD_loadIndexFile, this.delegate, (Object[])new Object[]{location, monitor});
    }

    protected String[] getPreferredRepositorySearchOrder(LocationProperties properties) {
        return (String[])ReflectUtil.invokeMethod((Method)METHOD_getPreferredRepositorySearchOrder, this.delegate, (Object[])new Object[]{properties});
    }

    protected String[] getAllSuffixes() {
        return (String[])ReflectUtil.invokeMethod((Method)METHOD_getAllSuffixes, this.delegate, (Object[])new Object[0]);
    }

    private String[] sortSuffixes(String[] allSuffixes, String[] preferredOrder) {
        ArrayList<String> suffixes = new ArrayList<String>(Arrays.asList(allSuffixes));
        int i = preferredOrder.length - 1;
        while (i >= 0) {
            String suffix = preferredOrder[i].trim();
            if (!"!".equals(suffix)) {
                suffixes.remove(suffix);
                suffixes.add(0, suffix);
            }
            --i;
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    private IRepository<T> loadRepository(URI location, String suffix, String type, int flags, SubMonitor monitor) throws ProvisionException {
        try {
            return (IRepository)ReflectUtil.invokeMethod((Method)METHOD_loadRepository, this.delegate, (Object[])new Object[]{location, suffix, type, flags, monitor});
        }
        catch (ReflectUtil.ReflectionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProvisionException) {
                throw (ProvisionException)cause;
            }
            throw ex;
        }
    }

    protected void addRepository(IRepository<T> repository, boolean signalAdd, String suffix) {
        ReflectUtil.invokeMethod((Method)METHOD_addRepository2, this.delegate, (Object[])new Object[]{repository, signalAdd, suffix});
    }

    private boolean removeRepository(URI toRemove, boolean signalRemove) {
        return (Boolean)ReflectUtil.invokeMethod((Method)METHOD_removeRepository, this.delegate, (Object[])new Object[]{toRemove, signalRemove});
    }

    private void exitLoad(URI location) {
        ReflectUtil.invokeMethod((Method)METHOD_exitLoad, this.delegate, (Object[])new Object[]{location});
    }

    private void broadcastChangeEvent(URI location, int repositoryType, int kind, boolean isEnabled) {
        ReflectUtil.invokeMethod((Method)METHOD_broadcastChangeEvent, this.delegate, (Object[])new Object[]{location, repositoryType, kind, isEnabled});
    }

    public static boolean isBetterMirrorSelection() {
        return betterMirrorSelection;
    }

    public static boolean enableBetterMirrorSelection() {
        boolean originalBetterMirrorSelection = betterMirrorSelection;
        CachingRepositoryManager.setBetterMirrorSelection(!"false".equals(PropertiesUtil.getProperty((String)PROP_BETTER_MIRROR_SELECTION)));
        return originalBetterMirrorSelection;
    }

    public static void setBetterMirrorSelection(boolean betterMirrorSelection) {
        CachingRepositoryManager.betterMirrorSelection = betterMirrorSelection;
    }

    private static void log(int severity, String message, Throwable exception) {
        LogHelper.log((IStatus)new Status(severity, "org.eclipse.equinox.p2.artifact.repository", message, exception));
    }

    public static class Artifact
    extends ArtifactRepositoryManager {
        private static final String GLOBAL_MAX_THREADS = Activator.getContext().getProperty("eclipse.p2.max.threads");
        private final CachingRepositoryManager<IArtifactKey> loader;

        public Artifact(IProvisioningAgent agent, CachingTransport transport) {
            super(agent);
            this.loader = new CachingRepositoryManager(this, 1, transport);
        }

        protected IRepository<IArtifactKey> loadRepository(URI location, IProgressMonitor monitor, String type, int flags) throws ProvisionException {
            IProvisioningEventBus eventBus;
            IRepository<IArtifactKey> result = this.loader.loadRepository(location, monitor, type, flags);
            if (CachingRepositoryManager.isBetterMirrorSelection() && result instanceof SimpleArtifactRepository && !result.isModifiable() && (eventBus = (IProvisioningEventBus)this.getAgent().getService(IProvisioningEventBus.SERVICE_NAME)) != null) {
                final BetterMirrorSelector mirrorSelector = new BetterMirrorSelector(result, this.loader.getTransport(), eventBus);
                ReflectUtil.setValue((String)"mirrors", result, (Object)((Object)mirrorSelector));
                if (GLOBAL_MAX_THREADS != null) {
                    Map properties = (Map)ReflectUtil.getValue((String)"properties", result);
                    OrderedProperties specializedProperties = new OrderedProperties(){

                        public Set<Map.Entry<String, String>> entrySet() {
                            String respositoryMaxThreads;
                            StackTraceElement[] stackTrace;
                            if (!OfflineMode.isEnabled() && (stackTrace = Thread.currentThread().getStackTrace()).length > 5 && "getMaximumThreads".equals(stackTrace[5].getMethodName()) && (respositoryMaxThreads = this.get("eclipse.p2.max.threads")) == null) {
                                mirrorSelector.initMirrorActivities((IProgressMonitor)new NullProgressMonitor());
                                BetterMirrorSelector.MirrorActivity[] mirrorActivities = mirrorSelector.mirrorActivities;
                                int maxThreads = mirrorActivities.length <= 1 ? 10 : Math.min(mirrorActivities.length * 10, Integer.parseInt(GLOBAL_MAX_THREADS));
                                this.put("eclipse.p2.max.threads", Integer.toString(maxThreads));
                            }
                            return super.entrySet();
                        }
                    };
                    specializedProperties.putAll(properties);
                    ReflectUtil.setValue((String)"properties", result, (Object)specializedProperties);
                }
            }
            return result;
        }

        public URI[] getKnownRepositories(int flags) {
            return Metadata.filter(super.getKnownRepositories(flags));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() {
            Object object = this.repositoryLock;
            synchronized (object) {
                if (this.repositories != null) {
                    super.flushCache();
                }
            }
        }

        static final class BetterMirrorSelector
        extends MirrorSelector
        implements SynchronousProvisioningListener {
            private final URI repositoryURI;
            private final IProvisioningEventBus eventBus;
            private final Map<URI, ArtifactActivity> artifactActivities = Collections.synchronizedMap(new HashMap());
            private int phase = 1;
            private MirrorActivity[] mirrorActivities;

            public BetterMirrorSelector(IRepository<?> repository, Transport transport, IProvisioningEventBus eventBus) {
                super(repository, transport);
                this.eventBus = eventBus;
                this.repositoryURI = this.getBaseURI();
            }

            public void notify(EventObject event) {
                if (this.mirrorActivities != null) {
                    if (event instanceof DownloadArtifactEvent) {
                        DownloadArtifactEvent downloadArtifactEvent = (DownloadArtifactEvent)event;
                        URI artifactURI = downloadArtifactEvent.getArtifactURI();
                        ArtifactActivity artifactActivity = this.artifactActivities.get(artifactURI);
                        if (artifactActivity != null) {
                            MirrorActivity mirrorActivity = artifactActivity.getMirrorActivity();
                            if (downloadArtifactEvent.isCompleted()) {
                                mirrorActivity.decrementUsage();
                                IStatus status = downloadArtifactEvent.getStatus();
                                if (status.isOK()) {
                                    mirrorActivity.incrementSuccess();
                                    DownloadStatus downloadStatus = (DownloadStatus)status;
                                    long fileSize = downloadStatus.getFileSize();
                                    artifactActivity.setSize(fileSize);
                                    mirrorActivity.setSpeed(artifactActivity.getSpeed());
                                } else {
                                    mirrorActivity.incrementFailure();
                                    artifactActivity.setSize(0L);
                                    mirrorActivity.setSpeed(0L);
                                }
                            } else {
                                mirrorActivity.incrementUsage();
                                artifactActivity.setStart();
                            }
                        }
                    } else if (event instanceof CommitOperationEvent || event instanceof RollbackOperationEvent) {
                        if (this.eventBus != null) {
                            this.eventBus.removeListener((ProvisioningListener)this);
                        }
                        this.mirrorActivities = null;
                        this.artifactActivities.clear();
                        this.phase = 1;
                    }
                }
            }

            public synchronized URI getMirrorLocation(URI inputLocation, IProgressMonitor monitor) {
                Assert.isNotNull((Object)inputLocation);
                if (this.repositoryURI == null) {
                    return inputLocation;
                }
                URI relativeLocation = this.repositoryURI.relativize(inputLocation);
                if (relativeLocation == null || relativeLocation.isAbsolute()) {
                    return inputLocation;
                }
                this.initMirrorActivities(monitor);
                MirrorActivity selectedMirror = this.selectMirror();
                if (selectedMirror == null) {
                    return inputLocation;
                }
                String location = selectedMirror.getLocation();
                try {
                    URI artifactURI = new URI(String.valueOf(location) + relativeLocation.getPath());
                    ArtifactActivity newActivity = new ArtifactActivity(selectedMirror);
                    ArtifactActivity previousActivity = this.artifactActivities.put(artifactURI, newActivity);
                    if (previousActivity != null) {
                        if (!newActivity.retry(previousActivity)) {
                            return new URI("bogus:" + artifactURI);
                        }
                        if (artifactURI.toString().endsWith(".jar.pack.gz")) {
                            monitor.subTask(NLS.bind((String)Messages.CachingRepositoryManager_RepeatedDownload_task, (Object)artifactURI));
                        }
                    }
                    return artifactURI;
                }
                catch (URISyntaxException e) {
                    CachingRepositoryManager.log(4, NLS.bind((String)Messages.CachingRepositoryManager_NonRelative_message, (Object)inputLocation, (Object)location), e);
                    return inputLocation;
                }
            }

            private MirrorActivity selectMirror() {
                int usages;
                MirrorActivity mirrorActivity;
                int n;
                int n2;
                MirrorActivity[] mirrorActivityArray;
                if (this.mirrorActivities.length == 0) {
                    return null;
                }
                if (this.phase == 1) {
                    mirrorActivityArray = this.mirrorActivities;
                    n2 = this.mirrorActivities.length;
                    n = 0;
                    while (n < n2) {
                        mirrorActivity = mirrorActivityArray[n];
                        if (!mirrorActivity.isProbed()) {
                            mirrorActivity.setProbed();
                            return mirrorActivity;
                        }
                        ++n;
                    }
                    this.phase = 2;
                }
                this.sort();
                mirrorActivityArray = this.mirrorActivities;
                n2 = this.mirrorActivities.length;
                n = 0;
                while (n < n2) {
                    mirrorActivity = mirrorActivityArray[n];
                    int MAX_ACTIVITY_PER_HOST = 4;
                    usages = mirrorActivity.getUsages();
                    if (usages < MAX_ACTIVITY_PER_HOST) {
                        return mirrorActivity;
                    }
                    ++n;
                }
                MirrorActivity leastUsedMirror = null;
                MirrorActivity[] mirrorActivityArray2 = this.mirrorActivities;
                int n3 = this.mirrorActivities.length;
                n2 = 0;
                while (n2 < n3) {
                    MirrorActivity mirrorActivity2 = mirrorActivityArray2[n2];
                    usages = mirrorActivity2.getUsages();
                    if (leastUsedMirror == null || leastUsedMirror.getUsages() > usages) {
                        leastUsedMirror = mirrorActivity2;
                    }
                    ++n2;
                }
                return leastUsedMirror;
            }

            public List<String> getStats() {
                ArrayList<String> result = new ArrayList<String>();
                if (this.mirrorActivities != null) {
                    MirrorActivity[] summaryMirrorActivities = new MirrorActivity[this.mirrorActivities.length];
                    int i = 0;
                    while (i < this.mirrorActivities.length) {
                        MirrorActivity mirrorActivity = this.mirrorActivities[i];
                        MirrorActivity summaryMirrorActivity = summaryMirrorActivities[i] = new MirrorActivity(mirrorActivity.location);
                        int j = 0;
                        while (j < mirrorActivity.getFailures()) {
                            summaryMirrorActivity.incrementFailure();
                            ++j;
                        }
                        long totalSize = 0L;
                        long totalDuration = 0L;
                        for (ArtifactActivity artifactActivity : this.artifactActivities.values()) {
                            if (artifactActivity.getMirrorActivity() != mirrorActivity) continue;
                            summaryMirrorActivity.incrementSuccess();
                            totalSize += artifactActivity.getSize();
                            totalDuration += artifactActivity.getDuration();
                        }
                        if (totalSize != 0L) {
                            summaryMirrorActivity.setSpeed(1000L * totalSize / totalDuration);
                        }
                        ++i;
                    }
                    this.mirrorActivities = summaryMirrorActivities;
                    this.sort();
                    MirrorActivity[] mirrorActivityArray = this.mirrorActivities;
                    int n = this.mirrorActivities.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MirrorActivity mirrorActivity = mirrorActivityArray[n2];
                        if (mirrorActivity.getSuccesses() + mirrorActivity.getFailures() > 0) {
                            result.add(this.getStats(mirrorActivity));
                        }
                        ++n2;
                    }
                }
                return result;
            }

            private String getStats(MirrorActivity mirrorActivity) {
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
                int successes = mirrorActivity.getSuccesses();
                int failures = mirrorActivity.getFailures();
                String message = NLS.bind((String)Messages.CachingRepositoryManager_Speed_message, (Object[])new Object[]{successes, mirrorActivity.getLocation(), numberFormat.format(mirrorActivity.getSpeed() / 1000L)});
                if (failures > 0) {
                    message = String.valueOf(message) + " " + NLS.bind((String)Messages.CachingRepositoryManager_Failure_message, (Object)failures);
                }
                return message;
            }

            private void sort() {
                TreeMap sortedMap = new TreeMap();
                MirrorActivity[] mirrorActivityArray = this.mirrorActivities;
                int n = this.mirrorActivities.length;
                int n2 = 0;
                while (n2 < n) {
                    MirrorActivity mirrorActivity = mirrorActivityArray[n2];
                    long value = mirrorActivity.getSpeed();
                    CollectionUtil.add(sortedMap, (Object)value, (Object)mirrorActivity);
                    ++n2;
                }
                int index = this.mirrorActivities.length;
                for (Set acitivities : sortedMap.values()) {
                    for (MirrorActivity mirrorActivity : acitivities) {
                        this.mirrorActivities[--index] = mirrorActivity;
                    }
                }
            }

            private void initMirrorActivities(IProgressMonitor monitor) {
                block10: {
                    if (this.mirrorActivities != null) break block10;
                    Method method = ReflectUtil.getMethod((Object)((Object)this), (String)"initMirrors", (Class[])new Class[]{IProgressMonitor.class});
                    MirrorSelector.MirrorInfo[] mirrors = (MirrorSelector.MirrorInfo[])ReflectUtil.invokeMethod((Method)method, (Object)((Object)this), (Object[])new Object[]{monitor});
                    if (mirrors == null && (mirrors = (MirrorSelector.MirrorInfo[])ReflectUtil.getValue((String)"mirrors", (Object)((Object)this))) == null) {
                        mirrors = new MirrorSelector.MirrorInfo[]{};
                    }
                    HashSet<String> locations = new HashSet<String>();
                    ArrayList<MirrorActivity> mirrorActivitiesList = new ArrayList<MirrorActivity>();
                    int limit = (mirrors.length + 2) / 3;
                    int i = 0;
                    while (i < limit) {
                        block11: {
                            MirrorSelector.MirrorInfo mirrorInfo = mirrors[i];
                            String locationString = BetterMirrorSelector.getLocationString(mirrorInfo);
                            if (locationString != null && locations.add(locationString)) {
                                try {
                                    URI uri = new URI(locationString);
                                    if (uri.getScheme() == null) {
                                    }
                                }
                                catch (URISyntaxException ex) {}
                                break block11;
                                MirrorActivity mirrorActivity = new MirrorActivity(locationString);
                                mirrorActivitiesList.add(mirrorActivity);
                            }
                        }
                        ++i;
                    }
                    if (this.repositoryURI != null) {
                        String locationString = this.repositoryURI.toString();
                        if (!locationString.endsWith("/")) {
                            locationString = String.valueOf(locationString) + Character.toString('/');
                        }
                        if (locations.add(locationString)) {
                            MirrorActivity mirrorActivity = new MirrorActivity(locationString);
                            mirrorActivitiesList.add(mirrorActivity);
                        }
                    }
                    this.mirrorActivities = mirrorActivitiesList.toArray(new MirrorActivity[mirrorActivitiesList.size()]);
                    if (this.eventBus != null) {
                        this.eventBus.addListener((ProvisioningListener)this);
                    }
                }
            }

            private URI getBaseURI() {
                return (URI)ReflectUtil.getValue((String)"baseURI", (Object)((Object)this));
            }

            private static String getLocationString(MirrorSelector.MirrorInfo mirrorInfo) {
                return (String)ReflectUtil.getValue((String)"locationString", (Object)mirrorInfo);
            }

            private static class ArtifactActivity {
                private final MirrorActivity mirrorActivity;
                private long start;
                private long end;
                private long size;
                private int retryCount;

                public ArtifactActivity(MirrorActivity mirrorActivity) {
                    this.mirrorActivity = mirrorActivity;
                }

                public MirrorActivity getMirrorActivity() {
                    return this.mirrorActivity;
                }

                public void setStart() {
                    this.start = System.currentTimeMillis();
                }

                public void setSize(long size) {
                    this.end = System.currentTimeMillis();
                    this.size = size;
                }

                public long getDuration() {
                    return this.end - this.start;
                }

                public long getSpeed() {
                    return this.size * 1000L / (this.end - this.start);
                }

                public long getSize() {
                    return this.size;
                }

                public boolean retry(ArtifactActivity previousArtifactActivity) {
                    if (previousArtifactActivity != null) {
                        this.retryCount = previousArtifactActivity.retryCount + 1;
                    }
                    return this.retryCount < 3;
                }

                public String toString() {
                    return "ArtifactActivity [start=" + this.start + ", end=" + this.end + ", size=" + this.size + ", duration=" + this.getDuration() + ", speed=" + this.getSpeed() + "]";
                }
            }

            private static class MirrorActivity {
                private final String location;
                private final AtomicInteger usages = new AtomicInteger();
                private final AtomicInteger successes = new AtomicInteger();
                private final AtomicInteger failures = new AtomicInteger();
                private final AtomicLong speed = new AtomicLong();
                private boolean probed;

                public MirrorActivity(String location) {
                    this.location = location;
                }

                public String getLocation() {
                    return this.location;
                }

                public boolean isProbed() {
                    return this.probed;
                }

                public void setProbed() {
                    this.probed = true;
                }

                public int getUsages() {
                    return this.usages.get();
                }

                public void incrementUsage() {
                    this.usages.incrementAndGet();
                }

                public void decrementUsage() {
                    this.usages.decrementAndGet();
                }

                public int getSuccesses() {
                    return this.successes.get();
                }

                public void incrementSuccess() {
                    this.successes.incrementAndGet();
                }

                public int getFailures() {
                    return this.failures.get();
                }

                public void incrementFailure() {
                    this.failures.incrementAndGet();
                }

                public synchronized long getSpeed() {
                    return this.speed.get();
                }

                public synchronized void setSpeed(long speed) {
                    long currentSpeed = this.speed.get();
                    currentSpeed = currentSpeed == 0L ? speed : (currentSpeed + speed) / 2L;
                    this.speed.set(currentSpeed);
                }

                public String toString() {
                    return "MirrorActivity [location=" + this.location + ", usages=" + this.usages.get() + ", successes=" + this.successes.get() + ", failures=" + this.failures.get() + ", speed=" + this.speed.get() + ", probed=" + this.probed + "]";
                }
            }
        }
    }

    public static class Metadata
    extends MetadataRepositoryManager {
        private final CachingRepositoryManager<IInstallableUnit> loader;

        public Metadata(IProvisioningAgent agent, CachingTransport transport) {
            super(agent);
            this.loader = new CachingRepositoryManager(this, 0, transport);
        }

        protected IRepository<IInstallableUnit> loadRepository(URI location, IProgressMonitor monitor, String type, int flags) throws ProvisionException {
            return this.loader.loadRepository(location, monitor, type, flags);
        }

        public URI[] getKnownRepositories(int flags) {
            return Metadata.filter(super.getKnownRepositories(flags));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() {
            Object object = this.repositoryLock;
            synchronized (object) {
                if (this.repositories != null) {
                    super.flushCache();
                }
            }
        }

        static URI[] filter(URI[] uris) {
            ArrayList<URI> result = new ArrayList<URI>(uris.length);
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                try {
                    if (!"file".equalsIgnoreCase(uri.getScheme()) || new File(uri).isDirectory()) {
                        result.add(uri);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++n2;
            }
            return result.toArray(new URI[result.size()]);
        }
    }
}

