/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.discoverer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.kdm.source.discoverer.internal.KDMSourceDiscoverer;

public class DiscoverSourceModelFromJavaElement
extends AbstractModelDiscoverer<IJavaElement> {
    public boolean isApplicableTo(IJavaElement javaElement) {
        if (javaElement instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)javaElement;
            return javaProject.exists() && javaProject.getProject() != null && javaProject.getProject().isAccessible();
        }
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            return packageFragment.exists() && packageFragment.getResource().isAccessible() && packageFragment.getResource() instanceof IContainer;
        }
        return false;
    }

    protected void basicDiscoverElement(IJavaElement javaElement, IProgressMonitor monitor) throws DiscoveryException {
        Resource model;
        KDMSourceDiscoverer disco = new KDMSourceDiscoverer();
        if (javaElement instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)javaElement;
            IProject project = javaProject.getProject();
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)project.getFullPath().append(project.getName()).toString().concat("_kdm.xmi"), (boolean)true));
            model = disco.getKDMModelFromProject(javaProject.getProject());
        } else if (javaElement instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)javaElement;
            IContainer container = (IContainer)packageFragment.getResource();
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)container.getFullPath().append(container.getName()).toString().concat("_kdm.xmi"), (boolean)true));
            model = disco.getKDMModelFromContainer(container);
        } else {
            throw new IllegalArgumentException(String.valueOf(javaElement.getClass().getName()) + " not handled");
        }
        this.getResourceSet().getResources().add((Object)model);
        this.setTargetModel(model);
    }
}

