/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.facet;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jst.jsf.facelet.core.internal.facet.ChangeActionType;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FacetChangeModel;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;

public abstract class FaceletChangePage
extends AbstractFacetWizardPage {
    private Button _chgDefaultSuffix;
    private Button _chgViewHandler;
    private Button _chgConfigureListener;
    private Button _chgWebappLifecycleListener;
    private DataBindingContext _bindingContext;
    private FacetChangeModel _dataModel;

    public FaceletChangePage(String name) {
        super(name);
    }

    public void setConfig(Object config) {
        this._dataModel = (FacetChangeModel)config;
    }

    protected String getTextForChangeType() {
        ChangeActionType actionType = this._dataModel.getChangeActionType();
        switch (actionType) {
            case ADD: {
                return "Add";
            }
            case REMOVE: {
                return "Remove";
            }
        }
        return "*ERROR*";
    }

    private void initDefaultSuffixButton(Composite parent) {
        this._chgDefaultSuffix = new Button(parent, 32);
        this._chgDefaultSuffix.setText(String.valueOf(this.getTextForChangeType()) + " '.xhtml' DEFAULT_SUFFIX parameter");
        this._chgDefaultSuffix.setSelection(this._dataModel.isChgDefaultSuffix());
        this._chgDefaultSuffix.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeanProperties.value(FacetChangeModel.class, (String)"chgDefaultSuffix", Boolean.TYPE).observe((Object)this._dataModel);
        ISWTObservableValue buttonObservable = WidgetProperties.buttonSelection().observe((Widget)this._chgDefaultSuffix);
        this._bindingContext.bindValue((IObservableValue)buttonObservable, modelObservable);
    }

    private void initViewHandlerButton(Composite parent) {
        this._chgViewHandler = new Button(parent, 32);
        this._chgViewHandler.setText(String.valueOf(this.getTextForChangeType()) + " Facelet view handler");
        this._chgViewHandler.setSelection(this._dataModel.isChgViewHandler());
        this._chgViewHandler.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeanProperties.value(FacetChangeModel.class, (String)"chgViewHandler", Boolean.TYPE).observe((Object)this._dataModel);
        ISWTObservableValue buttonObservable = WidgetProperties.buttonSelection().observe((Widget)this._chgViewHandler);
        this._bindingContext.bindValue((IObservableValue)buttonObservable, modelObservable);
    }

    private void initConfigureListener(Composite parent) {
        this._chgConfigureListener = new Button(parent, 32);
        this._chgConfigureListener.setText(String.valueOf(this.getTextForChangeType()) + " configure listener (needed by some Tomcat containers)");
        this._chgConfigureListener.setSelection(this._dataModel.isChgConfigureListener());
        this._chgConfigureListener.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeanProperties.value(FacetChangeModel.class, (String)"chgConfigureListener", Boolean.TYPE).observe((Object)this._dataModel);
        ISWTObservableValue buttonObservable = WidgetProperties.buttonSelection().observe((Widget)this._chgConfigureListener);
        this._bindingContext.bindValue((IObservableValue)buttonObservable, modelObservable);
    }

    private void initWebappLifecycleListener(Composite parent) {
        this._chgWebappLifecycleListener = new Button(parent, 32);
        this._chgWebappLifecycleListener.setText(String.valueOf(this.getTextForChangeType()) + " web application lifecycle listener (needed by some Tomcat containers)");
        this._chgWebappLifecycleListener.setSelection(this._dataModel.isChgConfigureListener());
        this._chgWebappLifecycleListener.setLayoutData((Object)new RowData());
        IObservableValue modelObservable = BeanProperties.value(FacetChangeModel.class, (String)"chgWebAppLifecycleListener", Boolean.TYPE).observe((Object)this._dataModel);
        ISWTObservableValue buttonObservable = WidgetProperties.buttonSelection().observe((Widget)this._chgWebappLifecycleListener);
        this._bindingContext.bindValue((IObservableValue)buttonObservable, modelObservable);
    }

    public void createControl(Composite parent) {
        this.setTitle("Facelet");
        this.setMessage("Configure Facelet settings");
        this._bindingContext = new DataBindingContext();
        Composite control = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        control.setLayout((Layout)rowLayout);
        Group webXMLGroup = new Group(control, 0);
        webXMLGroup.setLayout((Layout)rowLayout);
        webXMLGroup.setText("Deployment Descriptor (web.xml) Configuration");
        this.initDefaultSuffixButton((Composite)webXMLGroup);
        this.initConfigureListener((Composite)webXMLGroup);
        this.initWebappLifecycleListener((Composite)webXMLGroup);
        Group facesConfigGroup = new Group(control, 0);
        facesConfigGroup.setLayout((Layout)rowLayout);
        facesConfigGroup.setText("Application (faces-config.xml) Configuration");
        this.initViewHandlerButton((Composite)facesConfigGroup);
        this.setControl((Control)control);
    }
}

