/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PerspectiveStackRenderer
extends LazyStackRenderer {
    @Inject
    private IPresentationEngine renderer;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPerspectiveStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite perspStack = new Composite((Composite)parent, 0);
        IStylingEngine stylingEngine = (IStylingEngine)this.getContext(element).get(IStylingEngine.class);
        stylingEngine.setClassname((Object)perspStack, "perspectiveLayout");
        perspStack.setLayout((Layout)new StackLayout());
        return perspStack;
    }

    @Override
    public void postProcess(MUIElement element) {
        super.postProcess(element);
        MPerspectiveStack ps = (MPerspectiveStack)element;
        if (ps.getSelectedElement() != null && ((MPerspective)ps.getSelectedElement()).getWidget() != null) {
            Control ctrl = (Control)((MPerspective)ps.getSelectedElement()).getWidget();
            Composite psComp = (Composite)ps.getWidget();
            StackLayout sl = (StackLayout)psComp.getLayout();
            sl.topControl = ctrl;
            ctrl.requestLayout();
        }
    }

    @Override
    protected void showTab(MUIElement tabElement) {
        MPerspective persp = (MPerspective)tabElement;
        Control ctrl = (Control)persp.getWidget();
        if (ctrl == null) {
            ctrl = (Control)this.renderer.createGui((MUIElement)persp);
        } else if (ctrl.getParent() != persp.getParent().getWidget()) {
            Composite parent = (Composite)persp.getParent().getWidget();
            ctrl.setParent(parent);
        }
        super.showTab((MUIElement)persp);
        Composite psComp = ctrl.getParent();
        StackLayout sl = (StackLayout)psComp.getLayout();
        if (sl != null) {
            sl.topControl = ctrl;
            ctrl.requestLayout();
        }
        ctrl.moveAbove(null);
        IEclipseContext context = persp.getContext();
        ((EPartService)context.get(EPartService.class)).switchPerspective(persp);
        Control[] kids = psComp.getChildren();
        Shell limbo = (Shell)context.get("limbo");
        Control[] controlArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child != ctrl) {
                child.setParent((Composite)limbo);
            }
            ++n2;
        }
    }
}

