/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;

    public FreeBsdGlobalMemory() {
        this.pageSize = BsdSysctlUtil.sysctl("hw.pagesize", 4096L);
        this.memTotal = BsdSysctlUtil.sysctl("hw.physmem", 0L);
    }

    @Override
    protected void updateMeminfo() {
        long inactive = BsdSysctlUtil.sysctl("vm.stats.vm.v_inactive_count", 0L);
        long cache = BsdSysctlUtil.sysctl("vm.stats.vm.v_cache_count", 0L);
        long free = BsdSysctlUtil.sysctl("vm.stats.vm.v_free_count", 0L);
        this.memAvailable = (inactive + cache + free) * this.pageSize;
        this.swapPagesIn = BsdSysctlUtil.sysctl("vm.stats.vm.v_swappgsin", 0L);
        this.swapPagesOut = BsdSysctlUtil.sysctl("vm.stats.vm.v_swappgsout", 0L);
    }

    @Override
    protected void updateSwap() {
        this.swapTotal = BsdSysctlUtil.sysctl("vm.swap_total", 0L);
        String swapInfo = ExecutingCommand.getAnswerAt("swapinfo -k", 1);
        String[] split = ParseUtil.whitespaces.split(swapInfo);
        if (split.length < 5) {
            return;
        }
        this.swapUsed = ParseUtil.parseLongOrDefault(split[2], 0L) << 10;
    }
}

