/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;

public class SocketServerLauncher {
    private static final Logger LOG = Logger.getLogger(SocketServerLauncher.class);
    public static final String HOST = "-host";
    public static final String PORT = "-port";
    public static final String TRACE = "-trace";
    public static final String NO_VALIDATE = "-noValidate";
    public static final int DEFAULT_PORT = 5008;
    public static final String DEFAULT_HOST = "0.0.0.0";

    public static void main(String[] args) {
        new SocketServerLauncher().launch(args);
    }

    public void launch(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.getServerModule()});
        try {
            AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(this.getSocketAddress(args));
            Throwable throwable = null;
            try {
                try {
                    LOG.info((Object)("Started server socket at " + this.getSocketAddress(args)));
                    while (true) {
                        AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
                        InputStream in = Channels.newInputStream(socketChannel);
                        OutputStream out = Channels.newOutputStream(socketChannel);
                        PrintWriter trace = this.getTrace(args);
                        boolean validate = this.shouldValidate(args);
                        LanguageServerImpl languageServer = (LanguageServerImpl)injector.getInstance(LanguageServerImpl.class);
                        LOG.info((Object)("Starting Xtext Language Server for client " + socketChannel.getRemoteAddress()));
                        Launcher launcher = Launcher.createLauncher((Object)languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (boolean)validate, (PrintWriter)trace);
                        languageServer.connect((LanguageClient)launcher.getRemoteProxy());
                        launcher.startListening();
                        LOG.info((Object)"Xtext Language Server has been started.");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (serverSocket != null) {
                    if (throwable != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        serverSocket.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    protected Module getServerModule() {
        return new ServerModule();
    }

    protected PrintWriter getTrace(String ... args) {
        if (ArrayExtensions.contains((Object[])args, (Object)TRACE)) {
            return new PrintWriter(System.out);
        }
        return null;
    }

    protected boolean shouldValidate(String ... args) {
        return !ArrayExtensions.contains((Object[])args, (Object)NO_VALIDATE);
    }

    protected InetSocketAddress getSocketAddress(String ... args) {
        return new InetSocketAddress(this.getHost(args), this.getPort(args));
    }

    protected String getHost(String ... args) {
        String host = this.getValue(args, HOST);
        if (host != null) {
            return host;
        }
        return DEFAULT_HOST;
    }

    protected int getPort(String ... args) {
        String value = this.getValue(args, PORT);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return 5008;
            }
        }
        return 5008;
    }

    protected String getValue(String[] args, String argName) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!Objects.equal((Object)args[i], (Object)argName)) continue;
            return args[i + 1];
        }
        return null;
    }
}

