/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.handler;

import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.CTabItemHandler;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.util.TextWidgetUtil;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class WorkbenchPartHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static WorkbenchPartHandler instance;

    public static WorkbenchPartHandler getInstance() {
        if (instance == null) {
            instance = new WorkbenchPartHandler();
        }
        return instance;
    }

    public String getTitle(final IWorkbenchPart workbenchPart) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return workbenchPart.getTitle();
            }
        });
    }

    public String getTitleToolTip(final IWorkbenchPart workbenchPart) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return workbenchPart.getTitleToolTip();
            }
        });
    }

    public Image getTitleImage(final IWorkbenchPart workbenchPart) {
        return (Image)Display.syncExec((ResultRunnable)new ResultRunnable<Image>(){

            public Image run() {
                return workbenchPart.getTitleImage();
            }
        });
    }

    protected void setFocus(final IWorkbenchPart workbenchPart) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                workbenchPart.setFocus();
            }
        });
    }

    public void focusChildControl(IWorkbenchPart workbenchPart) {
        IWorkbenchPartReference workbenchPartReferece = this.getWorkbenchReference(workbenchPart);
        if (workbenchPartReferece != null) {
            Control workbenchControl = WorkbenchPartLookup.getInstance().getWorkbenchControl(workbenchPartReferece);
            this.log.debug("Active workbench control=" + (workbenchControl == null ? "null" : this.getControlDesc(workbenchControl)));
            Control focusedControl = WidgetLookup.getInstance().getFocusControl();
            this.log.debug("Focused control=" + (focusedControl == null ? "null" : this.getControlDesc(focusedControl)));
            if (this.hasControlSpecificParent(focusedControl, workbenchControl)) {
                return;
            }
            this.log.debug("No control in opened view has a focus!");
            this.log.debug("Setting implicit focus...");
            this.setFocusOnControlChild(workbenchControl);
        }
    }

    private IWorkbenchPartReference getWorkbenchReference(final IWorkbenchPart workbenchPart) {
        return (IWorkbenchPartReference)Display.syncExec((ResultRunnable)new ResultRunnable<IWorkbenchPartReference>(){

            public IWorkbenchPartReference run() {
                return workbenchPart.getSite().getPage().getReference(workbenchPart);
            }
        });
    }

    private void setFocusOnControlChild(final Control workbenchControl) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Control[] childrenControls = ((Composite)workbenchControl).getChildren();
                if (childrenControls.length > 0) {
                    Control firstChildControl = childrenControls[0];
                    firstChildControl.setFocus();
                } else {
                    WorkbenchPartHandler.this.log.debug("View with title '" + workbenchControl.getToolTipText() + "' has " + "no children!");
                }
            }
        });
    }

    private boolean hasControlSpecificParent(final Control focusedControl, final Control workbenchControl) {
        Control parent = (Control)Display.syncExec((ResultRunnable)new ResultRunnable<Control>(){

            public Control run() {
                Control parent = focusedControl;
                while (parent != null && !parent.equals(workbenchControl) && !parent.isDisposed()) {
                    parent = parent.getParent();
                }
                return parent;
            }
        });
        return workbenchControl.equals(parent);
    }

    private String getControlDesc(Control control) {
        String value;
        StringBuffer sbDesc = new StringBuffer("Class=");
        sbDesc.append(control.getClass().getName());
        sbDesc.append(" Text=");
        try {
            value = TextWidgetUtil.getText((Widget)control);
        }
        catch (RedDeerException redDeerException) {
            value = "<unavailable>";
        }
        sbDesc.append(value);
        sbDesc.append(" TooltipText=");
        sbDesc.append(ControlHandler.getInstance().getToolTipText(control));
        return sbDesc.toString();
    }

    public void activate(final IWorkbenchPart workbenchPart) {
        if (!this.isActive(workbenchPart)) {
            this.log.debug("Activating workbench part " + this.getTitle(workbenchPart));
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(workbenchPart);
                }
            });
        }
        this.setFocus(workbenchPart);
        this.focusChildControl(workbenchPart);
    }

    public void performAction(final ActionFactory actionFactory) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionFactory.IWorkbenchAction action = actionFactory.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                action.run();
            }
        });
    }

    public boolean isWorkbenchPartVisible(final IWorkbenchPart workbenchPart) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                if (workbenchPart != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isPartVisible(workbenchPart)) {
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isActive(final IWorkbenchPart workbenchPart) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                if (workbenchPart == PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) {
                    return true;
                }
                return false;
            }
        });
    }

    public void activateWorkbenchPartWithWidget(Widget widget) {
        final WorkbenchPartWidgets workbenchPartWidgets = this.getWorkbenchPartWidgetsForWidget(widget);
        if (workbenchPartWidgets == null) {
            throw new WorkbenchLayerException("Unable to activate workbench part with widget. No cTabFolder found in widget path");
        }
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                CTabItem[] cTabItems = workbenchPartWidgets.workbenchPartCTabFolder.getItems();
                int index = 0;
                boolean cTabItemFound = false;
                while (!cTabItemFound && index < cTabItems.length) {
                    if (cTabItems[index].getControl() == workbenchPartWidgets.firstCTabItemControl) {
                        cTabItemFound = true;
                        WorkbenchPartHandler.this.log.debug("Activating Workbench part with label: '" + cTabItems[index].getText() + "'");
                        CTabItemHandler.getInstance().activate(cTabItems[index]);
                        continue;
                    }
                    ++index;
                }
            }
        });
    }

    public String getTitleOfWorkbenchPartWithWidget(Widget widget) {
        final WorkbenchPartWidgets workbenchPartWidgets = this.getWorkbenchPartWidgetsForWidget(widget);
        if (workbenchPartWidgets != null) {
            return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

                public String run() {
                    CTabItem[] cTabItems = workbenchPartWidgets.workbenchPartCTabFolder.getItems();
                    int index = 0;
                    String cTabItemTitle = null;
                    while (cTabItemTitle == null && index < cTabItems.length) {
                        if (cTabItems[index].getControl() == workbenchPartWidgets.firstCTabItemControl) {
                            cTabItemTitle = cTabItems[index].getText();
                            continue;
                        }
                        ++index;
                    }
                    return cTabItemTitle;
                }
            });
        }
        throw new WorkbenchLayerException("Unable to get title of workbench part with widget. No cTabFolder found in widget path");
    }

    private WorkbenchPartWidgets getWorkbenchPartWidgetsForWidget(Widget widget) {
        WorkbenchPartWidgets workbenchPartWidgets = null;
        List pathToWidget = WidgetLookup.getInstance().getPathToWidget(widget, new Class[0]);
        Iterator itWidget = pathToWidget.iterator();
        boolean foundCTabFolder = false;
        Widget currentWidget = null;
        while (!foundCTabFolder && itWidget.hasNext()) {
            currentWidget = (Widget)itWidget.next();
            if (!(currentWidget instanceof CTabFolder)) continue;
            foundCTabFolder = true;
        }
        if (foundCTabFolder) {
            workbenchPartWidgets = new WorkbenchPartWidgets((CTabFolder)currentWidget, (Control)itWidget.next());
        }
        return workbenchPartWidgets;
    }

    private class WorkbenchPartWidgets {
        public CTabFolder workbenchPartCTabFolder = null;
        public Control firstCTabItemControl = null;

        public WorkbenchPartWidgets(CTabFolder workbenchPartCTabFolder, Control firstCTabItemControl) {
            this.workbenchPartCTabFolder = workbenchPartCTabFolder;
            this.firstCTabItemControl = firstCTabItemControl;
        }
    }
}

