/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.navigableElement;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationContributor;
import org.eclipse.papyrus.uml.navigation.navigableElement.ChildNavigableElement;
import org.eclipse.papyrus.uml.navigation.navigableElement.ParentNavigableElement;
import org.eclipse.papyrus.uml.navigation.navigableElement.SourceNavigableElement;
import org.eclipse.papyrus.uml.navigation.navigableElement.TargetNavigableElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Relationship;

public class ElementRelationshipNavigationContributor
implements NavigationContributor {
    public List<NavigableElement> getNavigableElements(Object fromElement) {
        LinkedList<NavigableElement> result = new LinkedList<NavigableElement>();
        UniqueEList targets = new UniqueEList();
        UniqueEList sources = new UniqueEList();
        UniqueEList children = new UniqueEList();
        UniqueEList parents = new UniqueEList();
        Element element = UMLUtil.resolveUMLElement((Object)fromElement);
        if (element instanceof Element) {
            for (Relationship relationship : element.getRelationships()) {
                if (relationship instanceof Generalization) {
                    Generalization generalization = (Generalization)relationship;
                    if (generalization.getSpecific() == element && generalization.getGeneral() != null) {
                        parents.add(generalization.getGeneral());
                    }
                    if (generalization.getGeneral() != element || generalization.getSpecific() == null) continue;
                    children.add(generalization.getSpecific());
                    continue;
                }
                if (!(relationship instanceof DirectedRelationship)) continue;
                DirectedRelationship directedRelationship = (DirectedRelationship)relationship;
                if (directedRelationship.getSources().contains((Object)element)) {
                    for (Element target : directedRelationship.getTargets()) {
                        targets.add(target);
                    }
                }
                if (!directedRelationship.getTargets().contains((Object)element)) continue;
                for (Element source : directedRelationship.getSources()) {
                    sources.add(source);
                }
            }
            for (Element parent : parents) {
                result.add((NavigableElement)new ParentNavigableElement(parent));
            }
            for (Element child : children) {
                result.add((NavigableElement)new ChildNavigableElement(child));
            }
            for (Element target : targets) {
                result.add((NavigableElement)new TargetNavigableElement(target));
            }
            for (Element source : sources) {
                result.add((NavigableElement)new SourceNavigableElement(source));
            }
        }
        return result;
    }
}

