/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.deltaPropagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationHaltedException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EvaluationVisitorImpl;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.PartialEcoreEvaluationEnvironment;
import org.eclipse.ocl.examples.impactanalyzer.impl.ImpactAnalyzerPlugin;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialEvaluationVisitorImpl
extends EvaluationVisitorImpl {
    private org.eclipse.ocl.ecore.OCLExpression sourceExpression;
    private Object valueOfSourceExpression;
    private Notification atPre;

    public PartialEvaluationVisitorImpl(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evalEnv, Map<? extends EClass, ? extends Set<? extends EObject>> extentMap, org.eclipse.ocl.ecore.OCLExpression sourceExpression, Object valueOfSourceExpression, Notification atPre) {
        super(env, evalEnv, extentMap);
        this.sourceExpression = sourceExpression;
        this.valueOfSourceExpression = valueOfSourceExpression;
        this.atPre = atPre;
    }

    public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> oc) {
        if (oc == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        int opCode = oc.getOperationCode();
        if (opCode == 158) {
            OCLExpression source = oc.getSource();
            EList args = oc.getArgument();
            Object sourceVal = source.accept((Visitor)this.getVisitor());
            if (sourceVal == this.getInvalid() || ((Collection)sourceVal).isEmpty()) {
                return this.getInvalid();
            }
            OCLExpression arg = (OCLExpression)args.get(0);
            if (this.isUndefined(sourceVal)) {
                return this.getInvalid();
            }
            Collection sourceColl = (Collection)sourceVal;
            Object argVal = arg.accept((Visitor)this.getVisitor());
            if (argVal == this.getInvalid()) {
                return argVal;
            }
            if (!(argVal instanceof Integer)) {
                return this.getInvalid();
            }
            int indexVal = (Integer)argVal;
            return CollectionUtil.at((Collection)sourceColl, (int)indexVal);
        }
        return super.visitOperationCallExp(oc);
    }

    protected Object safeVisitExpression(OCLExpression<EClassifier> source) {
        Object sourceVal;
        try {
            sourceVal = source.accept((Visitor)this.getVisitor());
        }
        catch (EvaluationHaltedException ehe) {
            throw ehe;
        }
        catch (ValueNotFoundException vnfe) {
            throw vnfe;
        }
        catch (RuntimeException e) {
            sourceVal = this.getInvalid();
        }
        return sourceVal;
    }

    public Object visitIterateExp(IterateExp<EClassifier, EParameter> ie) {
        if (ie == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitIterateExp(ie);
    }

    public Object visitIteratorExp(IteratorExp<EClassifier, EParameter> ie) {
        if (ie == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitIteratorExp(ie);
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> el) {
        if (el == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitEnumLiteralExp(el);
    }

    public PartialEcoreEvaluationEnvironment getEvaluationEnvironment() {
        return (PartialEcoreEvaluationEnvironment)super.getEvaluationEnvironment();
    }

    public Object visitVariableExp(VariableExp<EClassifier, EParameter> v) {
        if (v == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return this.getEvaluationEnvironment().getValueOf(v);
    }

    public Object visitPropertyCallExp(PropertyCallExp<EClassifier, EStructuralFeature> pc) {
        Collection localResult;
        if (pc == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        EStructuralFeature property = (EStructuralFeature)pc.getReferredProperty();
        OCLExpression source = pc.getSource();
        Object context = source.accept((Visitor)this.getVisitor());
        if (this.isUndefined(context)) {
            localResult = this.getInvalid();
        } else {
            OCLExpression derivation = this.getPropertyBody(property);
            if (derivation != null) {
                localResult = this.navigate(property, derivation, context);
            } else {
                List qualifiers;
                if (pc.getQualifier().isEmpty()) {
                    qualifiers = Collections.emptyList();
                } else {
                    qualifiers = new ArrayList();
                    for (OCLExpression q : pc.getQualifier()) {
                        qualifiers.add(q.accept((Visitor)this.getVisitor()));
                    }
                }
                localResult = this.getEvaluationEnvironment().navigateProperty(property, qualifiers, context);
                if (pc.getType() instanceof CollectionType && !(localResult instanceof Collection)) {
                    CollectionKind kind = ((CollectionType)pc.getType()).getKind();
                    Collection collection = CollectionUtil.createNewCollection((CollectionKind)kind);
                    collection.add(localResult);
                    localResult = collection;
                }
            }
        }
        if (this.atPre != null && this.atPre.getNotifier() != null && this.atPre.getNotifier() == context && pc.getReferredProperty() == this.atPre.getFeature()) {
            CollectionKind kind = pc.getType() instanceof CollectionType ? ((CollectionType)pc.getType()).getKind() : null;
            switch (this.atPre.getEventType()) {
                case 3: {
                    localResult = this.removeAt(localResult, kind);
                    break;
                }
                case 5: {
                    ((Collection)localResult).removeAll((Collection)this.atPre.getNewValue());
                    break;
                }
                case 7: {
                    localResult = this.move(localResult, kind);
                    break;
                }
                case 4: {
                    localResult = this.insertAt(localResult, kind);
                    break;
                }
                case 6: {
                    localResult = this.insertManyAt(localResult, kind);
                    break;
                }
                case 1: 
                case 2: {
                    localResult = this.atPre.getOldValue();
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new RuntimeException("Don't understand @pre notification " + this.atPre);
                }
            }
        }
        return localResult;
    }

    private <T> Collection<T> insertManyAt(Collection<T> into, CollectionKind kind) {
        Collection result;
        int[] oldPositions = (int[])this.atPre.getNewValue();
        if ((kind == CollectionKind.SEQUENCE_LITERAL || kind == CollectionKind.ORDERED_SET_LITERAL) && this.atPre.getPosition() != -1) {
            if (into instanceof List) {
                int i = 0;
                for (Object t : (Collection)this.atPre.getOldValue()) {
                    ((List)into).add(oldPositions[i++], t);
                }
                result = into;
            } else if (oldPositions[0] >= into.size()) {
                for (Object t : (Collection)this.atPre.getOldValue()) {
                    ((List)into).add(t);
                }
                result = into;
            } else {
                result = CollectionUtil.createNewCollection((CollectionKind)kind);
                int i = 0;
                Iterator removedIter = ((Collection)this.atPre.getOldValue()).iterator();
                int targetPos = 0;
                for (Object t : into) {
                    if (targetPos == oldPositions[i]) {
                        result.add(removedIter.next());
                        ++targetPos;
                    }
                    result.add(t);
                    ++targetPos;
                }
            }
        } else {
            into.addAll((Collection)this.atPre.getOldValue());
            result = into;
        }
        return result;
    }

    private <T> Collection<T> move(Collection<T> collection, CollectionKind kind) {
        Collection result = collection;
        if ((kind == CollectionKind.SEQUENCE_LITERAL || kind == CollectionKind.ORDERED_SET_LITERAL) && this.atPre.getPosition() != -1) {
            int oldPositionBeforeMove = (Integer)this.atPre.getOldValue();
            int newPositionAfterMove = this.atPre.getPosition();
            if (collection instanceof List) {
                if (((List)collection).get(this.atPre.getPosition()) != this.atPre.getNewValue()) {
                    throw new RuntimeException("Internal error. Didn't find " + this.atPre.getNewValue() + " at position " + this.atPre.getPosition());
                }
                ((List)collection).remove(newPositionAfterMove);
                ((List)collection).add(oldPositionBeforeMove, this.atPre.getNewValue());
                result = collection;
            } else if (oldPositionBeforeMove >= collection.size()) {
                collection.remove(this.atPre.getNewValue());
                collection.add(this.atPre.getNewValue());
            } else {
                result = CollectionUtil.createNewCollection((CollectionKind)kind);
                int sourcePos = 0;
                int targetPos = 0;
                for (Object t : collection) {
                    if (targetPos == oldPositionBeforeMove) {
                        result.add(this.atPre.getNewValue());
                        ++targetPos;
                    }
                    if (sourcePos != newPositionAfterMove) {
                        result.add(t);
                        ++targetPos;
                    }
                    ++sourcePos;
                }
            }
        }
        return result;
    }

    private <T> Collection<T> removeAt(Collection<T> from, CollectionKind kind) {
        Collection result;
        if ((kind == CollectionKind.SEQUENCE_LITERAL || kind == CollectionKind.ORDERED_SET_LITERAL) && this.atPre.getPosition() != -1) {
            if (from instanceof List) {
                if (((List)from).get(this.atPre.getPosition()) != this.atPre.getNewValue()) {
                    throw new RuntimeException("Internal error. Didn't find " + this.atPre.getNewValue() + " at position " + this.atPre.getPosition());
                }
                ((List)from).remove(this.atPre.getPosition());
                result = from;
            } else {
                result = CollectionUtil.createNewCollection((CollectionKind)kind);
                int i = 0;
                for (Object t : from) {
                    if (i++ == this.atPre.getPosition()) continue;
                    result.add(t);
                }
            }
        } else {
            from.remove(this.atPre.getNewValue());
            result = from;
        }
        return result;
    }

    private <T> Collection<T> insertAt(Collection<T> into, CollectionKind kind) {
        Collection result;
        if ((kind == CollectionKind.SEQUENCE_LITERAL || kind == CollectionKind.ORDERED_SET_LITERAL) && this.atPre.getPosition() != -1) {
            if (into instanceof List) {
                ((List)into).add(this.atPre.getPosition(), this.atPre.getOldValue());
                result = into;
            } else if (this.atPre.getPosition() >= into.size()) {
                into.add(this.atPre.getOldValue());
                result = into;
            } else {
                result = CollectionUtil.createNewCollection((CollectionKind)kind);
                int i = 0;
                for (Object t : into) {
                    if (i++ == this.atPre.getPosition()) {
                        result.add(this.atPre.getOldValue());
                        ++i;
                    }
                    result.add(t);
                }
            }
        } else {
            into.add(this.atPre.getOldValue());
            result = into;
        }
        return result;
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp<EClassifier, EStructuralFeature> ae) {
        if (ae == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitAssociationClassCallExp(ae);
    }

    public Object visitIfExp(IfExp<EClassifier> ie) {
        if (ie == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitIfExp(ie);
    }

    public Object visitTypeExp(TypeExp<EClassifier> t) {
        if (t == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitTypeExp(t);
    }

    public Object visitStateExp(StateExp<EClassifier, EObject> s) {
        if (s == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitStateExp(s);
    }

    public Object visitMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> m) {
        if (m == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitMessageExp(m);
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp<EClassifier> uv) {
        if (uv == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitUnspecifiedValueExp(uv);
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp<EClassifier> il) {
        if (il == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitIntegerLiteralExp(il);
    }

    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<EClassifier> literalExp) {
        if (literalExp == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitUnlimitedNaturalLiteralExp(literalExp);
    }

    public Object visitRealLiteralExp(RealLiteralExp<EClassifier> rl) {
        if (rl == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitRealLiteralExp(rl);
    }

    public Object visitStringLiteralExp(StringLiteralExp<EClassifier> sl) {
        if (sl == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitStringLiteralExp(sl);
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp<EClassifier> bl) {
        if (bl == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitBooleanLiteralExp(bl);
    }

    public Object visitInvalidLiteralExp(InvalidLiteralExp<EClassifier> il) {
        if (il == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitInvalidLiteralExp(il);
    }

    public Object visitNullLiteralExp(NullLiteralExp<EClassifier> il) {
        if (il == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitNullLiteralExp(il);
    }

    public Object visitLetExp(LetExp<EClassifier, EParameter> l) {
        if (l == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitLetExp(l);
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> cl) {
        if (cl == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitCollectionLiteralExp(cl);
    }

    public Object visitTupleLiteralExp(TupleLiteralExp<EClassifier, EStructuralFeature> tl) {
        if (tl == this.sourceExpression) {
            this.sourceExpression = null;
            return this.valueOfSourceExpression;
        }
        return super.visitTupleLiteralExp(tl);
    }

    public Object visitExpression(OCLExpression<EClassifier> expression) {
        try {
            return expression.accept((Visitor)this.getVisitor());
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (ValueNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = "(no message)";
            }
            ImpactAnalyzerPlugin.log(4, 10, "Evaluation failed with an exception: " + msg, e);
            return this.getInvalid();
        }
    }

    public Object visitOppositePropertyCallExp(OppositePropertyCallExp pc) {
        Object localResult;
        if (pc == this.getSourceExpression()) {
            this.setSourceExpression(null);
            return this.getValueOfSourceExpression();
        }
        EReference property = pc.getReferredOppositeProperty();
        OCLExpression source = pc.getSource();
        Object context = source.accept((Visitor)this.getVisitor());
        if (this.isUndefined(context)) {
            localResult = this.getInvalid();
        } else {
            localResult = this.getEvaluationEnvironment().navigateOppositeProperty(property, context);
            if (pc.getType() instanceof CollectionType && !(localResult instanceof Collection)) {
                CollectionKind kind = ((CollectionType)pc.getType()).getKind();
                Collection collection = CollectionUtil.createNewCollection((CollectionKind)kind);
                collection.add(localResult);
                localResult = collection;
            }
        }
        if (this.getAtPre() != null && (this.getAtPre().getOldValue() != null && (this.getAtPre().getOldValue() instanceof Collection && ((Collection)this.getAtPre().getOldValue()).contains(context) || this.getAtPre().getOldValue() == context) || this.getAtPre().getNewValue() != null && (this.getAtPre().getNewValue() instanceof Collection && ((Collection)this.getAtPre().getNewValue()).contains(context) || this.getAtPre().getNewValue() == context)) && pc.getReferredOppositeProperty() == this.getAtPre().getFeature()) {
            switch (this.getAtPre().getEventType()) {
                case 3: 
                case 5: {
                    ((Collection)localResult).remove(this.getAtPre().getNotifier());
                    break;
                }
                case 7: {
                    break;
                }
                case 4: 
                case 6: {
                    ((Collection)localResult).add(this.getAtPre().getNotifier());
                    break;
                }
                case 1: 
                case 2: {
                    if (this.getAtPre().getOldValue() == context) {
                        ((Collection)localResult).add(this.getAtPre().getNotifier());
                        break;
                    }
                    if (this.getAtPre().getNewValue() != context) break;
                    ((Collection)localResult).remove(this.getAtPre().getNotifier());
                    break;
                }
                default: {
                    throw new RuntimeException("Don't understand @pre notification " + this.getAtPre());
                }
            }
        }
        return localResult;
    }

    protected org.eclipse.ocl.ecore.OCLExpression getSourceExpression() {
        return this.sourceExpression;
    }

    protected void setSourceExpression(org.eclipse.ocl.ecore.OCLExpression sourceExpression) {
        this.sourceExpression = sourceExpression;
    }

    protected Object getValueOfSourceExpression() {
        return this.valueOfSourceExpression;
    }

    protected Notification getAtPre() {
        return this.atPre;
    }
}

