/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.WidthGroup;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MavenParentComponent
extends Composite {
    private final Combo parentArtifactIdCombo;
    private final Combo parentGroupIdCombo;
    private final Combo parentVersionCombo;
    private Button parentClearButton;
    private Button parentBrowseButton;
    private final Label groupIdLabel;
    private final Label artifactIdLabel;
    private final Label versionLabel;

    public MavenParentComponent(Composite parent, int style) {
        super(parent, 0);
        boolean readonly = (style & 8) != 0;
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        this.setLayout((Layout)topLayout);
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setText(Messages.wizardProjectPageArtifactParentTitle);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        this.groupIdLabel = new Label((Composite)group, 0);
        this.groupIdLabel.setText(Messages.wizardProjectPageArtifactParentGroupId);
        this.parentGroupIdCombo = new Combo((Composite)group, 0);
        this.parentGroupIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.parentGroupIdCombo.setData("name", (Object)"parentGroupIdCombo");
        this.parentGroupIdCombo.setEnabled(!readonly);
        this.artifactIdLabel = new Label((Composite)group, 0);
        this.artifactIdLabel.setText(Messages.wizardProjectPageArtifactParentArtifactId);
        this.parentArtifactIdCombo = new Combo((Composite)group, 0);
        this.parentArtifactIdCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.parentArtifactIdCombo.setData("name", (Object)"parentArtifactIdCombo");
        this.parentArtifactIdCombo.setEnabled(!readonly);
        this.versionLabel = new Label((Composite)group, 0);
        this.versionLabel.setText(Messages.wizardProjectPageArtifactParentVersion);
        this.parentVersionCombo = new Combo((Composite)group, 0);
        GridData gd_versionCombo = new GridData(16384, 0x1000000, true, false);
        gd_versionCombo.widthHint = 150;
        this.parentVersionCombo.setLayoutData((Object)gd_versionCombo);
        this.parentVersionCombo.setEnabled(!readonly);
        this.parentVersionCombo.setData("name", (Object)"parentVersionCombo");
        if (!readonly) {
            Composite buttonPanel = new Composite((Composite)group, 0);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = false;
            rowLayout.marginTop = 0;
            rowLayout.marginRight = 0;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            buttonPanel.setLayout((Layout)rowLayout);
            buttonPanel.setLayoutData((Object)new GridData(131072, 128, false, false));
            this.parentBrowseButton = new Button(buttonPanel, 0);
            this.parentBrowseButton.setText(Messages.wizardProjectPageArtifactParentBrowse);
            this.parentBrowseButton.setData("name", (Object)"parentBrowseButton");
            this.parentClearButton = new Button(buttonPanel, 0);
            this.parentClearButton.setText(Messages.wizardProjectPageArtifactParentClear);
            this.parentClearButton.setData("name", (Object)"parentClearButton");
            this.parentClearButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setValues("", "", "")));
        }
    }

    public Combo getGroupIdCombo() {
        return this.parentGroupIdCombo;
    }

    public Combo getArtifactIdCombo() {
        return this.parentArtifactIdCombo;
    }

    public Combo getVersionCombo() {
        return this.parentVersionCombo;
    }

    public void setWidthGroup(WidthGroup widthGroup) {
        widthGroup.addControl((Control)this.groupIdLabel);
        widthGroup.addControl((Control)this.artifactIdLabel);
        widthGroup.addControl((Control)this.versionLabel);
    }

    public void addModifyListener(ModifyListener listener) {
        this.parentArtifactIdCombo.addModifyListener(listener);
        this.parentGroupIdCombo.addModifyListener(listener);
        this.parentVersionCombo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.parentArtifactIdCombo.removeModifyListener(listener);
        this.parentGroupIdCombo.removeModifyListener(listener);
        this.parentVersionCombo.removeModifyListener(listener);
    }

    public void addBrowseButtonListener(SelectionListener listener) {
        if (this.parentBrowseButton != null) {
            this.parentBrowseButton.addSelectionListener(listener);
        }
    }

    public void removeBrowseButtonListener(SelectionListener listener) {
        if (this.parentBrowseButton != null) {
            this.parentBrowseButton.removeSelectionListener(listener);
        }
    }

    public void setClearButtonEnabled(boolean enabled) {
        if (this.parentClearButton != null) {
            this.parentClearButton.setEnabled(enabled);
        }
    }

    public void setValues(String groupId, String artifactId, String version) {
        this.parentGroupIdCombo.setText(groupId == null ? "" : groupId);
        this.parentArtifactIdCombo.setText(artifactId == null ? "" : artifactId);
        this.parentVersionCombo.setText(version == null ? "" : version);
    }

    public void updateModel(Model model) {
        String groupId = this.parentGroupIdCombo.getText().trim();
        if (groupId.length() > 0) {
            Parent parent = new Parent();
            parent.setGroupId(groupId);
            parent.setArtifactId(this.parentArtifactIdCombo.getText().trim());
            parent.setVersion(this.parentVersionCombo.getText().trim());
            model.setParent(parent);
        }
    }

    public boolean validate() {
        int parentCheck = 0;
        if (this.parentGroupIdCombo.getText().trim().length() > 0) {
            ++parentCheck;
        }
        if (this.parentArtifactIdCombo.getText().trim().length() > 0) {
            ++parentCheck;
        }
        if (this.parentVersionCombo.getText().trim().length() > 0) {
            ++parentCheck;
        }
        this.setClearButtonEnabled(parentCheck > 0);
        return parentCheck == 0 || parentCheck == 3;
    }
}

