/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.Messages;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.ProviderFramework;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class AbstractProviderPropertyTab
extends AbstractCPropertyTab {
    private static final String PROVIDER_ATT_INFO = "information";
    private static final String PROVIDER_ATT_DESC = "description";
    private Link fLink;
    private Button useProjectSetting;
    private ScopedPreferenceStore preferenceStore;
    private Group projectSettingsGroup;
    private Button[] radioButtons;
    private String value;

    protected abstract String getType();

    protected abstract String getPrefPageId();

    protected void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, true));
        IResource resource = (IResource)this.page.getElement().getAdapter(IResource.class);
        IProject project = resource.getProject();
        ProjectScope ps = new ProjectScope(project);
        ScopedPreferenceStore scoped = new ScopedPreferenceStore((IScopeContext)ps, "org.eclipse.linuxtools.profiling.launch");
        scoped.setSearchContexts(new IScopeContext[]{ps, InstanceScope.INSTANCE});
        this.setPreferenceStore(scoped);
        this.getPreferenceStore().setDefault("use_project" + this.getType(), false);
        this.useProjectSetting = new Button(this.usercomp, 32);
        this.useProjectSetting.setText(Messages.UseProjectSetting_0);
        this.useProjectSetting.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.useProjectSetting.setSelection(this.getPreferenceStore().getBoolean("use_project" + this.getType()));
        this.useProjectSetting.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateOptionsEnable()));
        String highestProviderId = ProviderFramework.getHighestProviderId(this.getType());
        if (highestProviderId != null) {
            this.getPreferenceStore().setDefault("provider" + this.getType(), highestProviderId);
        } else {
            this.useProjectSetting.setEnabled(false);
        }
        this.fLink = new Link(this.usercomp, 0);
        this.fLink.setText(Messages.PreferenceLink_0);
        this.fLink.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        this.fLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int n = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)this.getPrefPageId(), null, null).open();
        }));
        HashMap<String, String> map = ProviderFramework.getProviderNamesForType(this.getType());
        String[][] providerList = new String[map.size()][2];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String toolId = entry.getValue();
            String toolDescription = ProviderFramework.getToolInformationFromId(toolId, PROVIDER_ATT_DESC);
            String toolName = entry.getKey();
            if (toolDescription != null && !toolDescription.isEmpty()) {
                toolName = String.valueOf(toolName) + " " + "[" + toolDescription + "]";
            }
            providerList[i][0] = toolName;
            providerList[i][1] = toolId;
            ++i;
        }
        this.projectSettingsGroup = new Group(this.usercomp, 0);
        this.projectSettingsGroup.setFont(parent.getFont());
        this.projectSettingsGroup.setText(Messages.ProviderPreferencesPage_1);
        this.projectSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = 1;
        this.projectSettingsGroup.setLayout((Layout)layout);
        this.radioButtons = new Button[map.size()];
        int j = 0;
        while (j < this.radioButtons.length) {
            Button radio = new Button((Composite)this.projectSettingsGroup, 16400);
            radio.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
            this.radioButtons[j] = radio;
            String[] labelAndValue = providerList[j];
            String curProviderId = labelAndValue[1];
            String toolInfo = ProviderFramework.getToolInformationFromId(curProviderId, PROVIDER_ATT_INFO);
            if (toolInfo != null && !toolInfo.isEmpty()) {
                radio.setToolTipText(toolInfo);
            }
            radio.setText(labelAndValue[0]);
            radio.setData((Object)labelAndValue[1]);
            radio.setFont(parent.getFont());
            radio.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
                String string = this.value = (String)event.widget.getData();
            }));
            ++j;
        }
        this.projectSettingsGroup.addDisposeListener(event -> {
            this.projectSettingsGroup = null;
            this.radioButtons = null;
        });
        this.updateOptionsEnable();
        this.updateValue(this.getPreferenceStore().getString("provider" + this.getType()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
    }

    private void setButtonsEnabled(boolean value) {
        int j = 0;
        while (j < this.radioButtons.length) {
            this.radioButtons[j].setEnabled(value);
            ++j;
        }
    }

    private void updateOptionsEnable() {
        if (this.useProjectSetting.getSelection()) {
            this.projectSettingsGroup.setEnabled(true);
            this.setButtonsEnabled(true);
            this.fLink.setVisible(false);
        } else {
            this.setButtonsEnabled(false);
            this.projectSettingsGroup.setEnabled(false);
            this.fLink.setVisible(true);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSetting.getSelection()) {
            this.updateValue(this.getPreferenceStore().getDefaultString("provider" + this.getType()));
        }
        this.updateOptionsEnable();
    }

    public void performOK() {
        this.getPreferenceStore().setValue("use_project" + this.getType(), this.useProjectSetting.getSelection());
        this.getPreferenceStore().setValue("provider" + this.getType(), this.value);
        try {
            this.getPreferenceStore().save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    private void setPreferenceStore(ScopedPreferenceStore store) {
        this.preferenceStore = store;
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.getPreferenceStore().setValue("use_project" + this.getType(), this.useProjectSetting.getSelection());
        this.getPreferenceStore().setValue("provider" + this.getType(), this.value);
        try {
            this.getPreferenceStore().save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateValue(String selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean found = false;
            int i = 0;
            while (i < this.radioButtons.length) {
                Button radio = this.radioButtons[i];
                boolean selection = false;
                if (((String)radio.getData()).equals(this.value)) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
                ++i;
            }
            if (found) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    public String getHelpContextId() {
        return "org.eclipse.linuxtools.profiling.launch.profiling_categories";
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected void updateButtons() {
    }

    protected void updateData(ICResourceDescription cfg) {
    }
}

