/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.HTMLSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.HTMLSAXParserOld;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.FuncFoundSaxException;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LibHoverMessages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseDevHelp {
    private static final String PARSING_MSG = "Libhover.Devhelp.Parsing.msg";
    private static final String PARSING_FMT_MSG = "Libhover.Devhelp.Parsing.fmt.msg";

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        startParse = System.currentTimeMillis();
        devhelpHtmlDirectory = "/usr/share/gtk-doc/html";
        p = new DevHelpParser(devhelpHtmlDirectory, false);
        dir = new File(devhelpHtmlDirectory);
        var9_5 = dir.listFiles();
        var8_6 = var9_5.length;
        var7_8 = 0;
        while (var7_8 < var8_6) {
            f = var9_5[var7_8];
            name = f.getName();
            p.parse(String.valueOf(f.getAbsolutePath()) + "/" + name + ".devhelp2", (IProgressMonitor)new NullProgressMonitor());
            ++var7_8;
        }
        endParse = System.currentTimeMillis();
        System.out.println("Parse Complete:" + (endParse - startParse));
        startSerialize = System.currentTimeMillis();
        hover = p.getLibHoverInfo();
        try {
            workspaceDir = new Path(args[1]);
            location = workspaceDir.append("org.eclipse.linuxtools.cdt.libhover/C");
            ldir = new File(location.toOSString());
            ldir.mkdir();
            location = location.append("devhelp.libhover");
            var14_17 = null;
            var15_19 = null;
            try {
                f = new FileOutputStream(location.toOSString());
                try {
                    out = new ObjectOutputStream(f);
                    try {
                        out.writeObject(hover);
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    ** if (f == null) goto lbl-1000
                }
                catch (Throwable var15_20) {
                    if (var14_17 == null) {
                        var14_17 = var15_20;
                    } else if (var14_17 != var15_20) {
                        var14_17.addSuppressed(var15_20);
                    }
                    if (f != null) {
                        f.close();
                    }
                    throw var14_17;
                }
lbl-1000:
                // 1 sources

                {
                    f.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var15_21) {
                if (var14_17 == null) {
                    var14_17 = var15_21;
                } else if (var14_17 != var15_21) {
                    var14_17.addSuppressed(var15_21);
                }
                throw var14_17;
            }
        }
        catch (IOException workspaceDir) {
            // empty catch block
        }
        endSerialize = System.currentTimeMillis();
        System.out.println("Parse Complete:" + (endSerialize - startSerialize));
    }

    public static class DevHelpParser {
        private String dirName;
        private LibHoverInfo libhover;
        private boolean debug;
        private FilenameComparator filenameComparator = new FilenameComparator();
        private NullEntityResolver entityResolver = new NullEntityResolver();
        private DocumentBuilderFactory factory;

        public DevHelpParser(String dirName) {
            this(dirName, false);
        }

        public DevHelpParser(String dirName, boolean debug) {
            this.dirName = dirName;
            this.libhover = new LibHoverInfo();
            this.debug = debug;
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(false);
        }

        public LibHoverInfo getLibHoverInfo() {
            return this.libhover;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LibHoverInfo parse(IProgressMonitor monitor) {
            try {
                IFileSystem fs = EFS.getLocalFileSystem();
                Path dirPath = new Path(this.dirName);
                IFileStore htmlDir = fs.getStore((IPath)dirPath);
                IFileStore[] files = htmlDir.childStores(0, null);
                monitor.beginTask(LibHoverMessages.getString(ParseDevHelp.PARSING_MSG), files.length);
                Arrays.sort(files, this.filenameComparator);
                int i = 0;
                while (true) {
                    if (i >= files.length) {
                        return this.libhover;
                    }
                    IFileStore file = files[i];
                    String name = file.fetchInfo().getName();
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    monitor.setTaskName(LibHoverMessages.getFormattedString(ParseDevHelp.PARSING_FMT_MSG, new String[]{name}));
                    File f = new File(dirPath.append(name).append(String.valueOf(name) + ".devhelp2").toOSString());
                    if (f.exists()) {
                        this.parse(f.getAbsolutePath(), monitor);
                    } else {
                        this.parse(dirPath.append(name).append(String.valueOf(name) + ".devhelp").toOSString(), monitor);
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.libhover;
        }

        private void parseLinks(HashMap<String, String> funcMap, String fileName, IPath path, LibHoverInfo libhover) {
            FileInputStream reader = null;
            AbstractSAXParser parser = null;
            try {
                reader = new FileInputStream(String.valueOf(path.removeLastSegments(1).toOSString()) + "/" + fileName);
                parser = funcMap.size() == 1 && funcMap.containsKey("name") ? new HTMLSAXParser(funcMap) : new HTMLSAXParserOld(funcMap);
                try {
                    parser.parse(new InputSource(reader));
                }
                catch (FuncFoundSaxException funcFoundSaxException) {
                    // empty catch block
                }
                ((InputStream)reader).close();
                TreeMap<String, FunctionInfo> finfos = ((DevHelpSAXParser)parser).getFunctionInfos();
                if (finfos != null) {
                    if (this.debug) {
                        System.out.println(parser.toString());
                    }
                    libhover.functions.putAll(finfos);
                }
            }
            catch (IOException finfos) {
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }

        private void parse(String fileName, IProgressMonitor monitor) {
            try {
                HashMap files = new HashMap();
                Path path = new Path(fileName);
                File f = new File(fileName);
                FileInputStream stream = new FileInputStream(f);
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                builder.setEntityResolver(this.entityResolver);
                Document doc = builder.parse(stream);
                NodeList bookNodes = doc.getElementsByTagName("book");
                int x = 0;
                while (x < bookNodes.getLength()) {
                    Node n = bookNodes.item(x);
                    NamedNodeMap m = n.getAttributes();
                    Node language = m.getNamedItem("language");
                    if (language != null && !language.getNodeValue().equals("c")) {
                        return;
                    }
                    ++x;
                }
                if (path.getFileExtension().equals("devhelp")) {
                    NodeList nl = doc.getElementsByTagName("function");
                    int i = 0;
                    while (i < nl.getLength()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        n = nl.item(i);
                        m = n.getAttributes();
                        Node name = m.getNamedItem("name");
                        Node link = m.getNamedItem("link");
                        if (name != null && link != null) {
                            String nameValue = name.getNodeValue();
                            if (!((nameValue = nameValue.replaceAll("\\(.*\\);+", "").trim()).contains("::") || nameValue.startsWith("enum ") || nameValue.contains("\""))) {
                                String linkValue = link.getNodeValue();
                                String[] linkParts = linkValue.split("#");
                                if (linkParts.length < 2) {
                                    return;
                                }
                                HashMap<String, String> funcMap = (HashMap<String, String>)files.get(linkParts[0]);
                                if (funcMap == null) {
                                    funcMap = new HashMap<String, String>();
                                    files.put(linkParts[0], funcMap);
                                }
                                funcMap.put(linkParts[1], nameValue);
                            }
                        }
                        ++i;
                    }
                } else if (path.getFileExtension().equals("devhelp2")) {
                    NodeList nl = doc.getElementsByTagName("keyword");
                    int i = 0;
                    while (i < nl.getLength()) {
                        String typeName;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        n = nl.item(i);
                        m = n.getAttributes();
                        Node type = m.getNamedItem("type");
                        if (type != null && (typeName = type.getNodeValue()).equals("function")) {
                            Node name = m.getNamedItem("name");
                            Node link = m.getNamedItem("link");
                            if (name != null && link != null) {
                                String nameValue = name.getNodeValue();
                                if (!((nameValue = nameValue.replaceAll("\\(.*\\);+", "").trim()).contains("::") || nameValue.startsWith("enum ") || nameValue.contains("\""))) {
                                    String linkValue = link.getNodeValue();
                                    String[] linkParts = linkValue.split("#");
                                    HashMap<String, String> funcMap = (HashMap<String, String>)files.get(linkParts[0]);
                                    if (funcMap == null) {
                                        funcMap = new HashMap<String, String>();
                                        files.put(linkParts[0], funcMap);
                                    }
                                    if (linkParts.length < 2) {
                                        funcMap.put("name", nameValue);
                                    } else {
                                        funcMap.put(linkParts[1], nameValue);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                for (Map.Entry entry : files.entrySet()) {
                    String fname = (String)entry.getKey();
                    HashMap funcMap = (HashMap)entry.getValue();
                    this.parseLinks(funcMap, fname, (IPath)path, this.libhover);
                }
            }
            catch (FileNotFoundException files) {
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }

        private static final class FilenameComparator
        implements Comparator<IFileStore> {
            private FilenameComparator() {
            }

            @Override
            public int compare(IFileStore arg0, IFileStore arg1) {
                return arg0.getName().compareToIgnoreCase(arg1.getName());
            }
        }

        private static final class NullEntityResolver
        implements EntityResolver {
            private NullEntityResolver() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        }
    }
}

