/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class MultiLineLabel
extends Label {
    private static String ELLIPSIS = "...";

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getBounds());
        }
        Rectangle bounds1 = this.getBounds();
        graphics.translate(bounds1.x, bounds1.y);
        this.drawText(graphics);
        graphics.translate(-bounds1.x, -bounds1.y);
    }

    private void drawText(Graphics graphics) {
        String[] strings = this.splitString(this.getText());
        int y = 0;
        int lineHeight = FigureUtilities.getFontMetrics((Font)this.getFont()).getHeight();
        int i = 0;
        while (i < strings.length) {
            graphics.drawText(this.getSubStringText(strings[i]), 0, y);
            y += lineHeight;
            ++i;
        }
    }

    private String[] splitString(String text) {
        int pos;
        String[] lines = new String[1];
        int start = 0;
        do {
            if ((pos = text.indexOf(10, start)) == -1) {
                lines[lines.length - 1] = text.substring(start);
                continue;
            }
            boolean crlf = pos > 0 && text.charAt(pos - 1) == '\r';
            lines[lines.length - 1] = text.substring(start, pos - (crlf ? 1 : 0));
            start = pos + 1;
            String[] newLines = new String[lines.length + 1];
            System.arraycopy(lines, 0, newLines, 0, lines.length);
            lines = newLines;
        } while (pos != -1);
        return lines;
    }

    private String getSubStringText(String text) {
        String subStringText = text;
        Font currentFont = this.getFont();
        int textWidth = FigureUtilities.getTextWidth((String)text, (Font)currentFont);
        if (textWidth - this.getSize().width <= 0) {
            return subStringText;
        }
        Dimension effectiveSize = new Dimension(this.getSize().width, 0);
        int dotsWidth = FigureUtilities.getTextWidth((String)ELLIPSIS, (Font)currentFont);
        if (effectiveSize.width < dotsWidth) {
            effectiveSize.width = dotsWidth;
        }
        int subStringLength = this.getLargestSubstringConfinedTo(text, currentFont, effectiveSize.width - dotsWidth);
        subStringText = new String(String.valueOf(text.substring(0, subStringLength)) + ELLIPSIS);
        return subStringText;
    }

    int getLargestSubstringConfinedTo(String s, Font f, int availableWidth) {
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)f);
        float avg = metrics.getAverageCharWidth();
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }
}

