/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import java.io.File;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.AbstractActionProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.CDOCheckoutDashboard;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.internal.explorer.checkouts.OfflineCDOCheckout;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.LocalCDORepository;
import org.eclipse.emf.cdo.internal.ui.views.CDOSessionsView;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.server.internal.db.DBBrowserPage;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.Support;
import org.eclipse.emf.cdo.ui.internal.team.history.CDOHistoryAdapterFactory;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.MenuFiller;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.IViewDescriptor;

public class ShowInActionProvider
extends AbstractActionProvider<Object> {
    public static final String TITLE = "Show In";
    public static final String PROPERTIES_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    public static final String HISTORY_VIEW_ID = "org.eclipse.team.ui.GenericHistoryView";
    public static final String ID = "org.eclipse.emf.cdo.explorer.ui.checkouts.ShowInActions";
    private static final boolean PROPERTIES_SUPPORT_AVAILABLE = Support.PROPERTIES.isAvailable();
    private static final boolean HISTORY_SUPPORT_AVAILABLE = Support.HISTORY.isAvailable();
    private static final String DASHBOARD_KEY = CDOCheckoutDashboard.class.getName();

    public ShowInActionProvider() {
        super(Object.class, ID, TITLE, "group.open");
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        int dashBoardHeight = (Integer)OM.PREF_DASHBOARD_HEIGHT.getValue();
    }

    @Override
    protected boolean fillSubMenu(ICommonViewerWorkbenchSite viewSite, IMenuManager subMenu, Object selectedElement) {
        IWorkbenchPage page = viewSite.getPage();
        StructuredViewer viewer = this.getViewer();
        return ShowInActionProvider.fillMenu(page, viewer, subMenu, selectedElement);
    }

    public static boolean fillMenu(IWorkbenchPage page, StructuredViewer viewer, IMenuManager menu, Object selectedElement) {
        EObject eObject;
        CDOCheckout checkout;
        boolean filled = false;
        if (selectedElement instanceof CDORepository) {
            CDOCheckout[] checkouts;
            CDORepository repository = (CDORepository)selectedElement;
            if (repository.isConnected()) {
                if (repository.isLocal()) {
                    LocalCDORepository localRepository = (LocalCDORepository)repository;
                    IManagedContainer container = localRepository.getContainer();
                    menu.add((IAction)new ShowInServerBrowserAction((CDOExplorerElement)localRepository, container));
                    filled = true;
                }
                filled |= ShowInActionProvider.addAction(menu, repository, new ShowInSessionsViewAction(page, repository, null));
                if (PROPERTIES_SUPPORT_AVAILABLE) {
                    filled |= ShowInActionProvider.addAction(menu, repository, new ShowInViewAction(page, PROPERTIES_VIEW_ID));
                }
                if (HISTORY_SUPPORT_AVAILABLE) {
                    filled |= ShowInActionProvider.addAction(menu, repository.getSession(), new ShowInHistoryAction(page, repository.getSession()));
                }
            } else {
                filled |= ShowInActionProvider.addAction(menu, repository, new ShowInSessionsViewAction(page, repository, null));
            }
            if ((checkouts = repository.getCheckouts()).length != 0) {
                filled |= ShowInActionProvider.addAction(menu, repository, new ShowInProjectExplorerAction(page, checkouts));
            }
        }
        if (selectedElement instanceof CDOBranch && HISTORY_SUPPORT_AVAILABLE) {
            filled |= ShowInActionProvider.addAction(menu, selectedElement, new ShowInHistoryAction(page, selectedElement));
        }
        if (selectedElement instanceof CDOCheckout && (checkout = (CDOCheckout)selectedElement).isOpen()) {
            if (checkout.isOffline()) {
                OfflineCDOCheckout offlineCheckout = (OfflineCDOCheckout)checkout;
                InternalCDOWorkspace workspace = offlineCheckout.getWorkspace();
                if (workspace != null) {
                    IManagedContainer container = workspace.getContainer();
                    menu.add((IAction)new ShowInServerBrowserAction((CDOExplorerElement)offlineCheckout, container));
                    filled = true;
                }
            } else {
                filled |= ShowInActionProvider.addAction(menu, checkout, new ShowInSessionsViewAction(page, checkout.getRepository(), checkout));
            }
            if (checkout.isReadOnly()) {
                filled |= ShowInActionProvider.addAction(menu, checkout, new ShowInViewAction(page, "org.eclipse.emf.cdo.ui.CDOTimeMachineView"));
            }
            if (PROPERTIES_SUPPORT_AVAILABLE) {
                filled |= ShowInActionProvider.addAction(menu, checkout, new ShowInViewAction(page, PROPERTIES_VIEW_ID));
            }
            if (HISTORY_SUPPORT_AVAILABLE) {
                filled |= ShowInActionProvider.addAction(menu, checkout.getView(), new ShowInHistoryAction(page, checkout.getView()));
            }
        }
        if (selectedElement instanceof EObject && CDOExplorerUtil.getCheckout((Object)(eObject = (EObject)selectedElement)) != null) {
            if (PROPERTIES_SUPPORT_AVAILABLE) {
                filled |= ShowInActionProvider.addAction(menu, eObject, new ShowInViewAction(page, PROPERTIES_VIEW_ID));
            }
            if (HISTORY_SUPPORT_AVAILABLE) {
                filled |= ShowInActionProvider.addAction(menu, eObject, new ShowInHistoryAction(page, eObject));
            }
        }
        if (selectedElement instanceof AbstractElement) {
            AbstractElement element = (AbstractElement)selectedElement;
            menu.add((IAction)new ShowInSystemExplorerAction(element.getFolder()));
            filled = true;
        }
        menu.add((IContributionItem)new Separator("additions"));
        boolean[] finalFilled = new boolean[]{filled};
        IPluginContainer.INSTANCE.forEachElement("org.eclipse.net4j.util.ui.menuFillers", MenuFiller.class, filler -> {
            boolean bl = finalFilled[0] | filler.fillMenu(page, viewer, menu, selectedElement);
        });
        return finalFilled[0];
    }

    private static boolean addAction(IMenuManager subMenu, Object selectedElement, ShowInViewAction action) {
        action.selectionChanged(selectedElement);
        if (action.isEnabled()) {
            subMenu.add((IAction)action);
            return true;
        }
        return false;
    }

    public static void showDashboard(final StructuredViewer viewer, ISelectionService selectionService) {
        final CDOCheckoutDashboard[] dashboard = new CDOCheckoutDashboard[]{(CDOCheckoutDashboard)((Object)viewer.getData(DASHBOARD_KEY))};
        if (dashboard[0] == null) {
            final Control control = viewer.getControl();
            final Object controlLayoutData = control.getLayoutData();
            final Composite parent = control.getParent();
            final Layout parentLayout = parent.getLayout();
            final int[] minimumHeight = new int[1];
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            parent.setLayout((Layout)layout);
            control.setLayoutData((Object)new GridData(4, 4, true, true));
            final Sash sash = new Sash(parent, 65792);
            sash.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            sash.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    int dashBoardHeight = parent.getBounds().height - e.y;
                    if (dashBoardHeight < minimumHeight[0]) {
                        e.doit = false;
                    }
                    dashBoardHeight = Math.max(dashBoardHeight, minimumHeight[0]);
                    OM.PREF_DASHBOARD_HEIGHT.setValue((Object)dashBoardHeight);
                    GridData gridData = (GridData)dashboard[0].getLayoutData();
                    gridData.heightHint = dashBoardHeight;
                    parent.layout();
                }
            });
            GridData gridData = new GridData(4, 128, true, false);
            dashboard[0] = new CDOCheckoutDashboard(parent, selectionService);
            dashboard[0].setLayoutData(gridData);
            dashboard[0].addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    viewer.setData(DASHBOARD_KEY, null);
                    if (!control.isDisposed()) {
                        sash.dispose();
                        control.setLayoutData(controlLayoutData);
                        parent.setLayout(parentLayout);
                        parent.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                parent.layout();
                            }
                        });
                    }
                }
            });
            viewer.setData(DASHBOARD_KEY, (Object)dashboard[0]);
            parent.layout();
            minimumHeight[0] = dashboard[0].getBounds().height;
            int dashBoardHeight = (Integer)OM.PREF_DASHBOARD_HEIGHT.getValue();
            if (dashBoardHeight != 0) {
                gridData.heightHint = Math.abs(dashBoardHeight);
                parent.layout();
                OM.PREF_DASHBOARD_HEIGHT.setValue((Object)gridData.heightHint);
            } else {
                OM.PREF_DASHBOARD_HEIGHT.setValue((Object)minimumHeight[0]);
            }
        }
    }

    private static final class ShowInDashboardAction
    extends Action {
        private final StructuredViewer viewer;
        private final ISelectionService selectionService;

        public ShowInDashboardAction(StructuredViewer viewer, ISelectionService selectionService) {
            this.viewer = viewer;
            this.selectionService = selectionService;
            this.setText("CDO Dashboard");
            this.setImageDescriptor(SharedIcons.getDescriptor((String)"obj16/cdo_editor.gif"));
            this.setToolTipText("Show this element in the CDO dashboard");
        }

        public void run() {
            ShowInActionProvider.showDashboard(this.viewer, this.selectionService);
        }
    }

    private static final class ShowInHistoryAction
    extends ShowInViewAction {
        private final Object selectedElement;

        public ShowInHistoryAction(IWorkbenchPage page, Object selectedElement) {
            super(page, ShowInActionProvider.HISTORY_VIEW_ID);
            this.selectedElement = selectedElement;
        }

        @Override
        protected void run(IViewPart viewPart) throws Exception {
            if (this.selectedElement != null && HISTORY_SUPPORT_AVAILABLE) {
                CDOHistoryAdapterFactory.load();
                ((IHistoryView)viewPart).showHistoryFor(this.selectedElement);
            }
        }
    }

    public static final class ShowInProjectExplorerAction
    extends ShowInViewAction {
        private final CDOCheckout[] checkouts;

        public ShowInProjectExplorerAction(IWorkbenchPage page, CDOCheckout[] checkouts) {
            super(page, "org.eclipse.ui.navigator.ProjectExplorer");
            this.checkouts = checkouts;
        }

        @Override
        protected void run(IViewPart viewPart) throws Exception {
            CDOCheckoutContentProvider checkoutContentProvider = CDOCheckoutContentProvider.getInstance("org.eclipse.ui.navigator.ProjectExplorer");
            if (checkoutContentProvider != null) {
                checkoutContentProvider.selectObjects(this.checkouts);
            }
        }
    }

    private static final class ShowInServerBrowserAction
    extends Action {
        private static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.server.browsers";
        private static final String TYPE = "default";
        private final CDOExplorerElement element;
        private final IManagedContainer container;

        public ShowInServerBrowserAction(CDOExplorerElement element, IManagedContainer container) {
            this.element = element;
            this.container = container;
            this.setText("CDO Server Browser");
            this.setImageDescriptor(OM.getImageDescriptor("icons/web.gif"));
            this.setToolTipText("Show this element in a CDO server browser");
        }

        public void run() {
            CDOServerBrowser browser;
            this.container.registerFactory((IFactory)new CDOServerBrowser.ContainerBased.Factory((IContainer)this.container));
            this.container.registerFactory((IFactory)new DBBrowserPage.Tables.Factory());
            this.container.registerFactory((IFactory)new DBBrowserPage.Queries.Factory());
            String description = String.valueOf(this.element.getType()) + "-checkout-" + this.element.getID();
            int serverBrowserPort = ((AbstractElement)this.element).getServerBrowserPort();
            if (serverBrowserPort != 0) {
                description = String.valueOf(Integer.toString(serverBrowserPort)) + ":" + description;
            }
            if ((browser = (CDOServerBrowser)this.container.getElement(PRODUCT_GROUP, TYPE, description)) != null && browser.isActive()) {
                int port = browser.getPort();
                if (serverBrowserPort == 0) {
                    ((AbstractElement)this.element).setServerBrowserPort(port);
                }
                IOUtil.openSystemBrowser((String)("http://localhost:" + port));
            }
        }
    }

    public static final class ShowInSessionsViewAction
    extends ShowInViewAction {
        private final CDORepository repository;
        private final CDOCheckout checkout;

        public ShowInSessionsViewAction(IWorkbenchPage page, CDORepository repository, CDOCheckout checkout) {
            super(page, "org.eclipse.emf.cdo.ui.CDOSessionsView");
            this.repository = repository;
            this.checkout = checkout;
        }

        @Override
        protected void run(IViewPart viewPart) throws Exception {
            final Object select = this.show();
            if (select != null) {
                final TreeViewer viewer = ((CDOSessionsView)viewPart).getViewer();
                viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            viewer.setSelection((ISelection)new StructuredSelection(select), true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        private Object show() {
            CDOSession session = this.getSession();
            if (session != null) {
                CDOPackageRegistryPopulator.populate((CDOPackageRegistry)session.getPackageRegistry());
                if (this.checkout != null) {
                    CDOView view;
                    CDOView checkoutView = this.checkout.getView();
                    if (!this.checkout.isReadOnly()) {
                        CDOTransaction transaction;
                        CDOBranch branch = checkoutView.getBranch();
                        CDOTransaction[] cDOTransactionArray = session.getTransactions();
                        int n = cDOTransactionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            transaction = cDOTransactionArray[n2];
                            if (branch.getID() == transaction.getBranch().getID()) {
                                return transaction;
                            }
                            ++n2;
                        }
                        transaction = session.openTransaction(branch);
                        CDOUtil.configureView((CDOView)transaction);
                        return transaction;
                    }
                    CDOBranchPoint branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)checkoutView);
                    CDOView[] cDOViewArray = session.getViews();
                    int n = cDOViewArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        view = cDOViewArray[n3];
                        if (!(view instanceof CDOTransaction) && branchPoint.equals(view)) {
                            return view;
                        }
                        ++n3;
                    }
                    view = session.openView((CDOBranchPoint)checkoutView);
                    CDOUtil.configureView((CDOView)view);
                    return view;
                }
            }
            return session;
        }

        private CDOSession getSession() {
            this.repository.connect();
            String factoryType = "cdo-explorer";
            String description = this.repository.getID();
            try {
                return (CDOSession)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.sessions", factoryType, description);
            }
            catch (FactoryNotFoundException | ProductCreationException ex) {
                final CDOSession session = ((CDORepositoryImpl)this.repository).openSession();
                ContainerEventAdapter<Object> listener = new ContainerEventAdapter<Object>(){

                    protected void onRemoved(IContainer<Object> container, Object element) {
                        if (element == repository) {
                            this.dispose(session);
                        }
                    }

                    protected void notifyOtherEvent(IEvent event) {
                        LifecycleEvent e;
                        if (event instanceof CDORepositoryManager.RepositoryConnectionEvent) {
                            CDORepositoryManager.RepositoryConnectionEvent e2 = (CDORepositoryManager.RepositoryConnectionEvent)event;
                            if (e2.getRepository() == repository) {
                                this.dispose(session);
                            }
                        } else if (event instanceof LifecycleEvent && (e = (LifecycleEvent)event).getSource() == session && e.getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                            this.dispose(session);
                        }
                    }

                    private void dispose(CDOSession session2) {
                        session2.removeListener((IListener)this);
                        CDOExplorerUtil.getRepositoryManager().removeListener((IListener)this);
                        LifecycleUtil.deactivate((Object)session2);
                    }
                };
                session.addListener((IListener)listener);
                CDOExplorerUtil.getRepositoryManager().addListener((IListener)listener);
                IPluginContainer.INSTANCE.putElement("org.eclipse.emf.cdo.sessions", factoryType, description, (Object)session);
                return session;
            }
        }
    }

    public static final class ShowInSystemExplorerAction
    extends Action {
        private final File folder;

        public ShowInSystemExplorerAction(File folder) {
            this.folder = folder;
            this.setText("System Explorer");
            this.setImageDescriptor(OM.getImageDescriptor("icons/system_explorer.gif"));
            this.setToolTipText("Show the folder of this element in the system explorer");
        }

        public void run() {
            IOUtil.openSystemBrowser((String)this.folder.toURI().toString());
        }
    }

    public static class ShowInViewAction
    extends Action {
        private final IWorkbenchPage page;
        private final IViewDescriptor viewDescriptor;
        private Object element;

        public ShowInViewAction(IWorkbenchPage page, String viewID) {
            this.page = page;
            this.viewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(viewID);
            if (this.viewDescriptor != null) {
                this.setText(this.viewDescriptor.getLabel());
                this.setImageDescriptor(this.viewDescriptor.getImageDescriptor());
                this.setToolTipText("Show this element in " + this.viewDescriptor.getLabel());
            }
        }

        public void selectionChanged(Object selectedElement) {
            this.element = selectedElement;
            this.setEnabled(this.viewDescriptor != null && this.element != null);
        }

        public final void run() {
            try {
                IViewPart viewPart = this.page.showView(this.viewDescriptor.getId());
                this.run(viewPart);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }

        protected void run(IViewPart viewPart) throws Exception {
        }
    }
}

