/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.IConstraintCreationConstants;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;

public class ConstraintCreationUtils
implements IConstraintCreationConstants {
    public static String getDataTypeFullFormatString(Column column) {
        if (column == null) {
            return "";
        }
        return IDataToolsUIServiceManager.INSTANCE.getColumnHelperService().getDataType(column);
    }

    public static Column getColumnByName(Table table, String columnName) {
        if (table == null) {
            return null;
        }
        EList allColumns = table.getColumns();
        int i = 0;
        while (i < allColumns.size()) {
            Column column = (Column)allColumns.get(i);
            if (column.getName().equals(columnName)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public static Column getColumnByName(UniqueConstraint constraint, String columnName) {
        if (constraint == null) {
            return null;
        }
        EList allMembers = constraint.getMembers();
        int i = 0;
        while (i < allMembers.size()) {
            Column column = (Column)allMembers.get(i);
            if (column.getName().equals(columnName)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public static boolean canTwoColumnsMap(Column firstCol, Column secondCol) {
        if (firstCol == null || secondCol == null) {
            return false;
        }
        Table firstTable = firstCol.getTable();
        Table secondTable = secondCol.getTable();
        if (firstTable == null || secondTable == null) {
            return false;
        }
        DataType firstDataType = firstCol.getDataType();
        DataType secondDataType = secondCol.getDataType();
        if (ConstraintCreationUtils.getOriginalDataTypeFullFormatString(firstDataType, firstTable).equals(ConstraintCreationUtils.getOriginalDataTypeFullFormatString(secondDataType, secondTable))) {
            return true;
        }
        if (ConstraintCreationUtils.getOriginalDataType(firstDataType) instanceof CharacterStringDataType && ConstraintCreationUtils.getOriginalDataType(secondDataType) instanceof CharacterStringDataType) {
            int defaultLength;
            int secondLength;
            int defaultLength2;
            DataType firstOriginal = ConstraintCreationUtils.getOriginalDataType(firstDataType);
            DataType secondOriginal = ConstraintCreationUtils.getOriginalDataType(secondDataType);
            if (firstOriginal.getName().equalsIgnoreCase("LONG VARCHAR") && !secondOriginal.getName().equalsIgnoreCase("LONG VARCHAR") || !firstOriginal.getName().equalsIgnoreCase("LONG VARCHAR") && secondOriginal.getName().equalsIgnoreCase("LONG VARCHAR")) {
                return false;
            }
            int firstLength = ((CharacterStringDataType)firstOriginal).getLength();
            if (firstLength == 1 && !ConstraintCreationUtils.isLengthSupported(firstTable, firstOriginal) && (defaultLength2 = ConstraintCreationUtils.getDefaultLength(firstTable, firstOriginal)) > 1) {
                firstLength = defaultLength2;
            }
            if ((secondLength = ((CharacterStringDataType)secondOriginal).getLength()) == 1 && !ConstraintCreationUtils.isLengthSupported(secondTable, secondOriginal) && (defaultLength = ConstraintCreationUtils.getDefaultLength(secondTable, secondOriginal)) > 1) {
                secondLength = defaultLength;
            }
            if (firstLength == secondLength) {
                return true;
            }
        }
        return false;
    }

    private static boolean isLengthSupported(Table table, DataType dataType) {
        DatabaseDefinition def = ConstraintCreationUtils.getDatabaseDefinition(table);
        return def.getPredefinedDataTypeDefinition(dataType.getName()).isLengthSupported();
    }

    public static DatabaseDefinition getDatabaseDefinition(Table table) {
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        return dbRegistry.getDefinition(ModelUtil.getDatabase((Schema)table.getSchema()));
    }

    private static int getDefaultLength(Table table, DataType dataType) {
        DatabaseDefinition def = ConstraintCreationUtils.getDatabaseDefinition(table);
        int defaultLength = def.getPredefinedDataTypeDefinition(dataType.getName()).getDefaultLength();
        return defaultLength;
    }

    private static String getOriginalDataTypeFullFormatString(DataType datatype, Table table) {
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = dbRegistry.getDefinition(ModelUtil.getDatabase((Schema)table.getSchema()));
        if (datatype != null) {
            if (datatype instanceof PredefinedDataType) {
                return definition.getPredefinedDataTypeFormattedName((PredefinedDataType)datatype);
            }
            if (datatype instanceof DistinctUserDefinedType) {
                return definition.getPredefinedDataTypeFormattedName(((DistinctUserDefinedType)datatype).getPredefinedRepresentation());
            }
            return datatype.getName();
        }
        return "";
    }

    private static DataType getOriginalDataType(DataType datatype) {
        if (datatype instanceof DistinctUserDefinedType) {
            return ((DistinctUserDefinedType)datatype).getPredefinedRepresentation();
        }
        return datatype;
    }

    public static boolean isNothing(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static ValidatorMessage getValidatorMessage(DatabaseIdentifier databaseIdentifier, Table table, String objectName) {
        if (objectName.equals(Messages.ConstraintNameTextDefault)) {
            return null;
        }
        String dbType = ProfileUtil.getDatabaseVendorDefinitionId((String)databaseIdentifier.getProfileName()).toString();
        SQLService service = SQLToolsFacade.getSQLService((DatabaseIdentifier)databaseIdentifier, (String)dbType);
        if (service != null) {
            IIdentifierValidator validator = service.getIdentifierValidator();
            ValidatorMessage errorMsg = validator.isValid(SQLUtil.quoteWhenNecessary(objectName, databaseIdentifier), -1, databaseIdentifier);
            return errorMsg;
        }
        return null;
    }
}

