/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IAutomaticVariable;
import org.eclipse.cdt.make.core.makefile.IBuiltinFunction;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefileReaderProvider;
import org.eclipse.cdt.make.core.makefile.gnu.IGNUMakefile;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.BadDirective;
import org.eclipse.cdt.make.internal.core.makefile.Command;
import org.eclipse.cdt.make.internal.core.makefile.Comment;
import org.eclipse.cdt.make.internal.core.makefile.DefaultRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.EmptyLine;
import org.eclipse.cdt.make.internal.core.makefile.IgnoreRule;
import org.eclipse.cdt.make.internal.core.makefile.InferenceRule;
import org.eclipse.cdt.make.internal.core.makefile.MakefileMessages;
import org.eclipse.cdt.make.internal.core.makefile.MakefileReader;
import org.eclipse.cdt.make.internal.core.makefile.PosixRule;
import org.eclipse.cdt.make.internal.core.makefile.PreciousRule;
import org.eclipse.cdt.make.internal.core.makefile.Rule;
import org.eclipse.cdt.make.internal.core.makefile.SccsGetRule;
import org.eclipse.cdt.make.internal.core.makefile.SilentRule;
import org.eclipse.cdt.make.internal.core.makefile.SpecialRule;
import org.eclipse.cdt.make.internal.core.makefile.SuffixesRule;
import org.eclipse.cdt.make.internal.core.makefile.Target;
import org.eclipse.cdt.make.internal.core.makefile.Util;
import org.eclipse.cdt.make.internal.core.makefile.gnu.AutomaticVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.BuiltinFunction;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Conditional;
import org.eclipse.cdt.make.internal.core.makefile.gnu.DefineVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.DeleteOnErrorRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Else;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Endef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Endif;
import org.eclipse.cdt.make.internal.core.makefile.gnu.ExportAllVariablesRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.ExportVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefileUtil;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUTargetRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifdef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifeq;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifndef;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Ifneq;
import org.eclipse.cdt.make.internal.core.makefile.gnu.Include;
import org.eclipse.cdt.make.internal.core.makefile.gnu.IntermediateRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.LowResolutionTimeRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.NotParallelRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.OverrideDefine;
import org.eclipse.cdt.make.internal.core.makefile.gnu.OverrideVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.PhonyRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.SecondaryRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.StaticTargetRule;
import org.eclipse.cdt.make.internal.core.makefile.gnu.TargetVariable;
import org.eclipse.cdt.make.internal.core.makefile.gnu.UnExport;
import org.eclipse.cdt.make.internal.core.makefile.gnu.VPath;
import org.eclipse.cdt.make.internal.core.makefile.gnu.VariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefileUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;

public class GNUMakefile
extends AbstractMakefile
implements IGNUMakefile {
    public static String PATH_SEPARATOR = System.getProperty("path.separator", ":");
    public static String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    private String[] includeDirectories = new String[0];
    private IDirective[] builtins = new IDirective[0];
    private IAutomaticVariable[] autoVariables = new IAutomaticVariable[]{new AutomaticVariable((Directive)this, "@", MakefileMessages.getString("GNUMakefile.automaticVariable.at")), new AutomaticVariable((Directive)this, "%", MakefileMessages.getString("GNUMakefile.automaticVariable.percent")), new AutomaticVariable((Directive)this, "<", MakefileMessages.getString("GNUMakefile.automaticVariable.less")), new AutomaticVariable((Directive)this, "?", MakefileMessages.getString("GNUMakefile.automaticVariable.question")), new AutomaticVariable((Directive)this, "^", MakefileMessages.getString("GNUMakefile.automaticVariable.carrot")), new AutomaticVariable((Directive)this, "+", MakefileMessages.getString("GNUMakefile.automaticVariable.plus")), new AutomaticVariable((Directive)this, "|", MakefileMessages.getString("GNUMakefile.automaticVariable.pipe")), new AutomaticVariable((Directive)this, "*", MakefileMessages.getString("GNUMakefile.automaticVariable.star"))};
    private static final String[] functions = new String[]{"subst", "patsubst", "strip", "findstring", "filter", "filter-out", "sort", "word", "words", "wordlist", "firstword", "lastword", "dir", "notdir", "suffix", "basename", "addsuffix", "addprefix", "join", "wildcard", "realpath", "abspath", "if", "or", "and", "foreach", "call", "value", "eval", "origin", "flavor", "shell", "error", "warning", "info"};
    private IBuiltinFunction[] builtinFunctions = new IBuiltinFunction[]{new BuiltinFunction(this, "$(subst from,to,text)"), new BuiltinFunction(this, "$(patsubst pattern,replacement,text)"), new BuiltinFunction(this, "$(strip string)"), new BuiltinFunction(this, "$(findstring find,in)"), new BuiltinFunction(this, "$(filter pattern,text)"), new BuiltinFunction(this, "$(filter-out pattern,text)"), new BuiltinFunction(this, "$(sort list)"), new BuiltinFunction(this, "$(word n,text)"), new BuiltinFunction(this, "$(words text)"), new BuiltinFunction(this, "$(wordlist s,e,text)"), new BuiltinFunction(this, "$(firstword names)"), new BuiltinFunction(this, "$(lastword names)"), new BuiltinFunction(this, "$(dir names)"), new BuiltinFunction(this, "$(notdir names)"), new BuiltinFunction(this, "$(suffix names)"), new BuiltinFunction(this, "$(basename names)"), new BuiltinFunction(this, "$(addsuffix suffix,names)"), new BuiltinFunction(this, "$(addprefix prefix,names)"), new BuiltinFunction(this, "$(join list1,list2)"), new BuiltinFunction(this, "$(wildcard pattern)"), new BuiltinFunction(this, "$(realpath names)"), new BuiltinFunction(this, "$(abspath names)"), new BuiltinFunction(this, "$(if condition,then-part,else-part)"), new BuiltinFunction(this, "$(or condition1,condition2,...)"), new BuiltinFunction(this, "$(and condition1,condition2,...)"), new BuiltinFunction(this, "$(foreach var,list,text)"), new BuiltinFunction(this, "$(call variable,param,...)"), new BuiltinFunction(this, "$(value variable)"), new BuiltinFunction(this, "$(eval expression)"), new BuiltinFunction(this, "$(origin variable)"), new BuiltinFunction(this, "$(flavor variable)"), new BuiltinFunction(this, "$(shell command)"), new BuiltinFunction(this, "$(error error: text)"), new BuiltinFunction(this, "$(warning warning: text)"), new BuiltinFunction(this, "$(info info: text)")};
    private IMakefileReaderProvider makefileReaderProvider;

    public GNUMakefile() {
        super(null);
    }

    @Override
    public IMakefileReaderProvider getMakefileReaderProvider() {
        return this.makefileReaderProvider;
    }

    @Override
    public void parse(String filePath, Reader reader) throws IOException {
        this.parse(URIUtil.toURI((String)filePath), new MakefileReader(reader));
    }

    @Override
    public void parse(URI fileURI, IMakefileReaderProvider makefileReaderProvider) throws IOException {
        MakefileReader reader;
        this.makefileReaderProvider = makefileReaderProvider;
        if (makefileReaderProvider == null) {
            try {
                IFileStore store = EFS.getStore((URI)fileURI);
                IFileInfo info = store.fetchInfo();
                if (!info.exists() || info.isDirectory()) {
                    throw new IOException();
                }
                reader = new MakefileReader(new InputStreamReader(store.openInputStream(0, null)));
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                throw new IOException(e.getMessage());
            }
        } else {
            reader = new MakefileReader(makefileReaderProvider.getReader(fileURI));
        }
        this.parse(fileURI, reader);
    }

    @Override
    public void parse(URI filePath, Reader reader) throws IOException {
        this.parse(filePath, new MakefileReader(reader));
    }

    /*
     * Unable to fully structure code
     */
    protected void parse(URI fileURI, MakefileReader reader) throws IOException {
        rules = null;
        conditions = new Stack<Directive>();
        defines = new Stack<VariableDefinition>();
        startLine = 0;
        endLine = 0;
        this.clearDirectives();
        this.setFileURI(fileURI);
lbl8:
        // 3 sources

        try {
            while ((line = reader.readLine()) != null) {
                block32: {
                    block33: {
                        block31: {
                            startLine = endLine + 1;
                            endLine = reader.getLineNumber();
                            if (GNUMakefileUtil.isEndef(line)) {
                                if (!defines.empty()) {
                                    def = (VariableDefinition)defines.pop();
                                    def.setEndLine(endLine);
                                }
                                endef = new Endef(this);
                                endef.setLines(startLine, endLine);
                                this.addDirective(conditions, endef);
                                continue;
                            }
                            if (GNUMakefileUtil.isDefine(line)) {
                                def = this.parseVariableDefinition(line);
                                def.setLines(startLine, endLine);
                                this.addDirective(conditions, def);
                                defines.push(def);
                                continue;
                            }
                            if (GNUMakefileUtil.isOverrideDefine(line)) {
                                oDef = this.parseVariableDefinition(line);
                                oDef.setLines(startLine, endLine);
                                this.addDirective(conditions, oDef);
                                defines.push(oDef);
                                continue;
                            }
                            if (!defines.empty()) {
                                def = (VariableDefinition)defines.peek();
                                sb = def.getValue();
                                if (sb.length() > 0) {
                                    sb.append('\n');
                                }
                                sb.append(line);
                                continue;
                            }
                            if (!PosixMakefileUtil.isCommand(line)) break block31;
                            cmd = new Command(this, line);
                            cmd.setLines(startLine, endLine);
                            if (!conditions.empty()) {
                                this.addDirective(conditions, cmd);
                                continue;
                            }
                            if (rules == null) break block31;
                            var13_30 = rules;
                            var12_22 = rules.length;
                            var11_16 = 0;
                            while (var11_16 < var12_22) {
                                rule = var13_30[var11_16];
                                rule.addDirective(cmd);
                                rule.setEndLine(endLine);
                                ++var11_16;
                            }
                            ** GOTO lbl8
                        }
                        if ((pound = Util.indexOfComment(line)) != -1) {
                            cmt = new Comment(this, line.substring(pound + 1));
                            cmt.setLines(startLine, endLine);
                            if (rules != null) {
                                var14_35 = rules;
                                var13_31 = rules.length;
                                var12_23 = 0;
                                while (var12_23 < var13_31) {
                                    rule = var14_35[var12_23];
                                    rule.addDirective(cmt);
                                    rule.setEndLine(endLine);
                                    ++var12_23;
                                }
                            } else {
                                this.addDirective(conditions, cmt);
                            }
                            line = line.substring(0, pound);
                            if (Util.isEmptyLine(line)) continue;
                        }
                        if (!Util.isEmptyLine(line)) break block32;
                        empty = new EmptyLine(this);
                        empty.setLines(startLine, endLine);
                        if (rules == null) break block33;
                        var14_35 = rules;
                        var13_32 = rules.length;
                        var12_24 = 0;
                        while (var12_24 < var13_32) {
                            rule = var14_35[var12_24];
                            rule.addDirective(empty);
                            rule.setEndLine(endLine);
                            ++var12_24;
                        }
                        ** GOTO lbl8
                    }
                    this.addDirective(conditions, empty);
                    continue;
                }
                rules = null;
                if (GNUMakefileUtil.isElse(line)) {
                    elseDirective = this.parseConditional(line);
                    elseDirective.setLines(startLine, endLine);
                    if (!conditions.empty()) {
                        cond = (Conditional)conditions.pop();
                        cond.setEndLine(endLine - 1);
                    }
                    this.addDirective(conditions, elseDirective);
                    conditions.push(elseDirective);
                    continue;
                }
                if (GNUMakefileUtil.isEndif(line)) {
                    endif = new Endif(this);
                    endif.setLines(startLine, endLine);
                    if (!conditions.empty()) {
                        cond = (Conditional)conditions.pop();
                        cond.setEndLine(endLine);
                    }
                    this.addDirective(conditions, endif);
                    continue;
                }
                directive = this.processConditions(line);
                if (directive != null) {
                    directive.setLines(startLine, endLine);
                    this.addDirective(conditions, directive);
                    conditions.push(directive);
                    continue;
                }
                directive = this.processGNUDirectives(line);
                if (directive != null) {
                    directive.setLines(startLine, endLine);
                    this.addDirective(conditions, directive);
                    continue;
                }
                special = this.processSpecialRules(line);
                if (special != null) {
                    rules = new Rule[]{special};
                    special.setLines(startLine, endLine);
                    this.addDirective(conditions, special);
                    continue;
                }
                if (PosixMakefileUtil.isInferenceRule(line)) {
                    irule = this.parseInferenceRule(line);
                    irule.setLines(startLine, endLine);
                    this.addDirective(conditions, irule);
                    rules = new Rule[]{irule};
                    continue;
                }
                if (GNUMakefileUtil.isVariableDefinition(line)) {
                    vd = this.parseVariableDefinition(line);
                    vd.setLines(startLine, endLine);
                    this.addDirective(conditions, vd);
                    if (!vd.isTargetSpecific()) continue;
                }
                if (GNUMakefileUtil.isStaticTargetRule(line)) {
                    srules = this.parseStaticTargetRule(line);
                    var16_39 = srules;
                    var15_38 = srules.length;
                    var14_36 = 0;
                    while (var14_36 < var15_38) {
                        srule = var16_39[var14_36];
                        srule.setLines(startLine, endLine);
                        this.addDirective(conditions, srule);
                        ++var14_36;
                    }
                    rules = srules;
                    continue;
                }
                if (GNUMakefileUtil.isGNUTargetRule(line)) {
                    trules = this.parseGNUTargetRules(line);
                    var16_39 = trules;
                    var15_38 = trules.length;
                    var14_37 = 0;
                    while (var14_37 < var15_38) {
                        trule = var16_39[var14_37];
                        trule.setLines(startLine, endLine);
                        this.addDirective(conditions, trule);
                        ++var14_37;
                    }
                    rules = trules;
                    continue;
                }
                stmt = new BadDirective(this, line);
                stmt.setLines(startLine, endLine);
                this.addDirective(conditions, stmt);
            }
            this.setLines(1, endLine);
        }
        finally {
            reader.close();
        }
    }

    private void addDirective(Stack<Directive> conditions, Directive directive) {
        if (conditions.empty()) {
            this.addDirective(directive);
        } else {
            Conditional cond = (Conditional)conditions.peek();
            cond.addDirective(directive);
            cond.setEndLine(directive.getEndLine());
        }
    }

    protected Conditional processConditions(String line) {
        Conditional stmt = null;
        if (GNUMakefileUtil.isIfdef(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfndef(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfeq(line)) {
            stmt = this.parseConditional(line);
        } else if (GNUMakefileUtil.isIfneq(line)) {
            stmt = this.parseConditional(line);
        }
        return stmt;
    }

    protected Directive processGNUDirectives(String line) {
        Directive stmt = null;
        if (GNUMakefileUtil.isUnExport(line)) {
            stmt = this.parseUnExport(line);
        } else if (GNUMakefileUtil.isVPath(line)) {
            stmt = this.parseVPath(line);
        } else if (GNUMakefileUtil.isInclude(line)) {
            stmt = this.parseInclude(line);
        }
        return stmt;
    }

    protected SpecialRule processSpecialRules(String line) {
        SpecialRule stmt = null;
        if (PosixMakefileUtil.isIgnoreRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isPosixRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isPreciousRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSilentRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSuffixesRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isDefaultRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (PosixMakefileUtil.isSccsGetRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isPhonyRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isIntermediateRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isSecondaryRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isDeleteOnErrorRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isLowResolutionTimeRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isExportAllVariablesRule(line)) {
            stmt = this.parseSpecialRule(line);
        } else if (GNUMakefileUtil.isNotParallelRule(line)) {
            stmt = this.parseSpecialRule(line);
        }
        return stmt;
    }

    protected SpecialRule parseSpecialRule(String line) {
        line = line.trim();
        String keyword = null;
        String[] reqs = null;
        SpecialRule special = null;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            keyword = line.substring(0, index).trim();
            String req = line.substring(index + 1);
            reqs = PosixMakefileUtil.findPrerequisites(req);
        } else {
            keyword = line;
            reqs = new String[]{};
        }
        if (keyword.equals(".IGNORE")) {
            special = new IgnoreRule((Directive)this, reqs);
        } else if (keyword.equals(".POSIX")) {
            special = new PosixRule(this);
        } else if (keyword.equals(".PRECIOUS")) {
            special = new PreciousRule((Directive)this, reqs);
        } else if (keyword.equals(".SILENT")) {
            special = new SilentRule((Directive)this, reqs);
        } else if (keyword.equals(".SUFFIXES")) {
            special = new SuffixesRule((Directive)this, reqs);
        } else if (keyword.equals(".DEFAULT")) {
            special = new DefaultRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".SCCS_GET")) {
            special = new SccsGetRule((Directive)this, new Command[0]);
        } else if (keyword.equals(".PHONY")) {
            special = new PhonyRule((Directive)this, reqs);
        } else if (keyword.equals(".INTERMEDIATE")) {
            special = new IntermediateRule((Directive)this, reqs);
        } else if (keyword.equals(".SECONDARY")) {
            special = new SecondaryRule((Directive)this, reqs);
        } else if (keyword.equals(".DELETE_ON_ERROR")) {
            special = new DeleteOnErrorRule((Directive)this, reqs);
        } else if (keyword.equals(".LOW_RESOLUTION_TIME")) {
            special = new LowResolutionTimeRule((Directive)this, reqs);
        } else if (keyword.equals(".EXPORT_ALL_VARIABLES")) {
            special = new ExportAllVariablesRule((Directive)this, reqs);
        } else if (keyword.equals(".NOTPARALLEL")) {
            special = new NotParallelRule((Directive)this, reqs);
        }
        return special;
    }

    protected Conditional parseConditional(String line) {
        Conditional condition = null;
        line = line.trim();
        String keyword = null;
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                keyword = line.substring(0, i);
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        if (keyword == null) {
            keyword = line;
        }
        if (keyword.equals("ifdef")) {
            condition = new Ifdef(this, line);
        } else if (keyword.equals("ifndef")) {
            condition = new Ifndef(this, line);
        } else if (keyword.equals("ifeq")) {
            condition = new Ifeq(this, line);
        } else if (keyword.equals("ifneq")) {
            condition = new Ifneq(this, line);
        } else if (keyword.equals("else")) {
            condition = new Else(this);
        }
        return condition;
    }

    protected Include parseInclude(String line) {
        String[] filenames;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        if (count > 0) {
            filenames = new String[count - 1];
            int i = 0;
            while (i < count) {
                if (i == 0) {
                    st.nextToken();
                } else {
                    filenames[i - 1] = this.expandString(st.nextToken(), true);
                }
                ++i;
            }
        } else {
            filenames = new String[]{};
        }
        return new Include(this, filenames, this.getIncludeDirectories());
    }

    protected VPath parseVPath(String line) {
        String pattern = null;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        ArrayList<String> dirs = new ArrayList<String>(count);
        if (count > 0) {
            int i = 0;
            while (i < count) {
                if (count == 0) {
                    st.nextToken();
                } else if (count == 1) {
                    pattern = st.nextToken();
                } else if (count == 3) {
                    String delim = " \t\n\r\f" + PATH_SEPARATOR;
                    dirs.add(st.nextToken(delim));
                } else {
                    dirs.add(st.nextToken());
                }
                ++i;
            }
        }
        String[] directories = dirs.toArray(new String[0]);
        if (pattern == null) {
            pattern = "";
        }
        return new VPath(this, pattern, directories);
    }

    protected UnExport parseUnExport(String line) {
        int i = 0;
        while (i < line.length()) {
            if (Util.isSpace(line.charAt(i))) {
                line = line.substring(i).trim();
                break;
            }
            ++i;
        }
        return new UnExport(this, line);
    }

    protected GNUTargetRule[] parseGNUTargetRules(String line) {
        String[] orderReqs;
        String[] normalReqs;
        String[] targetNames;
        String cmd = null;
        boolean doubleColon = false;
        int index = Util.indexOf(line, ':');
        if (index != -1) {
            int semicolon;
            String target = line.substring(0, index);
            targetNames = PosixMakefileUtil.findTargets(target.trim());
            String req = line.substring(index + 1);
            doubleColon = req.startsWith(":");
            if (doubleColon) {
                req = req.substring(1);
            }
            if ((semicolon = Util.indexOf(req, ';')) != -1) {
                cmd = req.substring(semicolon + 1);
                req = req.substring(0, semicolon);
            }
            String normalReq = null;
            String orderReq = null;
            int pipe = Util.indexOf(req, '|');
            if (pipe != -1) {
                normalReq = req.substring(0, pipe);
                orderReq = req.substring(pipe + 1);
            } else {
                normalReq = req;
                orderReq = "";
            }
            normalReqs = PosixMakefileUtil.findPrerequisites(normalReq.trim());
            orderReqs = PosixMakefileUtil.findPrerequisites(orderReq.trim());
        } else {
            targetNames = PosixMakefileUtil.findTargets(line);
            normalReqs = new String[]{};
            orderReqs = new String[]{};
        }
        GNUTargetRule[] rules = new GNUTargetRule[targetNames.length];
        int i = 0;
        while (i < targetNames.length) {
            rules[i] = new GNUTargetRule(this, new Target(targetNames[i]), doubleColon, normalReqs, orderReqs, new Command[0]);
            if (cmd != null) {
                rules[i].addDirective(new Command(this, cmd));
            }
            ++i;
        }
        return rules;
    }

    protected VariableDefinition parseVariableDefinition(String line) {
        String name;
        int index;
        int i;
        line = line.trim();
        char type = '\u0000';
        boolean isDefine = false;
        boolean isOverride = false;
        boolean isTargetVariable = false;
        boolean isExport = false;
        String targetName = "";
        StringBuffer value = new StringBuffer();
        isTargetVariable = GNUMakefileUtil.isTargetVariable(line);
        if (isTargetVariable) {
            int colon = Util.indexOf(line, ':');
            if (colon != -1) {
                targetName = line.substring(0, colon).trim();
                line = line.substring(colon + 1).trim();
            } else {
                targetName = "";
            }
        }
        if (GNUMakefileUtil.isOverride(line)) {
            isOverride = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if (GNUMakefileUtil.isDefine(line)) {
            isDefine = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if (GNUMakefileUtil.isExport(line)) {
            isExport = true;
            i = 0;
            while (i < line.length()) {
                if (Util.isSpace(line.charAt(i))) {
                    line = line.substring(i).trim();
                    break;
                }
                ++i;
            }
        }
        if ((index = line.indexOf(61)) != -1) {
            int separator = index;
            if (index > 0) {
                type = line.charAt(index - 1);
                if (type == ':' || type == '+' || type == '?') {
                    separator = index - 1;
                } else {
                    type = '\u0000';
                }
            }
            name = line.substring(0, separator).trim();
            value.append(line.substring(index + 1).trim());
        } else {
            name = line;
        }
        VariableDefinition vd = isTargetVariable ? new TargetVariable(this, targetName, name, value, isOverride, type) : (isOverride && isDefine ? new OverrideDefine(this, name, value) : (isDefine ? new DefineVariable(this, name, value) : (isOverride ? new OverrideVariable(this, name, value, type) : (isExport ? new ExportVariable(this, name, value, type) : new VariableDefinition(this, name, value, type)))));
        return vd;
    }

    protected StaticTargetRule[] parseStaticTargetRule(String line) {
        String[] prereqPatterns;
        String targetPattern;
        String[] targets;
        int colon = Util.indexOf(line, ':');
        if (colon > 1) {
            String targetLine = line.substring(0, colon).trim();
            targets = PosixMakefileUtil.findTargets(targetLine);
            if ((colon = Util.indexOf(line = line.substring(colon + 1), ':')) != -1) {
                targetPattern = line.substring(0, colon).trim();
                line = line.substring(colon + 1);
                StringTokenizer st = new StringTokenizer(line);
                int count = st.countTokens();
                prereqPatterns = new String[count];
                int i = 0;
                while (i < count) {
                    prereqPatterns[i] = st.nextToken();
                    ++i;
                }
            } else {
                targetPattern = "";
                prereqPatterns = new String[]{};
            }
        } else {
            targets = new String[]{};
            targetPattern = "";
            prereqPatterns = new String[]{};
        }
        StaticTargetRule[] staticRules = new StaticTargetRule[targets.length];
        int i = 0;
        while (i < targets.length) {
            staticRules[i] = new StaticTargetRule(this, new Target(targets[i]), targetPattern, prereqPatterns, new Command[0]);
            ++i;
        }
        return staticRules;
    }

    protected InferenceRule parseInferenceRule(String line) {
        int index = Util.indexOf(line, ':');
        String tgt = index != -1 ? line.substring(0, index) : line;
        return new InferenceRule(this, new Target(tgt));
    }

    @Override
    public IDirective[] getBuiltins() {
        return this.builtins;
    }

    @Override
    public IAutomaticVariable[] getAutomaticVariables() {
        return this.autoVariables;
    }

    @Override
    public IBuiltinFunction[] getBuiltinFunctions() {
        return this.builtinFunctions;
    }

    @Override
    public void setIncludeDirectories(String[] dirs) {
        this.includeDirectories = dirs;
    }

    @Override
    public String[] getIncludeDirectories() {
        return this.includeDirectories;
    }
}

