/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Locale;

public class DockerHost {
    private static final SystemDelegate defaultSystemDelegate;
    private static SystemDelegate systemDelegate;
    private static final String DEFAULT_UNIX_ENDPOINT = "unix:///var/run/docker.sock";
    private static final String DEFAULT_WINDOWS_ENDPOINT = "npipe:////./pipe/docker_engine";
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 2375;
    private final String host;
    private final URI uri;
    private final URI bindUri;
    private final String address;
    private final int port;
    private final String certPath;

    private DockerHost(String endpoint, String certPath) {
        if (endpoint.startsWith("unix://")) {
            this.port = 0;
            this.address = DEFAULT_ADDRESS;
            this.host = endpoint;
            this.uri = URI.create(endpoint);
            this.bindUri = URI.create(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            String scheme = certPath == null ? "http" : "https";
            URI initialUri = URI.create(scheme + "://" + stripped);
            if (initialUri.getPort() == -1 && initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DEFAULT_ADDRESS + ":" + DockerHost.defaultPort());
            } else if (initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DEFAULT_ADDRESS + ":" + initialUri.getPort());
            } else if (initialUri.getPort() == -1) {
                initialUri = URI.create(scheme + "://" + initialUri.getHost() + ":" + DockerHost.defaultPort());
            }
            this.port = initialUri.getPort();
            this.address = initialUri.getHost();
            this.host = this.address + ":" + this.port;
            this.uri = URI.create(scheme + "://" + this.address + ":" + this.port);
            this.bindUri = URI.create("tcp://" + this.address + ":" + this.port);
        }
        this.certPath = certPath;
    }

    public String host() {
        return this.host;
    }

    public URI uri() {
        return this.uri;
    }

    public URI bindUri() {
        return this.bindUri;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public String dockerCertPath() {
        return this.certPath;
    }

    static void setSystemDelegate(SystemDelegate delegate) {
        systemDelegate = delegate;
    }

    static void restoreSystemDelegate() {
        systemDelegate = defaultSystemDelegate;
    }

    public static DockerHost fromEnv() {
        String host = DockerHost.endpointFromEnv();
        String certPath = DockerHost.certPathFromEnv();
        return new DockerHost(host, certPath);
    }

    public static DockerHost from(String endpoint, String certPath) {
        return new DockerHost(endpoint, certPath);
    }

    static String defaultDockerEndpoint() {
        String osName = systemDelegate.getProperty("os.name");
        String os = osName.toLowerCase(Locale.ENGLISH);
        if (os.equalsIgnoreCase("linux") || os.contains("mac")) {
            return DEFAULT_UNIX_ENDPOINT;
        }
        if (System.getProperty("os.name").equalsIgnoreCase("Windows 10")) {
            return DEFAULT_WINDOWS_ENDPOINT;
        }
        return "localhost:" + DockerHost.defaultPort();
    }

    static String endpointFromEnv() {
        String endPointFromEnv = systemDelegate.getenv("DOCKER_HOST");
        if (endPointFromEnv != null) {
            return endPointFromEnv;
        }
        return DockerHost.defaultDockerEndpoint();
    }

    public static String defaultUnixEndpoint() {
        return DEFAULT_UNIX_ENDPOINT;
    }

    public static String defaultWindowsEndpoint() {
        return DEFAULT_WINDOWS_ENDPOINT;
    }

    public static String defaultAddress() {
        return DEFAULT_ADDRESS;
    }

    public static int defaultPort() {
        return 2375;
    }

    static int portFromEnv() {
        String port = systemDelegate.getenv("DOCKER_PORT");
        if (port == null) {
            return DockerHost.defaultPort();
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return DockerHost.defaultPort();
        }
    }

    static String defaultCertPath() {
        String userHome = systemDelegate.getProperty("user.home");
        return Paths.get(userHome, ".docker").toString();
    }

    static String certPathFromEnv() {
        return systemDelegate.getenv("DOCKER_CERT_PATH");
    }

    static String configPathFromEnv() {
        return systemDelegate.getenv("DOCKER_CONFIG");
    }

    public String toString() {
        return "DockerHost{host=" + this.host + ",uri=" + this.uri + ",bindUri=" + this.bindUri + ",address=" + this.address + ",port=" + this.port + ",certPath=" + this.certPath + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DockerHost that = (DockerHost)obj;
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.bindUri != null ? !this.bindUri.equals(that.bindUri) : that.bindUri != null) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        return this.certPath != null ? this.certPath.equals(that.certPath) : that.certPath == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.bindUri != null ? this.bindUri.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.certPath != null ? this.certPath.hashCode() : 0);
        return result;
    }

    static {
        systemDelegate = defaultSystemDelegate = new SystemDelegate(){

            @Override
            public String getProperty(String key) {
                return System.getProperty(key);
            }

            @Override
            public String getenv(String name) {
                return System.getenv(name);
            }
        };
    }

    static interface SystemDelegate {
        public String getProperty(String var1);

        public String getenv(String var1);
    }
}

