/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IType;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgent;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugTarget;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;

public class TransformationThreadFactory {
    private static TransformationThreadFactory instance;
    private List<TransformationThread> threads = Lists.newArrayList();

    protected TransformationThreadFactory() {
    }

    public static TransformationThreadFactory getInstance() {
        if (instance == null) {
            instance = new TransformationThreadFactory();
        }
        return instance;
    }

    public TransformationThread createTransformationThread(IDebuggerHostAgent agent, TransformationDebugTarget target, IType transformationClass) {
        TransformationThread thread = new TransformationThread(agent, target, transformationClass);
        this.threads.add(thread);
        return thread;
    }

    public TransformationThread getTransformationThread(String id) throws DebugException {
        for (TransformationThread thread : this.threads) {
            if (!thread.getName().equals(id)) continue;
            return thread;
        }
        return null;
    }

    public void deleteTransformationThread(TransformationThread thread) {
        if (this.threads.contains((Object)thread)) {
            this.threads.remove((Object)thread);
        }
    }

    public List<TransformationThread> getTransformationThreads() {
        return this.threads;
    }
}

