/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public class ColorMap {
    private boolean isFrozen;
    private int lastColorId = 0;
    private final List<String> id2color = new ArrayList<String>();
    private final Map<String, @Nullable Integer> color2id = new LinkedHashMap<String, Integer>();

    public ColorMap() {
        this(null);
    }

    public ColorMap(@Nullable List<String> colorMap) {
        if (colorMap != null) {
            this.isFrozen = true;
            int i = 0;
            int len = colorMap.size();
            while (i < len) {
                this.color2id.put(colorMap.get(i), i);
                this.id2color.add(colorMap.get(i));
                ++i;
            }
        } else {
            this.isFrozen = false;
        }
    }

    public int getId(@Nullable String color) {
        if (color == null) {
            return 0;
        }
        Integer value = this.color2id.get(color = color.toUpperCase());
        if (value != null) {
            return value;
        }
        if (this.isFrozen) {
            throw new TMException("Missing color in color map - " + color);
        }
        value = ++this.lastColorId;
        this.color2id.put(NullSafetyHelper.castNonNull(color), value);
        if (value >= this.id2color.size()) {
            this.id2color.add(NullSafetyHelper.castNonNull(color));
        } else {
            this.id2color.set(value, NullSafetyHelper.castNonNull(color));
        }
        return value;
    }

    public @Nullable String getColor(int id) {
        for (Map.Entry<String, Integer> entry : this.color2id.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<String> getColorMap() {
        return this.color2id.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.color2id.hashCode();
        result = 31 * result + this.lastColorId;
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorMap other = (ColorMap)obj;
        return Objects.equals(this.color2id, other.color2id) && this.lastColorId == other.lastColorId;
    }
}

