/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.AbstractDBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpModelConstants;

public class DBGpFloatValue
extends AbstractDBGpValue {
    public DBGpFloatValue(DBGpVariable owner) {
        super(owner);
    }

    @Override
    protected String createValueString(AbstractDBGpValue.DBGpValueData valueData) {
        String valueString = valueData.getValueString();
        if (valueString != null) {
            return valueString.trim();
        }
        return IDBGpModelConstants.INVALID_VAR_CONTENT;
    }

    @Override
    protected boolean supportsValueModification() {
        return true;
    }

    @Override
    protected boolean verifyValue(String expression) {
        try {
            Float.parseFloat(expression);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

