/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.preferences;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.ui.preferences.AbstractFortranPreferencePage;
import org.eclipse.photran.internal.ui.preferences.Messages;

public class CDTFortranPreferencePage
extends AbstractFortranPreferencePage {
    protected void setDescription() {
    }

    protected void initializeDefaults() {
        FortranPreferences.PREFERRED_MODEL_BUILDER.setDefault();
        FortranPreferences.PREFERRED_DOM_PARSER.setDefault();
    }

    protected void createFieldEditors() {
        String[][] domParsers;
        String[][] modelBuilders = this.listModelBuilders();
        if (modelBuilders != null) {
            this.addField((FieldEditor)new ComboFieldEditor(FortranPreferences.PREFERRED_MODEL_BUILDER.getName(), Messages.CDTFortranPreferencePage_PreferredModelBuilderFieldLabel, modelBuilders, this.getFieldEditorParent()));
        }
        if ((domParsers = this.listDOMParsers()) != null) {
            this.addField((FieldEditor)new ComboFieldEditor(FortranPreferences.PREFERRED_DOM_PARSER.getName(), Messages.CDTFortranPreferencePage_PreferredDOMParserFieldLabel, domParsers, this.getFieldEditorParent()));
        }
    }

    private String[][] listModelBuilders() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.photran.cdtinterface.modelbuilder");
        return configs.length == 0 ? null : this.createKeyValuePairs(configs);
    }

    private String[][] listDOMParsers() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.photran.cdtinterface.domparser");
        return configs.length == 0 ? null : this.createKeyValuePairs(configs);
    }

    private String[][] createKeyValuePairs(IConfigurationElement[] configs) {
        String[][] result = new String[configs.length][];
        int i = 0;
        while (i < configs.length) {
            result[i] = new String[]{configs[i].getAttribute("name"), configs[i].getAttribute("id")};
            ++i;
        }
        Arrays.sort(result, new Comparator<String[]>(){

            @Override
            public int compare(String[] kvPair1, String[] kvPair2) {
                return kvPair1[0].compareTo(kvPair2[0]);
            }
        });
        return result;
    }
}

