/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.resources.refactoring.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.ui.resources.refactoring.ui.IScopeChooser;
import org.eclipse.ui.ide.IDE;

public abstract class ScopeChooser
implements IScopeChooser {
    private final String description;
    private final String label;

    public ScopeChooser(String label, String formDescription) {
        this.label = label;
        this.description = formDescription;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static class ScopeChooserVisitor
    implements IResourceVisitor {
        private List<IFile> files = new LinkedList<IFile>();

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (this.isXMI(file)) {
                    this.files.add(file);
                }
                return false;
            }
            return true;
        }

        public boolean isXMI(IFile file) {
            if (file != null) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                IContentType contentType = IDE.getContentType((IFile)file);
                Resource.Factory.Registry instance = Resource.Factory.Registry.INSTANCE;
                Object old = instance.getContentTypeToFactoryMap().get("*");
                Object old2 = instance.getExtensionToFactoryMap().get("*");
                instance.getContentTypeToFactoryMap().put("*", null);
                instance.getExtensionToFactoryMap().put("*", null);
                boolean result = contentType != null && (Resource.Factory.Registry.INSTANCE.getFactory(uri, contentType.getId()) != null || "notation".equals(file.getFileExtension()) || "di".equals(file.getFileExtension()));
                instance.getContentTypeToFactoryMap().put("*", old);
                instance.getExtensionToFactoryMap().put("*", old2);
                return result;
            }
            return false;
        }

        public List<IFile> getFiles() {
            return this.files;
        }
    }
}

