/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.util.Collection;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.pde.DependencyDepth;
import org.eclipse.m2e.pde.MavenTargetDependency;
import org.eclipse.m2e.pde.MavenTargetDependencyFilter;
import org.eclipse.m2e.pde.MavenTargetLocation;

final class DependencyNodeGenerator
implements ICallable<PreorderNodeListGenerator> {
    private final Artifact artifact;
    private final List<ArtifactRepository> repositories;
    private final MavenTargetDependency root;
    private Collection<String> dependencyScopes;
    private MavenTargetLocation parent;
    private DependencyDepth dependencyDepth;

    DependencyNodeGenerator(MavenTargetDependency root, Artifact artifact, DependencyDepth dependencyDepth, Collection<String> dependencyScopes, List<ArtifactRepository> repositories, MavenTargetLocation parent) {
        this.artifact = artifact;
        this.dependencyDepth = dependencyDepth;
        this.repositories = repositories;
        this.root = root;
        this.dependencyScopes = dependencyScopes;
        this.parent = parent;
    }

    public PreorderNodeListGenerator call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency(this.artifact, null));
            collectRequest.setRepositories(RepositoryUtils.toRepos(this.repositories));
            RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
            DependencyNode node = repoSystem.collectDependencies(context.getRepositorySession(), collectRequest).getRoot();
            node.setData((Object)"dependencynode.parent", (Object)this.parent);
            node.setData((Object)"dependencynode.root", (Object)this.root);
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            dependencyRequest.setFilter((DependencyFilter)new MavenTargetDependencyFilter(this.dependencyDepth, this.dependencyScopes));
            repoSystem.resolveDependencies(context.getRepositorySession(), dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            return nlg;
        }
        catch (RepositoryException e) {
            throw new CoreException((IStatus)new Status(4, MavenTargetLocation.class.getPackage().getName(), "Resolving dependencies failed", (Throwable)e));
        }
        catch (RuntimeException e) {
            throw new CoreException((IStatus)new Status(4, MavenTargetLocation.class.getPackage().getName(), "Internal error", (Throwable)e));
        }
    }
}

