/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.ui.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.EEFGen.EEFGenModelReference;
import org.eclipse.emf.eef.EEFGen.GenEditionContext;
import org.eclipse.emf.eef.EEFGen.GenViewsRepository;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.extended.flow.OverrideEMFEditorCode;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.Workflow;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateEEFEditorAction
implements IObjectActionDelegate {
    private static final String GENERATE_EEF_EDITOR = "Generate EEF Editor for ";
    private Shell shell;
    protected Set<IFile> selectedFiles = new LinkedHashSet<IFile>();
    protected List<EEFGenModel> eefGenModels;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selectedFiles != null) {
            try {
                List<EEFGenModel> eefgenmodels = this.initEEFGenModel();
                final Workflow flow = new Workflow("Generate EEF Editors", this.shell);
                for (EEFGenModel eefGenModel : eefgenmodels) {
                    String key = GENERATE_EEF_EDITOR + eefGenModel.eResource().getURI().toString();
                    OverrideEMFEditorCode eefEditorCode = new OverrideEMFEditorCode(key, eefGenModel);
                    flow.addStep(key, (Step)eefEditorCode);
                }
                flow.prepare();
                Job job = new Job("EEF editors generation"){

                    protected IStatus run(IProgressMonitor monitor) {
                        flow.execute(monitor);
                        monitor.done();
                        GenerateEEFEditorAction.this.selectedFiles.clear();
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                job.schedule();
            }
            catch (IOException e) {
                EEFCodegenPlugin.getDefault().logError((Exception)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFiles.clear();
        if (selection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)selection;
            for (Object selectedElement : sSelection.toList()) {
                if (!(selectedElement instanceof IFile)) continue;
                this.selectedFiles.add((IFile)selectedElement);
            }
        }
    }

    protected List<EEFGenModel> initEEFGenModel() throws IOException {
        ArrayList<EEFGenModel> eefgenmodels = new ArrayList<EEFGenModel>(this.selectedFiles.size());
        if (!this.selectedFiles.isEmpty()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            for (IFile selectedFile : this.selectedFiles) {
                EObject object;
                Resource.Factory.Registry registry;
                Object resourceFactory;
                URI modelURI = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
                String fileExtension = modelURI.fileExtension();
                if (fileExtension == null || fileExtension.length() == 0) {
                    fileExtension = "*";
                }
                if ((resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
                } else {
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
                }
                Resource res = resourceSet.createResource(modelURI);
                res.load(Collections.EMPTY_MAP);
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                if (res.getContents().size() <= 0 || !((object = (EObject)res.getContents().get(0)) instanceof EEFGenModel)) continue;
                eefgenmodels.add((EEFGenModel)object);
            }
        }
        return this.validateEEFGenmodels(eefgenmodels);
    }

    private List<EEFGenModel> validateEEFGenmodels(List<EEFGenModel> eefgenmodels) {
        ArrayList<EEFGenModel> eefModels = new ArrayList<EEFGenModel>(eefgenmodels.size());
        eefModels.addAll(eefgenmodels);
        for (EEFGenModel eefGenModel : eefgenmodels) {
            if (!this.validateOneEEFGenModel(eefGenModel)) {
                eefModels.remove(eefGenModel);
            }
            if (this.validateReferencedEEFGenModels(eefGenModel)) continue;
            eefModels.remove(eefGenModel);
        }
        return eefModels;
    }

    private boolean validateReferencedEEFGenModels(EEFGenModel eefGenModel) {
        Iterator iterator = eefGenModel.getReferences().iterator();
        if (iterator.hasNext()) {
            EEFGenModelReference eefGenModelReference = (EEFGenModelReference)iterator.next();
            EEFGenModel referencedEEFGenModel = eefGenModelReference.getReferencedContext();
            if (!this.validateOneEEFGenModel(referencedEEFGenModel)) {
                return false;
            }
            return this.validateReferencedEEFGenModels(referencedEEFGenModel);
        }
        return true;
    }

    private boolean validateOneEEFGenModel(EEFGenModel eefGenModel) {
        Diagnostic diag2;
        Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)eefGenModel);
        if (diag.getSeverity() != 0) {
            Status status = new Status(diag.getSeverity(), "org.eclipse.emf.eef.codegen", "EEFGenmodel '" + eefGenModel.eResource().getURI() + "' contains errors.");
            EEFCodegenPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        for (GenEditionContext genEditionContext : eefGenModel.getEditionContexts()) {
            diag2 = Diagnostician.INSTANCE.validate((EObject)genEditionContext.getPropertiesEditionContext());
            if (diag2.getSeverity() == 0) continue;
            Status status = new Status(diag2.getSeverity(), "org.eclipse.emf.eef.codegen", "PropertiesEditionContext '" + genEditionContext.getPropertiesEditionContext().eResource().getURI() + "' contains errors.");
            EEFCodegenPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        for (GenViewsRepository genViewsRepository : eefGenModel.getViewsRepositories()) {
            diag2 = Diagnostician.INSTANCE.validate((EObject)genViewsRepository.getViewsRepository());
            if (diag2.getSeverity() == 0) continue;
            Status status = new Status(diag2.getSeverity(), "org.eclipse.emf.eef.codegen", "ViewsRepository '" + genViewsRepository.getViewsRepository().eResource().getURI() + "' contains errors.");
            EEFCodegenPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }
}

