/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class DefaultSelectionPolicy
implements IModelSelectionPolicy {
    private IDebugElement fDebugElement;

    public DefaultSelectionPolicy(IDebugElement element) {
        this.fDebugElement = element;
    }

    @Override
    public boolean contains(ISelection selection, IPresentationContext context) {
        IStructuredSelection ss;
        Object element;
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IDebugElement) {
            IDebugElement debugElement = (IDebugElement)element;
            return this.fDebugElement.getDebugTarget().equals(debugElement.getDebugTarget());
        }
        return false;
    }

    @Override
    public boolean overrides(ISelection existing, ISelection candidate, IPresentationContext context) {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && existing instanceof IStructuredSelection && candidate instanceof IStructuredSelection) {
            IStructuredSelection ssExisting = (IStructuredSelection)existing;
            IStructuredSelection ssCandidate = (IStructuredSelection)candidate;
            return this.overrides(ssExisting.getFirstElement(), ssCandidate.getFirstElement());
        }
        return true;
    }

    protected boolean overrides(Object existing, Object candidate) {
        if (existing == null) {
            return true;
        }
        if (existing.equals(candidate)) {
            return true;
        }
        if (existing instanceof IStackFrame && candidate instanceof IStackFrame) {
            IStackFrame curr = (IStackFrame)existing;
            IStackFrame next = (IStackFrame)candidate;
            return curr.getThread().equals(next.getThread()) || !this.isSticky(existing);
        }
        return !this.isSticky(existing);
    }

    @Override
    public boolean isSticky(ISelection selection, IPresentationContext context) {
        if ("org.eclipse.debug.ui.DebugView".equals(context.getId()) && selection instanceof IStructuredSelection) {
            return this.isSticky(((IStructuredSelection)selection).getFirstElement());
        }
        return false;
    }

    protected boolean isSticky(Object element) {
        if (element instanceof IStackFrame) {
            IStackFrame frame = (IStackFrame)element;
            return frame.isSuspended() || frame.isStepping();
        }
        return false;
    }

    @Override
    public ISelection replaceInvalidSelection(ISelection selection, ISelection newSelection) {
        TreePath[] paths;
        if (selection instanceof ITreeSelection && (paths = ((ITreeSelection)selection).getPaths()).length > 0 && paths[0].getSegmentCount() > 1) {
            return new TreeSelection(paths[0].getParentPath());
        }
        return newSelection;
    }
}

