/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import java.util.Collections;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.AddSubFullSelectAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.AddSubSelectAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.AddTableAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.AddValueRowAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.AddValuesAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.ChangeSetOperatorAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.ChangeStatementTypeAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.ConvertToFullSelectAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.CreateJoinAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.CreateWithTableAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.DeleteStatementAction;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SQLTreeViewer
extends ContentOutlinePage {
    AddTableAction addTableAction;
    CreateJoinAction createJoinAction;
    CreateWithTableAction createWithTableAction;
    ConvertToFullSelectAction convertToFullSelectAction;
    AddValuesAction addValuesAction;
    AddValueRowAction addValueRowAction;
    AddSubSelectAction addSubSelectAction;
    AddSubFullSelectAction addSubFullSelectAction;
    ChangeSetOperatorAction changeSetOperatorAction;
    DeleteStatementAction deleteStatementAction;
    ChangeStatementTypeAction changeStatementTypeAction;
    MenuManager menu;
    SQLBuilder sqlBuilder;
    SQLDomainModel domainModel;
    IContentProvider contentProvider;
    ILabelProvider labelProvider;
    Object input;

    public SQLTreeViewer(SQLBuilder sqlBuilder, IContentProvider contentProvider, ILabelProvider labelProvider, Object input) {
        this.sqlBuilder = sqlBuilder;
        this.domainModel = sqlBuilder.getDomainModel();
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.input = input;
        this.createActions(this.domainModel);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider(this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput((Object)new ItemProvider(Collections.singleton(this.input)));
        if (this.sqlBuilder != null) {
            this.menu = this.sqlBuilder.createContextMenuFor((Viewer)this.getTreeViewer());
        }
        if (this.input != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SQLTreeViewer.this.setSelection((ISelection)new StructuredSelection(SQLTreeViewer.this.input), true);
                }
            };
            Display.getCurrent().asyncExec(runnable);
        }
    }

    protected void defaultSelect(final Object selInput) {
        if (selInput != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SQLTreeViewer.this.setSelection((ISelection)new StructuredSelection(selInput), true);
                }
            };
            Display.getCurrent().asyncExec(runnable);
        }
    }

    public void resetInput(Object resetInput) {
        if (!this.isDisposed()) {
            this.getTreeViewer().setInput((Object)new ItemProvider(Collections.singleton(resetInput)));
            this.defaultSelect(resetInput);
        }
    }

    public boolean isDisposed() {
        return this.getTreeViewer() == null || this.getTreeViewer().getControl().isDisposed();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.getTreeViewer().setSelection(selection, reveal);
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() != null) {
            return super.getSelection();
        }
        return null;
    }

    private void createActions(SQLDomainModel createActionDomainModel) {
        this.addTableAction = new AddTableAction(createActionDomainModel);
        this.createJoinAction = new CreateJoinAction(createActionDomainModel);
        this.createWithTableAction = new CreateWithTableAction(createActionDomainModel);
        this.convertToFullSelectAction = new ConvertToFullSelectAction(createActionDomainModel);
        this.deleteStatementAction = new DeleteStatementAction(createActionDomainModel, this);
        this.changeStatementTypeAction = new ChangeStatementTypeAction();
        this.changeStatementTypeAction.setSQLBuilder(this.sqlBuilder);
        this.changeStatementTypeAction.setShell(Display.getCurrent().getActiveShell());
        this.addValuesAction = new AddValuesAction(createActionDomainModel);
        this.addValueRowAction = new AddValueRowAction(createActionDomainModel);
        this.addSubSelectAction = new AddSubSelectAction(createActionDomainModel);
        this.addSubFullSelectAction = new AddSubFullSelectAction(createActionDomainModel);
        this.changeSetOperatorAction = new ChangeSetOperatorAction();
        this.changeSetOperatorAction.setSQLBuilder(this.sqlBuilder);
        this.changeSetOperatorAction.setShell(Display.getCurrent().getActiveShell());
    }

    public void fillContextMenu() {
        ISelection selection = this.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object element = null;
            if (structuredSelection.iterator().hasNext()) {
                element = structuredSelection.iterator().next();
            }
            if (element instanceof QuerySelect) {
                QuerySelect select = element;
                if (select.getCombinedLeft() != null || select.getCombinedRight() != null) {
                    this.deleteStatementAction.setElement(element);
                    this.menu.add((IAction)this.deleteStatementAction);
                    this.convertToFullSelectAction.setElement(element);
                    this.menu.add((IAction)this.convertToFullSelectAction);
                }
                if (select.eContainer() instanceof WithTableSpecification) {
                    this.convertToFullSelectAction.setElement(element);
                    this.menu.add((IAction)this.convertToFullSelectAction);
                }
            } else if (element instanceof QueryCombined) {
                QueryCombined queryCombined = element;
                if (!SelectHelper.isNodeFull(queryCombined)) {
                    this.addSubSelectAction.setElement(element);
                    this.menu.add((IAction)this.addSubSelectAction);
                    this.addValuesAction.setElement(element);
                    this.menu.add((IAction)this.addValuesAction);
                    this.addSubFullSelectAction.setElement(element);
                    this.menu.add((IAction)this.addSubFullSelectAction);
                }
                this.deleteStatementAction.setElement(element);
                this.menu.add((IAction)this.deleteStatementAction);
                this.changeSetOperatorAction.setElement(queryCombined);
                this.menu.add((IAction)this.changeSetOperatorAction);
                if (this.domainModel.getVendor().isDB2() && !this.domainModel.getVendor().isDB2UDBOS390_V6()) {
                    this.addValuesAction.setEnabled(true);
                } else {
                    this.addValuesAction.setEnabled(false);
                }
                if (this.domainModel.getVendor().isCloudscape()) {
                    this.addValuesAction.setEnabled(true);
                }
            } else if (element instanceof QueryValues) {
                this.addValueRowAction.setElement(element);
                this.menu.add((IAction)this.addValueRowAction);
                this.menu.add((IContributionItem)new Separator());
                this.deleteStatementAction.setElement(element);
                this.menu.add((IAction)this.deleteStatementAction);
            } else if (element instanceof ValuesRow) {
                this.deleteStatementAction.setElement(element);
                this.menu.add((IAction)this.deleteStatementAction);
            } else if (element instanceof WithTableSpecification) {
                this.deleteStatementAction.setElement(element);
                this.menu.add((IAction)this.deleteStatementAction);
            } else if (element instanceof QueryExpressionRoot || element instanceof QuerySelectStatement) {
                this.createWithTableAction.setElement(element);
                this.menu.add((IAction)this.createWithTableAction);
                if (element instanceof QuerySelectStatement && SelectHelper.getQuerySelect(element) != null) {
                    this.convertToFullSelectAction.setElement(element);
                    this.menu.add((IAction)this.convertToFullSelectAction);
                }
                this.menu.add((IContributionItem)new Separator());
                this.menu.add((IAction)this.changeStatementTypeAction);
            } else if (element instanceof QueryInsertStatement) {
                this.addTableAction.setElement(element);
                this.menu.add((IAction)this.addTableAction);
                this.menu.add((IContributionItem)new Separator());
                this.menu.add((IAction)this.changeStatementTypeAction);
            } else if (element instanceof QueryUpdateStatement) {
                this.addTableAction.setElement(element);
                this.menu.add((IAction)this.addTableAction);
                this.menu.add((IContributionItem)new Separator());
                this.menu.add((IAction)this.changeStatementTypeAction);
            } else if (element instanceof QueryDeleteStatement) {
                this.addTableAction.setElement(element);
                this.menu.add((IAction)this.addTableAction);
                this.menu.add((IContributionItem)new Separator());
                this.menu.add((IAction)this.changeStatementTypeAction);
            }
        }
        this.enableMenus();
    }

    private void enableMenus() {
        boolean proper = SQLBuilder.isStatementProper(this.domainModel);
        this.addSubFullSelectAction.setEnabled(proper);
        this.addSubSelectAction.setEnabled(proper);
        this.addTableAction.setEnabled(proper);
        this.addValueRowAction.setEnabled(proper);
        this.addValuesAction.setEnabled(proper);
        this.createJoinAction.setEnabled(proper);
        this.createWithTableAction.setEnabled(proper);
    }

    public void refreshTree() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().refresh();
        }
    }

    public void selectRootElement() {
        if (this.getTreeViewer() != null) {
            Tree tree = this.getTreeViewer().getTree();
            TreeItem[] items = tree.getItems();
            TreeItem[] item = new TreeItem[]{items[0]};
            tree.setSelection(item);
            this.setSelection(this.getSelection(), true);
        }
    }

    public boolean isOnlyRootSelected() {
        Tree tree;
        boolean rootSelected = false;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (tree = treeViewer.getTree()) != null) {
            TreeItem topItem = tree.getTopItem();
            TreeItem selItem = null;
            if (tree.getSelectionCount() == 1) {
                selItem = tree.getSelection()[0];
            }
            if (selItem != null && selItem == topItem) {
                rootSelected = true;
            }
        }
        return rootSelected;
    }

    public void disableContentOutline() {
        if (this.getTreeViewer() != null) {
            Tree tree = this.getTreeViewer().getTree();
            tree.setEnabled(false);
        }
    }

    public void enableContentOutline() {
        if (this.getTreeViewer() != null && !this.getTreeViewer().getTree().isEnabled()) {
            this.getTreeViewer().getTree().setEnabled(true);
        }
    }
}

