/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HWPartition;
import oshi.hardware.platform.linux.LinuxDisks;
import oshi.hardware.platform.mac.MacDisks;
import oshi.hardware.platform.unix.freebsd.FreeBsdDisks;
import oshi.hardware.platform.unix.solaris.SolarisDisks;
import oshi.hardware.platform.windows.WindowsDisks;

public class HWDiskStore
implements Serializable,
Comparable<HWDiskStore> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HWDiskStore.class);
    private String model;
    private String name;
    private String serial;
    private long size;
    private long reads;
    private long readBytes;
    private long writes;
    private long writeBytes;
    private long transferTime;
    private HWPartition[] partitions;
    private long timeStamp;

    public HWDiskStore() {
        this("", "", "", 0L, 0L, 0L, 0L, 0L, 0L, new HWPartition[0], 0L);
    }

    public HWDiskStore(String name, String model, String serial, long size, long reads, long readBytes, long writes, long writeBytes, long transferTime, HWPartition[] partitions, long timeStamp) {
        this.setName(name);
        this.setModel(model);
        this.setSerial(serial);
        this.setSize(size);
        this.setReads(reads);
        this.setReadBytes(readBytes);
        this.setWrites(writes);
        this.setWriteBytes(writeBytes);
        this.setTransferTime(transferTime);
        this.setPartitions(partitions);
        this.setTimeStamp(timeStamp);
    }

    public boolean updateDiskStats() {
        boolean diskFound = false;
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                diskFound = WindowsDisks.updateDiskStats(this);
                break;
            }
            case LINUX: {
                diskFound = LinuxDisks.updateDiskStats(this);
                break;
            }
            case MACOSX: {
                diskFound = MacDisks.updateDiskStats(this);
                break;
            }
            case SOLARIS: {
                diskFound = SolarisDisks.updateDiskStats(this);
                break;
            }
            case FREEBSD: {
                diskFound = FreeBsdDisks.updateDiskStats(this);
                break;
            }
            default: {
                LOG.error("Unsupported platform. No update performed.");
            }
        }
        return diskFound;
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerial() {
        return this.serial;
    }

    public long getSize() {
        return this.size;
    }

    public long getReads() {
        return this.reads;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrites() {
        return this.writes;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public long getTransferTime() {
        return this.transferTime;
    }

    public HWPartition[] getPartitions() {
        return this.partitions;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public void setModel(String model) {
        this.model = model == null ? "" : model;
    }

    public void setSerial(String serial) {
        this.serial = serial == null ? "" : serial;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setReads(long reads) {
        this.reads = reads;
    }

    public void setReadBytes(long readBytes) {
        this.readBytes = readBytes;
    }

    public void setWrites(long writes) {
        this.writes = writes;
    }

    public void setWriteBytes(long writeBytes) {
        this.writeBytes = writeBytes;
    }

    public void setTransferTime(long transferTime) {
        this.transferTime = transferTime;
    }

    public void setPartitions(HWPartition[] partitions) {
        this.partitions = partitions;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public int compareTo(HWDiskStore store) {
        return this.getName().compareTo(store.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serial == null ? 0 : this.serial.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HWDiskStore)) {
            return false;
        }
        HWDiskStore other = (HWDiskStore)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.serial == null ? other.serial != null : !this.serial.equals(other.serial)) {
            return false;
        }
        return this.size == other.size;
    }
}

