/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Optional;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGColorConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.DrawableRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.render.AnnotatedSVGShape;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsToGraphics2DAdaptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SiriusGraphicsSVG
extends SiriusGraphicsToGraphics2DAdaptor
implements DrawableRenderedImage {
    private Document doc;

    public static SiriusGraphicsSVG getInstance(Rectangle viewPort, boolean svgTraceability) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNameSpace = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNameSpace, "svg", null);
        CustomSVGGraphics2D svgGraphics = new CustomSVGGraphics2D(doc, svgTraceability);
        svgGraphics.getGeneratorContext().setPrecision(3);
        svgGraphics.setSVGCanvasSize(new Dimension(viewPort.width, viewPort.height));
        svgGraphics.setupCustomShapeConverter();
        return new SiriusGraphicsSVG((SVGGraphics2D)svgGraphics, doc, svgNameSpace, viewPort);
    }

    public SVGGraphics2D getSVGGraphics2D() {
        return (SVGGraphics2D)this.getGraphics2D();
    }

    public void setCurrentId(String id) {
        ((CustomSVGGraphics2D)this.getSVGGraphics2D()).setCurrentId(id);
    }

    private SiriusGraphicsSVG(SVGGraphics2D graphics, Document doc, String svgNameSpace, Rectangle viewPort) {
        this(graphics, doc, svgNameSpace, new org.eclipse.swt.graphics.Rectangle(viewPort.x, viewPort.y, viewPort.width, viewPort.height));
    }

    private SiriusGraphicsSVG(SVGGraphics2D graphics, Document doc, String svgNameSpace, org.eclipse.swt.graphics.Rectangle viewPort) {
        super((Graphics2D)graphics, viewPort);
        this.doc = doc;
        this.paintNotCompatibleStringsAsBitmaps = false;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getRoot() {
        return this.getSVGGraphics2D().getRoot();
    }

    @Override
    public org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage drawRenderedImage(org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage srcImage, Rectangle rect, RenderingListener listener) {
        this.checkState();
        DOMTreeManager treeManager = this.getSVGGraphics2D().getDOMTreeManager();
        Point trans = this.getTranslationOffset();
        if (srcImage instanceof SVGImage) {
            RenderInfo info;
            Document document = ((SVGImage)srcImage).getDocument();
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            if ((document = DOMUtilities.deepCloneDocument((Document)document, (DOMImplementation)impl)) instanceof SVGOMDocument && (info = srcImage.getRenderInfo()) != null && info.getBackgroundColor() != null && info.getForegroundColor() != null) {
                SVGColorConverter.getInstance().replaceDocumentColors((SVGOMDocument)document, new Color(info.getBackgroundColor().red, info.getBackgroundColor().green, info.getBackgroundColor().blue), new Color(info.getForegroundColor().red, info.getForegroundColor().green, info.getForegroundColor().blue));
            }
            Element root = document.getDocumentElement();
            Element toAppend = (Element)this.doc.importNode(root, true);
            toAppend.setAttributeNS(null, "x", String.valueOf(rect.x + trans.x));
            toAppend.setAttributeNS(null, "y", String.valueOf(rect.y + trans.y));
            toAppend.setAttributeNS(null, "width", String.valueOf(rect.width));
            toAppend.setAttributeNS(null, "height", String.valueOf(rect.height));
            treeManager.appendGroup(toAppend, null);
            return srcImage;
        }
        return super.drawRenderedImage(srcImage, rect, listener);
    }

    private static class CustomSVGGraphics2D
    extends SVGGraphics2D {
        private boolean svgTraceability;
        private String currentId;

        public CustomSVGGraphics2D(Document doc, boolean svgTraceability) {
            super(doc);
            this.svgTraceability = svgTraceability;
        }

        public void setupCustomShapeConverter() {
            this.shapeConverter = new AnnotatedSVGShape(this.generatorCtx, "http://www.eclipse.org/sirius/diagram/1.1.0", this.svgTraceability);
            final GenericImageHandler handler = this.getGenericImageHandler();
            this.getGeneratorContext().setGenericImageHandler(new GenericImageHandler(){

                public void setDOMTreeManager(DOMTreeManager domTreeManager) {
                    handler.setDOMTreeManager(domTreeManager);
                }

                public AffineTransform handleImage(RenderableImage image, Element imageElement, double x, double y, double width, double height, SVGGeneratorContext generatorContext) {
                    return handler.handleImage(image, imageElement, x, y, width, height, generatorContext);
                }

                public AffineTransform handleImage(RenderedImage image, Element imageElement, int x, int y, int width, int height, SVGGeneratorContext generatorContext) {
                    return handler.handleImage(image, imageElement, x, y, width, height, generatorContext);
                }

                public AffineTransform handleImage(Image image, Element imageElement, int x, int y, int width, int height, SVGGeneratorContext generatorContext) {
                    return handler.handleImage(image, imageElement, x, y, width, height, generatorContext);
                }

                public Element createElement(SVGGeneratorContext generatorContext) {
                    Element result = handler.createElement(generatorContext);
                    if (svgTraceability) {
                        result.setAttributeNS("http://www.eclipse.org/sirius/diagram/1.1.0", "diagram:semanticTargetId", currentId);
                    }
                    return result;
                }
            });
        }

        public void setCurrentId(String id) {
            ((AnnotatedSVGShape)this.shapeConverter).setCurrentId(id);
            this.currentId = id;
        }

        public void drawString(String s, float x, float y) {
            Element group;
            Optional currentGroup;
            super.drawString(s, x, y);
            if (this.svgTraceability && (currentGroup = ReflectionHelper.getFieldValueWithoutException((Object)this.domGroupManager, (String)"currentGroup")).isPresent() && currentGroup.get() instanceof Element && (group = (Element)currentGroup.get()).getLastChild() instanceof Element) {
                ((Element)group.getLastChild()).setAttributeNS("http://www.eclipse.org/sirius/diagram/1.1.0", "diagram:semanticTargetId", this.currentId);
            }
        }
    }
}

