/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDEAuxiliaryState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.osgi.framework.Version;

public class PDEState
extends MinimalState {
    private final PDEAuxiliaryState fAuxiliaryState;
    private final ArrayList<IPluginModelBase> fTargetModels = new ArrayList();

    public PDEState(URI[] target, boolean addResolver, boolean removeDuplicates, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.fAuxiliaryState = new PDEAuxiliaryState();
        this.createNewTargetState(addResolver, target, monitor);
        if (removeDuplicates) {
            this.removeDuplicatesFromState(this.fState);
        }
        this.initializePlatformProperties();
        this.createTargetModels(this.fState.getBundles());
        this.clearOldCache();
        if (PDECore.DEBUG_MODEL) {
            System.out.println("Time to create state: " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void createNewTargetState(boolean resolve, URI[] uris, IProgressMonitor monitor) {
        this.fState = stateObjectFactory.createState(resolve);
        if (resolve) {
            final String systemBSN = this.getSystemBundle();
            this.fState.getResolver().setSelectionPolicy((Comparator)new Comparator<BaseDescription>(){

                @Override
                public int compare(BaseDescription bd1, BaseDescription bd2) {
                    long id2;
                    Version v2;
                    if (systemBSN.equals(bd1.getSupplier().getSymbolicName()) && !systemBSN.equals(bd2.getSupplier().getSymbolicName())) {
                        return -1;
                    }
                    if (!systemBSN.equals(bd1.getSupplier().getSymbolicName()) && systemBSN.equals(bd2.getSupplier().getSymbolicName())) {
                        return 1;
                    }
                    Version v1 = bd1.getVersion();
                    int versionCompare = this.versionCompare(v1, v2 = bd2.getVersion());
                    if (versionCompare != 0) {
                        return versionCompare;
                    }
                    BundleDescription s1 = bd1.getSupplier();
                    BundleDescription s2 = bd2.getSupplier();
                    String n1 = s1.getName();
                    String n2 = s2.getName();
                    if (n1 != null && n1.equals(n2)) {
                        boolean isQualifier;
                        int retValue = this.versionCompare(s1.getVersion(), s2.getVersion());
                        if (retValue == 0 && !(isQualifier = "qualifier".equals(v1.getQualifier()))) {
                            IWorkspaceRoot root;
                            String loc1 = s1.getLocation();
                            String loc2 = s2.getLocation();
                            if (loc1 != null && loc2 != null && !loc1.equals(loc2) && (root = ResourcesPlugin.getWorkspace().getRoot()) != null) {
                                Path p1 = new Path(loc1);
                                if (root.findContainersForLocationURI(URIUtil.toURI((IPath)p1)).length != 0) {
                                    return -1;
                                }
                                Path p2 = new Path(loc2);
                                if (root.findContainersForLocationURI(URIUtil.toURI((IPath)p2)).length != 0) {
                                    return 1;
                                }
                            }
                        }
                        return retValue;
                    }
                    long id1 = s1.getBundleId();
                    return id1 < (id2 = s2.getBundleId()) ? -1 : (id1 == id2 ? 0 : 1);
                }

                private int versionCompare(Version v1, Version v2) {
                    if (v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro()) {
                        if (v1.getQualifier().equals(v2.getQualifier())) {
                            return 0;
                        }
                        boolean q1 = "qualifier".equals(v1.getQualifier());
                        boolean q2 = "qualifier".equals(v2.getQualifier());
                        if (q1 && !q2) {
                            return -1;
                        }
                        if (q2 && !q1) {
                            return 1;
                        }
                    }
                    int versionCompare = -v1.compareTo(v2);
                    return versionCompare;
                }
            });
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDECoreMessages.PDEState_CreatingTargetModelState, (int)uris.length);
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            File file = PDEState.toFile(uri);
            if (file != null) {
                try {
                    subMonitor.subTask(file.getName());
                    this.addBundle(file, -1L);
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
                subMonitor.split(1);
            }
            ++n2;
        }
    }

    private static File toFile(URI uri) {
        IPath path = URIUtil.toPath((URI)uri);
        if (path != null) {
            return path.toFile();
        }
        PDECore.log(new IllegalArgumentException("Failed to convert URI to file: " + uri));
        return null;
    }

    @Override
    protected void addAuxiliaryData(BundleDescription desc, Map<String, String> manifest, boolean hasBundleStructure) {
        this.fAuxiliaryState.addAuxiliaryData(desc, manifest, hasBundleStructure);
    }

    private void removeDuplicatesFromState(State state) {
        BundleDescription[] bundles;
        BundleDescription[] bundleDescriptionArray = bundles = state.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription desc = bundleDescriptionArray[n2];
            String id = desc.getSymbolicName();
            BundleDescription[] conflicts = state.getBundles(id);
            if (conflicts.length > 1) {
                BundleDescription[] bundleDescriptionArray2 = conflicts;
                int n3 = conflicts.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription conflict = bundleDescriptionArray2[n4];
                    if (desc.getVersion().equals((Object)conflict.getVersion()) && desc.getBundleId() != conflict.getBundleId()) {
                        this.fState.removeBundle(desc);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private IPluginModelBase[] createTargetModels(BundleDescription[] bundleDescriptions) {
        LinkedHashMap<String, IPluginModelBase> models = new LinkedHashMap<String, IPluginModelBase>(1 * bundleDescriptions.length + 1);
        BundleDescription[] bundleDescriptionArray = bundleDescriptions;
        int n = bundleDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription desc = bundleDescriptionArray[n2];
            IPluginModelBase base = this.createExternalModel(desc);
            this.fTargetModels.add(base);
            models.put(desc.getSymbolicName(), base);
            ++n2;
        }
        if (models.isEmpty()) {
            return new IPluginModelBase[0];
        }
        return ((HashMap)models).values().toArray(new IPluginModelBase[models.size()]);
    }

    private IPluginModelBase createExternalModel(BundleDescription desc) {
        ExternalPluginModelBase model = null;
        model = desc.getHost() == null ? new ExternalPluginModel() : new ExternalFragmentModel();
        model.load(desc, this);
        model.setBundleDescription(desc);
        model.setEnabled(true);
        return model;
    }

    public IPluginModelBase[] getTargetModels() {
        return this.fTargetModels.toArray(new IPluginModelBase[this.fTargetModels.size()]);
    }

    private void clearOldCache() {
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
        File[] children = dir.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    String name = child.getName();
                    if (name.endsWith(".target") && name.length() > ".target".length()) {
                        CoreUtility.deleteContent(child);
                    } else if (name.endsWith(".workspace") && name.length() > ".workspace".length()) {
                        CoreUtility.deleteContent(child);
                    } else if (name.endsWith(".cache") && name.length() > ".cache".length()) {
                        CoreUtility.deleteContent(child);
                    }
                }
                ++n2;
            }
        }
    }

    public String getClassName(long bundleID) {
        return this.fAuxiliaryState.getClassName(bundleID);
    }

    public boolean hasExtensibleAPI(long bundleID) {
        return this.fAuxiliaryState.hasExtensibleAPI(bundleID);
    }

    public boolean isPatchFragment(long bundleID) {
        return this.fAuxiliaryState.isPatchFragment(bundleID);
    }

    public boolean hasBundleStructure(long bundleID) {
        return this.fAuxiliaryState.hasBundleStructure(bundleID);
    }

    public String getPluginName(long bundleID) {
        return this.fAuxiliaryState.getPluginName(bundleID);
    }

    public String getProviderName(long bundleID) {
        return this.fAuxiliaryState.getProviderName(bundleID);
    }

    public String[] getLibraryNames(long bundleID) {
        return this.fAuxiliaryState.getLibraryNames(bundleID);
    }

    public String getBundleLocalization(long bundleID) {
        return this.fAuxiliaryState.getBundleLocalization(bundleID);
    }

    public String getProject(long bundleID) {
        return this.fAuxiliaryState.getProject(bundleID);
    }

    public String getBundleSourceEntry(long bundleID) {
        return this.fAuxiliaryState.getBundleSourceEntry(bundleID);
    }
}

