/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.IOFolder;

public class IOResource
implements CResource {
    protected final File myFile;

    public IOResource(File file) {
        this.myFile = file.getAbsoluteFile();
    }

    public String getName() {
        return this.myFile.getName();
    }

    public static String getExtension(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1 || lastDot == name.length() - 1) {
            return "";
        }
        return name.substring(lastDot + 1);
    }

    public String getFullPath() {
        return this.myFile.getAbsolutePath();
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    public CFolder getParent() {
        return new IOFolder(this.myFile.getParentFile());
    }

    public boolean equals(Object other) {
        return other instanceof IOResource && ((IOResource)other).myFile.equals(this.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return String.valueOf(this.myFile);
    }

    public static String getWorkspaceCharset() {
        return ResourcesPlugin.getEncoding();
    }
}

