/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.infer;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.ast.IASTNode;
import org.eclipse.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.core.infer.InferEngine;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MultipleTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.core.Logger;

public class InferredType
extends ASTNode {
    char[] name;
    public ArrayList methods;
    public InferredAttribute[] attributes = new InferredAttribute[5];
    public int numberAttributes = 0;
    public HashtableOfObject attributesHash = new HashtableOfObject();
    public InferredType superClass;
    public InferredType referenceClass;
    public SourceTypeBinding binding;
    public boolean isDefinition;
    private TypeBinding resolvedType;
    public ClassScope scope;
    ReferenceBinding resolvedSuperType;
    public boolean isArray = false;
    public boolean isAnonymous = false;
    public boolean isObjectLiteral = false;
    private int nameStart = -1;
    public String inferenceProviderID;
    public String inferenceStyle;
    public ArrayList mixins;
    public int modifiers;
    private IFunctionDeclaration correspondingFunction;
    private boolean fIsGlobal;
    private InferredType[] fSynonyms;
    public static final char[] OBJECT_NAME = new char[]{'O', 'b', 'j', 'e', 'c', 't'};
    public static final char[] OBJECT_LITERAL_NAME = new char[]{'{', '}'};
    public static final char[] ARRAY_NAME = new char[]{'A', 'r', 'r', 'a', 'y'};
    public static final char[] FUNCTION_NAME = new char[]{'F', 'u', 'n', 'c', 't', 'i', 'o', 'n'};
    public static final char[] VOID_NAME = new char[]{'v', 'o', 'i', 'd'};
    public static final char[] GLOBAL_NAME = new char[]{'G', 'l', 'o', 'b', 'a', 'l'};
    public Object userData;
    boolean allStatic = false;

    public InferredType(char[] className) {
        this.name = className;
        this.sourceStart = -1;
        this.fIsGlobal = false;
        this.isDefinition = false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public char[] getSuperClassName() {
        return this.superClass != null ? this.superClass.getName() : OBJECT_NAME;
    }

    public InferredAttribute addAttribute(char[] name, IASTNode definer, int nameStart) {
        InferredAttribute attribute = this.findAttribute(name);
        if (attribute == null) {
            attribute = new InferredAttribute(name, this, definer);
            attribute.node = (ASTNode)definer;
            if (this.numberAttributes == this.attributes.length) {
                this.attributes = new InferredAttribute[this.numberAttributes * 2];
                System.arraycopy(this.attributes, 0, this.attributes, 0, this.numberAttributes);
            }
            this.attributes[this.numberAttributes++] = attribute;
            this.attributesHash.put(name, attribute);
            if (!this.isAnonymous) {
                this.updatePositions(definer.sourceStart(), definer.sourceEnd());
            }
        }
        attribute.nameStart = nameStart;
        return attribute;
    }

    public InferredAttribute replaceAttribute(char[] name, IASTNode definer, int nameStart) {
        InferredAttribute attribute = this.findAttribute(name);
        if (attribute == null) {
            return this.addAttribute(name, definer, nameStart);
        }
        this.attributesHash.removeKey(name);
        InferredAttribute newAttribute = new InferredAttribute(name, this, definer);
        newAttribute.node = (ASTNode)definer;
        int i = 0;
        while (i < this.numberAttributes) {
            if (this.attributes[i].equals(attribute)) {
                this.attributes[i] = newAttribute;
            }
            ++i;
        }
        this.attributesHash.put(name, newAttribute);
        if (!this.isAnonymous) {
            this.updatePositions(definer.sourceStart(), definer.sourceEnd());
        }
        newAttribute.nameStart = nameStart;
        return newAttribute;
    }

    public InferredAttribute addAttribute(InferredAttribute newAttribute) {
        ASTNode definer = newAttribute.node;
        InferredAttribute attribute = this.findAttribute(newAttribute.name);
        if (attribute == null) {
            if (this.numberAttributes == this.attributes.length) {
                this.attributes = new InferredAttribute[this.numberAttributes * 2];
                System.arraycopy(this.attributes, 0, this.attributes, 0, this.numberAttributes);
            }
            this.attributes[this.numberAttributes++] = newAttribute;
            this.attributesHash.put(newAttribute.name, newAttribute);
            if (!this.isAnonymous) {
                if (definer != null) {
                    this.updatePositions(definer.sourceStart(), definer.sourceEnd());
                } else {
                    this.updatePositions(newAttribute.sourceStart(), newAttribute.sourceEnd());
                }
            }
        }
        return newAttribute;
    }

    public InferredAttribute findAttribute(char[] name) {
        return (InferredAttribute)this.attributesHash.get(name);
    }

    public InferredMethod addConstructorMethod(char[] methodName, IFunctionDeclaration functionDeclaration, int nameStart) {
        InferredMethod method = this.addMethod(methodName, functionDeclaration, nameStart, true);
        method.isConstructor = true;
        this.setNameStart(nameStart);
        return method;
    }

    public InferredMethod addMethod(char[] methodName, IFunctionDeclaration functionDeclaration, int nameStart) {
        return this.addMethod(methodName, functionDeclaration, nameStart, false);
    }

    private InferredMethod addMethod(char[] methodName, IFunctionDeclaration functionDeclaration, int nameStart, boolean isConstructor) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)functionDeclaration;
        InferredMethod method = this.findMethod(methodName, methodDeclaration);
        if (method == null) {
            InferredType inType = this;
            if (methodDeclaration.getInferredMethod() != null && methodDeclaration.getInferredMethod().inType != null && !isConstructor && !methodDeclaration.getInferredMethod().isConstructor && !methodDeclaration.getInferredMethod().inType.isAnonymous && this.isAnonymous) {
                inType = methodDeclaration.getInferredMethod().inType;
            }
            method = new InferredMethod(methodName, methodDeclaration, inType);
            if (methodDeclaration.inferredMethod == null) {
                methodDeclaration.inferredMethod = method;
            } else if (isConstructor) {
                methodDeclaration.inferredMethod.inType = this;
                method.isStatic = methodDeclaration.inferredMethod.isStatic;
                method.bits = methodDeclaration.inferredMethod.bits;
            }
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            if (!this.isAnonymous && !isConstructor) {
                this.updatePositions(methodDeclaration.sourceStart, methodDeclaration.sourceEnd);
            }
            method.isConstructor = isConstructor;
            method.nameStart = nameStart;
        } else if (methodDeclaration.inferredMethod == null) {
            methodDeclaration.inferredMethod = method;
        }
        return method;
    }

    private InferredMethod replaceMethod(char[] methodName, IFunctionDeclaration functionDeclaration, int nameStart) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)functionDeclaration;
        InferredMethod method = this.findMethod(methodName, methodDeclaration);
        if (method == null) {
            return this.addMethod(methodName, functionDeclaration, nameStart);
        }
        InferredType inType = this;
        inType = methodDeclaration.getInferredMethod() != null && methodDeclaration.getInferredMethod().inType != null ? methodDeclaration.getInferredMethod().inType : this;
        this.methods.remove(method);
        InferredMethod newMethod = new InferredMethod(methodName, methodDeclaration, inType);
        if (methodDeclaration.inferredMethod == null) {
            methodDeclaration.inferredMethod = newMethod;
        } else if (methodDeclaration.inferredMethod.isConstructor) {
            newMethod.inType = methodDeclaration.inferredMethod.inType;
        }
        this.methods.add(newMethod);
        if (!this.isAnonymous) {
            this.updatePositions(methodDeclaration.sourceStart, methodDeclaration.sourceEnd);
        }
        newMethod.isConstructor = false;
        newMethod.nameStart = nameStart;
        return newMethod;
    }

    public InferredMethod findMethod(char[] methodName, IFunctionDeclaration methodDeclaration) {
        boolean isConstructor;
        boolean bl = isConstructor = methodName == TypeConstants.INIT;
        if (this.methods != null) {
            for (InferredMethod method : this.methods) {
                if (CharOperation.equals(methodName, method.name)) {
                    return method;
                }
                if (!isConstructor || !method.isConstructor) continue;
                return method;
            }
        }
        return null;
    }

    public TypeBinding resolveType(Scope scope, ASTNode node) {
        if (scope == null) {
            return null;
        }
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.isArray()) {
            TypeBinding memberType;
            TypeBinding typeBinding = memberType = this.referenceClass != null ? this.referenceClass.resolveType(scope, node) : null;
            if (memberType == null) {
                memberType = TypeBinding.UNKNOWN;
            }
            this.resolvedType = new ArrayBinding(memberType, 1, scope.compilationUnitScope().environment);
        } else {
            if (CharOperation.indexOf('|', this.name) > 0) {
                char[][] names = CharOperation.splitAndTrimOn('|', this.name);
                this.resolvedType = new MultipleTypeBinding(scope, names);
            } else {
                this.resolvedType = scope.getType(this.name);
            }
            if (!this.resolvedType.isValidBinding()) {
                this.resolvedType = null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (node != null && !this.resolvedType.isValidBinding()) {
            scope.problemReporter().invalidType(node, this.resolvedType);
            return null;
        }
        if (node != null && node.isTypeUseDeprecated(this.resolvedType, scope)) {
            scope.problemReporter().deprecatedType(this.resolvedType, node);
        }
        if (!this.isNamed()) {
            this.resolvedType.tagBits |= 0x34L;
        }
        return this.resolvedType;
    }

    public void dumpReference(StringBuffer sb) {
        sb.append(this.name);
        if (this.referenceClass != null) {
            sb.append('(');
            this.referenceClass.dumpReference(sb);
            sb.append(')');
        }
    }

    public boolean containsMethod(IAbstractFunctionDeclaration inMethod) {
        if (this.methods != null) {
            for (InferredMethod method : this.methods) {
                if (method.getFunctionDeclaration() != inMethod) continue;
                return true;
            }
        }
        return false;
    }

    public ReferenceBinding resolveSuperType(ClassScope classScope) {
        TypeBinding typeBinding;
        if (this.resolvedSuperType != null) {
            return this.resolvedSuperType;
        }
        if (this.superClass != null && (typeBinding = classScope.getType(this.superClass.getName())) instanceof ReferenceBinding) {
            this.resolvedSuperType = (ReferenceBinding)typeBinding;
        }
        return this.resolvedSuperType;
    }

    public boolean isArray() {
        return CharOperation.equals(ARRAY_NAME, this.name);
    }

    public boolean isFunction() {
        return CharOperation.equals(FUNCTION_NAME, this.name);
    }

    public boolean isVoid() {
        return CharOperation.equals(VOID_NAME, this.name);
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        InferredType.printIndent(indent, output);
        char[] superName = this.getSuperClassName();
        output.append("class ").append(this.name).append(" extends ").append(superName).append("{\n");
        int i = 0;
        while (i < this.numberAttributes) {
            this.attributes[i].print(indent + 1, output);
            output.append(";\n");
            ++i;
        }
        if (this.methods != null) {
            for (InferredMethod method : this.methods) {
                method.print(indent + 1, output);
                output.append("\n");
            }
        }
        output.append("}");
        return output;
    }

    @Override
    public boolean isInferred() {
        return true;
    }

    public void updatePositions(int start, int end) {
        if (this.sourceStart == -1 || start >= 0 && start < this.sourceStart) {
            this.sourceStart = start;
        }
        if (end > 0 && end > this.sourceEnd) {
            this.sourceEnd = end;
        }
    }

    public IAbstractFunctionDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int i = 0;
            int max = this.methods.size();
            while (i < max) {
                InferredMethod method = (InferredMethod)this.methods.get(i);
                if (method.methodBinding == methodBinding) {
                    return method.getFunctionDeclaration();
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isNamed() {
        return !this.isAnonymous || !CharOperation.prefixEquals(IInferEngine.ANONYMOUS_PREFIX, this.name);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setNameStart(int start) {
        this.nameStart = start;
    }

    public int getNameStart() {
        return this.nameStart != -1 ? this.nameStart : this.sourceStart;
    }

    public boolean isEmptyGlobal() {
        return CharOperation.equals(GLOBAL_NAME, this.name) && this.numberAttributes == 0 && (this.methods == null || this.methods.isEmpty());
    }

    public void addMixin(char[] mixinTypeName) {
        if (this.mixins == null) {
            this.mixins = new ArrayList();
        }
        if (!this.mixins.contains(mixinTypeName)) {
            this.mixins.add(mixinTypeName);
        }
    }

    public void mixin(InferredType mixin) {
        if (mixin != null) {
            InferredAttribute[] attributes = mixin.attributes;
            ArrayList methods = mixin.methods;
            if (methods == null) {
                methods = new ArrayList(1);
            }
            InferredType mixSuperType = mixin.getSuperType();
            while (mixSuperType != null && !CharOperation.equals(mixSuperType.getName(), TypeConstants.OBJECT)) {
                InferredAttribute[] tempAttributes = new InferredAttribute[attributes.length + mixSuperType.numberAttributes];
                System.arraycopy(attributes, 0, tempAttributes, 0, attributes.length);
                System.arraycopy(mixSuperType.attributes, 0, tempAttributes, attributes.length - 1, mixSuperType.numberAttributes);
                attributes = tempAttributes;
                if (mixSuperType.methods != null) {
                    methods.addAll(mixSuperType.methods);
                }
                mixSuperType = mixSuperType.getSuperType();
            }
            int a = 0;
            while (a < attributes.length) {
                if (attributes[a] != null && !attributes[a].isStatic) {
                    InferredAttribute attr = this.replaceAttribute(attributes[a].name, attributes[a].node, attributes[a].nameStart);
                    attr.type = attributes[a].type;
                    attr.isStatic = false;
                    attr.nameStart = attributes[a].nameStart;
                    attr.modifiers = attributes[a].modifiers;
                    attr.initializationStart = attributes[a].initializationStart;
                }
                ++a;
            }
            int m = 0;
            while (m < methods.size()) {
                InferredMethod functToMixin = (InferredMethod)methods.get(m);
                if (!functToMixin.isConstructor && !functToMixin.isStatic) {
                    this.replaceMethod(functToMixin.name, functToMixin.getFunctionDeclaration(), functToMixin.nameStart);
                }
                ++m;
            }
        }
    }

    public void mixin(InferredType mixin, boolean isDeepCopy) {
        if (!isDeepCopy) {
            this.mixin(mixin);
        } else if (mixin != null) {
            InferredAttribute[] attributes = mixin.attributes;
            ArrayList methods = mixin.methods;
            if (methods == null) {
                methods = new ArrayList(1);
            }
            InferredType mixSuperType = mixin.getSuperType();
            while (mixSuperType != null && !CharOperation.equals(mixSuperType.getName(), TypeConstants.OBJECT)) {
                InferredAttribute[] tempAttributes = new InferredAttribute[attributes.length + mixSuperType.numberAttributes];
                System.arraycopy(attributes, 0, tempAttributes, 0, attributes.length);
                System.arraycopy(mixSuperType.attributes, 0, tempAttributes, attributes.length - 1, mixSuperType.numberAttributes);
                attributes = tempAttributes;
                if (mixSuperType.methods != null) {
                    methods.addAll(mixSuperType.methods);
                }
                mixSuperType = mixSuperType.getSuperType();
            }
            int a = 0;
            while (a < attributes.length) {
                if (attributes[a] != null && !attributes[a].isStatic) {
                    InferredAttribute existingAttr = this.findAttribute(attributes[a].name);
                    if (existingAttr != null && existingAttr.type != null && existingAttr.type.isAnonymous) {
                        existingAttr.type.mixin(attributes[a].type, true);
                    } else {
                        InferredAttribute attr = this.replaceAttribute(attributes[a].name, attributes[a].node, attributes[a].nameStart);
                        attr.type = attributes[a].type;
                        attr.isStatic = false;
                        attr.nameStart = attributes[a].nameStart;
                        attr.modifiers = attributes[a].modifiers;
                        attr.initializationStart = attributes[a].initializationStart;
                    }
                }
                ++a;
            }
            int m = 0;
            while (m < methods.size()) {
                InferredMethod functToMixin = (InferredMethod)methods.get(m);
                if (!functToMixin.isConstructor && !functToMixin.isStatic) {
                    this.replaceMethod(functToMixin.name, functToMixin.getFunctionDeclaration(), functToMixin.nameStart);
                }
                ++m;
            }
        }
    }

    public InferredType getSuperType() {
        return this.superClass;
    }

    public void setSuperType(InferredType superType) {
        InferredType testType = superType;
        while (testType != null) {
            if (testType == this) {
                if (InferEngine.DEBUG) {
                    Logger.log(2, "InferredType#setSuperType: a hierarchy loop would be caused between: " + new String(this.getName()) + " and " + new String(superType.getName()));
                }
                return;
            }
            testType = testType.getSuperType();
        }
        this.superClass = superType;
    }

    public boolean isIndexed() {
        return this.isGlobal() || this.isNamed();
    }

    public void setIsGlobal(boolean isGlobal) {
        this.fIsGlobal = isGlobal;
    }

    public boolean isGlobal() {
        return this.fIsGlobal;
    }

    public boolean isDefinition() {
        return this.isDefinition;
    }

    public void setIsDefinition(boolean isDefinition) {
        this.isDefinition = isDefinition;
    }

    public InferredType[] getSynonyms() {
        return this.fSynonyms;
    }

    public void addSynonym(InferredType type) {
        if (!(type == this || CharOperation.equals(type.getName(), this.getName()) || this.getSuperType() != null && CharOperation.equals(type.getName(), this.getSuperType().getName()) || type.getSuperType() != null && CharOperation.equals(this.getName(), type.getSuperType().getName()))) {
            if (this.fSynonyms == null) {
                this.fSynonyms = new InferredType[]{type};
            } else {
                boolean alreadyContains = false;
                int i = 0;
                while (i < this.fSynonyms.length && !alreadyContains) {
                    alreadyContains = type == this.fSynonyms[i];
                    ++i;
                }
                if (!alreadyContains) {
                    InferredType[] synonyms = new InferredType[this.fSynonyms.length + 1];
                    System.arraycopy(this.fSynonyms, 0, synonyms, 0, this.fSynonyms.length);
                    synonyms[this.fSynonyms.length] = type;
                    this.fSynonyms = synonyms;
                }
            }
        }
    }

    public IFunctionDeclaration getCorrespondingFunction() {
        return this.correspondingFunction;
    }

    public void setCorrespondingFunction(IFunctionDeclaration coorespondingFunction) {
        this.correspondingFunction = coorespondingFunction;
    }
}

