/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumExceptionBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;

public abstract class JsBreakpointPropertiesAction
implements IObjectActionDelegate {
    private Runnable currentRunnable;
    private IWorkbenchPartSite site = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
    }

    public void run(IAction action) {
        this.currentRunnable.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentRunnable = this.createRunnable(selection);
        action.setEnabled(this.currentRunnable != null);
    }

    protected abstract boolean isCorrectType(IBreakpoint var1);

    private Runnable createRunnable(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() != 1) {
            return null;
        }
        Object element = structuredSelection.getFirstElement();
        if (!(element instanceof IBreakpoint)) {
            return null;
        }
        final IBreakpoint breakpoint = (IBreakpoint)element;
        if (!this.isCorrectType(breakpoint)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                JsBreakpointPropertiesAction.runAction(breakpoint, (IShellProvider)JsBreakpointPropertiesAction.this.site);
            }
        };
    }

    protected static void runAction(IBreakpoint breakpoint, IShellProvider shell) {
        PreferenceDialog propertyDialog = PreferencesUtil.createPropertyDialogOn((Shell)shell.getShell(), (IAdaptable)breakpoint, null, null, null);
        propertyDialog.open();
    }

    public static class Exception
    extends JsBreakpointPropertiesAction {
        @Override
        protected boolean isCorrectType(IBreakpoint breakpoint) {
            return breakpoint instanceof ChromiumExceptionBreakpoint;
        }
    }

    public static class Line
    extends JsBreakpointPropertiesAction {
        @Override
        protected boolean isCorrectType(IBreakpoint breakpoint) {
            return breakpoint instanceof ChromiumLineBreakpoint;
        }
    }
}

