/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2.logs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;

public final class ParseErrorsLogReportEntry
implements IReportEntry {
    private void writeBadNodes(ZipOutputStream outputStream, String title, AstEditor editor, EditorState.BadNodesCollection badNodes) throws IOException {
        if (!badNodes.isEmpty()) {
            outputStream.putNextEntry(new ZipEntry("parse-errors/" + title));
            try {
                List<EditorState.BadNodeInformation> nodes = badNodes.nodes();
                for (EditorState.BadNodeInformation badNode : nodes) {
                    IOUtils2.writeString((OutputStream)outputStream, (String)editor.getSource(badNode.getNode()));
                    this.writeSmallDivider(outputStream);
                    IOUtils2.writeString((OutputStream)outputStream, (String)ExceptionUtils.getStackTrace((Throwable)badNode.getException()));
                    this.writeDivider(outputStream);
                }
            }
            finally {
                outputStream.closeEntry();
            }
        }
    }

    private void writeWarnings(ZipOutputStream outputStream, List<EditorWarning> warnings) throws IOException {
        if (!warnings.isEmpty()) {
            outputStream.putNextEntry(new ZipEntry("parse-errors/warnings.txt"));
            try {
                for (EditorWarning editorWarning : warnings) {
                    IOUtils2.writeString((OutputStream)outputStream, (String)editorWarning.getMessage());
                    this.writeSmallDivider(outputStream);
                    IOUtils2.writeString((OutputStream)outputStream, (String)ExceptionUtils.getStackTrace((Throwable)editorWarning.getException()));
                    this.writeDivider(outputStream);
                }
            }
            finally {
                outputStream.closeEntry();
            }
        }
    }

    private void writeDivider(OutputStream outputStream) throws IOException {
        IOUtils2.writeString((OutputStream)outputStream, (String)"\r\n==================================================\r\n\r\n");
    }

    private void writeSmallDivider(OutputStream outputStream) throws IOException {
        IOUtils2.writeString((OutputStream)outputStream, (String)"\r\n----\r\n");
    }

    public void write(ZipOutputStream zipStream) throws Exception {
        JavaInfo javaInfo = EditorState.getActiveJavaInfo();
        if (javaInfo == null) {
            return;
        }
        AstEditor editor = javaInfo.getEditor();
        EditorState editorState = EditorState.get(editor);
        if (editorState == null) {
            return;
        }
        this.writeWarnings(zipStream, editorState.getWarnings());
        this.writeBadNodes(zipStream, "bad-refresh-nodes.txt", editor, editorState.getBadRefreshNodes());
        this.writeBadNodes(zipStream, "bad-parser-nodes.txt", editor, editorState.getBadParserNodes());
    }
}

