/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.VariableDeferredPConstraint;

public abstract class BaseTypeSafeConstraint
extends VariableDeferredPConstraint {
    protected Set<PVariable> inputVariables;
    protected PVariable outputVariable;

    public PVariable getOutputVariable() {
        return this.outputVariable;
    }

    public BaseTypeSafeConstraint(PBody pBody, Set<PVariable> inputVariables, PVariable outputVariable) {
        super(pBody, outputVariable == null ? inputVariables : Stream.concat(inputVariables.stream(), Stream.of(outputVariable)).collect(Collectors.toSet()));
        this.inputVariables = inputVariables;
        this.outputVariable = outputVariable;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        if (this.outputVariable == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.outputVariable);
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        return this.inputVariables;
    }

    @Override
    public boolean isReadyAt(SubPlan plan, IQueryMetaContext context) {
        if (super.isReadyAt(plan, context)) {
            return this.checkTypeSafety(plan, context) == null;
        }
        return false;
    }

    public PVariable checkTypeSafety(SubPlan plan, IQueryMetaContext context) {
        Set<TypeJudgement> impliedJudgements = plan.getAllImpliedTypeJudgements(context);
        for (PVariable pVariable : this.inputVariables) {
            Set<TypeJudgement> allTypeRestrictionsForVariable = this.pBody.getAllUnaryTypeRestrictions(context).get(pVariable);
            if (allTypeRestrictionsForVariable == null || impliedJudgements.containsAll(allTypeRestrictionsForVariable)) continue;
            return pVariable;
        }
        return null;
    }

    @Override
    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (this.inputVariables.remove(obsolete)) {
            this.inputVariables.add(replacement);
        }
        if (this.outputVariable == obsolete) {
            this.outputVariable = replacement;
        }
    }
}

