/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.algorithms;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OrderedIterableMerge {
    private OrderedIterableMerge() {
    }

    public static <T> Iterable<T> mergeUniques(Iterable<T> first, Iterable<T> second, final Comparator<T> comparator) {
        return () -> new Iterator<T>(first, second){
            Iterator<T> firstIterator;
            Iterator<T> secondIterator;
            T firstItem;
            T secondItem;
            {
                this.firstIterator = iterable.iterator();
                this.secondIterator = iterable2.iterator();
                this.fetchFirst();
                this.fetchSecond();
            }

            private T fetchFirst() {
                Object previous = this.firstItem;
                this.firstItem = this.firstIterator.hasNext() ? this.firstIterator.next() : null;
                return previous;
            }

            private T fetchSecond() {
                Object previous = this.secondItem;
                this.secondItem = this.secondIterator.hasNext() ? this.secondIterator.next() : null;
                return previous;
            }

            @Override
            public boolean hasNext() {
                return this.firstItem != null || this.secondItem != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.firstItem != null && this.secondItem != null) {
                    if (this.secondItem == this.firstItem) {
                        this.fetchFirst();
                        return this.fetchSecond();
                    }
                    if (comparator.compare(this.firstItem, this.secondItem) < 0) {
                        return this.fetchFirst();
                    }
                    return this.fetchSecond();
                }
                if (this.firstItem != null) {
                    return this.fetchFirst();
                }
                return this.fetchSecond();
            }
        };
    }
}

